package com.ejianc.business.settle.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettleDeductEntity;
import com.ejianc.business.settle.bean.SettleOddjobEntity;
import com.ejianc.business.settle.mapper.SettleDeductMapper;
import com.ejianc.business.settle.mapper.SettleOddjobMapper;
import com.ejianc.business.settle.service.ISettleOddjobService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 结算子表-零工登记
 *
 * @author generator
 */
@Service("settleOddjobService")
public class SettleOddjobServiceImpl extends BaseServiceImpl<SettleOddjobMapper, SettleOddjobEntity>
        implements ISettleOddjobService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    SettleOddjobMapper mapper;

    /**
     * 查询零工登记列表数据（已生效、没有被节点结算引用、日期小于等于结算日期、日期倒序排列）
     * 零工登记
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @param settleDate 结算日期
     * @return List<SettleOddjobEntity>
     */
    @Override
    public List<SettleOddjobEntity> queryOddjobList(Integer settleType, Long contractId, Date settleDate) {
        return mapper.queryOddjobList(settleType, contractId, settleDate);
    }

    /**
     * 查询零工登记列表数据（已生效、没有被节点结算引用、日期小于等于结算日期、日期倒序排列）
     * 零工转扣
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @param settleDate 结算日期
     * @return List<SettleOddjobEntity>
     */
    @Override
    public List<SettleOddjobEntity> queryOddjobDeductList(Integer settleType, Long contractId, Date settleDate) {
        return mapper.queryOddjobDeductList(settleType, contractId, settleDate);
    }

    /**
     * 查询零工登记 列表数据（已生效、没有被节点结算引用 日期倒序排列）
     * @param page 封装的请求参数
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @return IPage<SettlePickingEntity>
     */
    @Override
    public IPage<SettleOddjobEntity> selectPageSalary(Page<SettleOddjobEntity> page, Integer settleType, Long contractId) {
        return mapper.selectPageOddjob(page, settleType, contractId);
    }
}
