CREATE TABLE `ejc_prosub_plan`  (
  `id` bigint NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int NULL DEFAULT NULL COMMENT '版本锁',
  `project_id` bigint NULL DEFAULT NULL COMMENT '所属项目Id',
  `project_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目名称',
  `project_code` varchar(255) NULL COMMENT '所属项目编码',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计划编码',
  `total_plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '总计划金额',
  `total_plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '总计划金额(无税)',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `org_id` bigint NULL DEFAULT NULL COMMENT '所属项目部Id',
  `org_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目部名称',
  `change_state` tinyint NULL DEFAULT NULL COMMENT '变更状态',
  `bill_state` tinyint NULL DEFAULT NULL COMMENT '单据状态',
  `change_id` bigint NULL DEFAULT NULL COMMENT '当前对应的变更计划Id',
  `create_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `modify_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人名称',
  `effective_date` datetime NULL DEFAULT NULL COMMENT '生效日期',
  `change_version` int NULL DEFAULT NULL COMMENT '变更版本',
  `employee_id` bigint NULL COMMENT '经办人id',
  `employee_name` varchar(32) NULL COMMENT '经办人',
  `department_id` bigint NULL COMMENT '经办单位id',
  `department_name` varchar(64) NULL COMMENT '经办单位',
  `parent_org_id` bigint NULL DEFAULT NULL COMMENT '项目部上级组织id',
  `parent_org_name` varchar(64) NULL COMMENT '项目部上级组织名称',
  `parent_org_code` varchar(64) NULL COMMENT '项目部上级组织编码',
  `sub_type` tinyint NULL COMMENT '分包类型 0-劳务分包 1-专业分包',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc_prosub_plan_change`  (
  `id` bigint NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int NULL DEFAULT NULL COMMENT '版本锁',
  `project_id` bigint NULL DEFAULT NULL COMMENT '所属项目Id',
  `project_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目名称',
  `project_code` varchar(255) NULL COMMENT '所属项目编码',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计划编码',
  `total_plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '现计划金额',
  `total_plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '现计划金额无税',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `org_id` bigint NULL DEFAULT NULL COMMENT '所属项目部Id',
  `org_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目部名称',
  `bill_state` tinyint NULL DEFAULT NULL COMMENT '单据状态',
  `change_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更人',
  `change_reason` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更原因',
  `original_plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '原计划金额',
  `original_plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '原计划金额无税',
  `source_plan_id` bigint NULL DEFAULT NULL COMMENT '源计划数据Id',
  `create_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `modify_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人名称',
  `effective_date` datetime NULL DEFAULT NULL COMMENT '生效日期',
  `change_version` int NULL DEFAULT NULL COMMENT '变更版本',
  `employee_id` bigint NULL COMMENT '经办人id',
  `employee_name` varchar(32) NULL COMMENT '经办人',
  `department_id` bigint NULL COMMENT '经办单位id',
  `department_name` varchar(64) NULL COMMENT '经办单位',
  `parent_org_id` bigint NULL DEFAULT NULL COMMENT '项目部上级组织id',
  `parent_org_name` varchar(64) NULL COMMENT '项目部上级组织名称',
  `parent_org_code` varchar(64) NULL COMMENT '项目部上级组织编码',
  `sub_type` tinyint NULL COMMENT '分包类型 0-劳务分包 1-专业分包',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc_prosub_plan_change_his`  (
  `id` bigint NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int NULL DEFAULT NULL COMMENT '版本锁',
  `project_id` bigint NULL DEFAULT NULL COMMENT '所属项目Id',
  `project_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目名称',
  `project_code` varchar(255) NULL COMMENT '所属项目编码',
  `employee_id` bigint NULL COMMENT '经办人id',
  `employee_name` varchar(32) NULL COMMENT '经办人',
  `department_id` bigint NULL COMMENT '经办单位id',
  `department_name` varchar(64) NULL COMMENT '经办单位',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计划编码',
  `total_plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '现计划金额',
  `total_plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '现计划金额无税',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `org_id` bigint NULL DEFAULT NULL COMMENT '所属项目部Id',
  `org_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目部名称',
  `bill_state` int NULL DEFAULT NULL COMMENT '单据状态',
  `change_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更人',
  `change_reason` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更原因',
  `original_plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '原计划金额',
  `original_plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '原计划金额无税',
  `source_plan_id` bigint NULL DEFAULT NULL COMMENT '源计划数据Id',
  `create_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `modify_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人名称',
  `effective_date` datetime NULL DEFAULT NULL COMMENT '生效日期',
  `change_version` int NULL DEFAULT NULL COMMENT '变更版本',
  `sub_type` tinyint NULL COMMENT '分包类型 0-劳务分包 1-专业分包',
  `change_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更金额',
  `change_ratio` decimal(28, 8) NULL DEFAULT NULL COMMENT '本次变更比例',
  `change_plan_id` bigint NULL DEFAULT NULL COMMENT '变更计划Id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc_prosub_plan_detail`  (
  `id` bigint NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int NULL DEFAULT NULL COMMENT '版本锁',
  `plan_id` bigint NULL DEFAULT NULL COMMENT '所属总计划Id',
  `source_type` tinyint NULL DEFAULT NULL COMMENT '来源：1-目标成本，2-分包档案',
  `source_id` bigint NULL DEFAULT NULL COMMENT '来源业务Id',
  `doc_category_id` bigint NULL DEFAULT NULL COMMENT '档案分类Id',
  `doc_id` bigint NULL DEFAULT NULL COMMENT '档案Id',
  `detail_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单编号',
  `detail_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单名称',
  `work_content` varchar(255) NULL COMMENT '工作内容',
  `detail_measurement_rules` varchar(255) NULL COMMENT '计量规则',
  `unit` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位',
  `target_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '目标量',
  `plan_num` decimal(28, 8) NULL COMMENT '计划量',
  `plan_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价',
  `tax_rate` decimal(28, 8) NULL COMMENT '税率',
  `plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额',
  `plan_tax_price` decimal(28, 8) NULL COMMENT '单价（含税）',
  `plan_tax_mny` decimal(28, 8) NULL COMMENT '金额（含税）',
  `tax` decimal(28, 8) NULL COMMENT '税额',
  `change_type` tinyint NULL DEFAULT NULL COMMENT '变更类型: 1-增补项，2-删除项，3-变更项',
  `change_type_desc` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更类型描述',
  `target_id` bigint NULL DEFAULT NULL COMMENT '变更项原数据Id',
  `memo` varchar(512) NULL COMMENT '备注',
  `parent_id` bigint NULL COMMENT '父ID',
  `leaf_flag` tinyint NULL COMMENT '是否末级',
  `tree_index` varchar(64) NULL COMMENT '序号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc_prosub_plan_detail_change`  (
  `id` bigint NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int NULL DEFAULT NULL COMMENT '版本锁',
  `plan_id` bigint NULL DEFAULT NULL COMMENT '所属总计划Id',
  `source_type` tinyint NULL DEFAULT NULL COMMENT '来源：1-目标成本，2，分包档案',
  `source_id` bigint NULL DEFAULT NULL COMMENT '来源业务Id',
  `doc_category_id` bigint NULL DEFAULT NULL COMMENT '档案分类Id',
  `doc_id` bigint NULL DEFAULT NULL COMMENT '档案Id',
  `detail_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单编号',
  `detail_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单名称',
  `job_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `detail_measure_rules` varchar(255) NULL COMMENT '计量规则',
  `unit` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位',
  `target_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '目标量',
  `plan_num` decimal(28, 8) NULL COMMENT '计划量',
  `plan_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价',
  `tax_rate` decimal(28, 8) NULL COMMENT '税率',
  `plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额',
  `plan_tax_price` decimal(28, 8) NULL COMMENT '单价（含税）',
  `plan_tax_mny` decimal(28, 8) NULL COMMENT '金额（含税）',
  `tax` decimal(28, 8) NULL COMMENT '税额',
  `change_type` tinyint NULL DEFAULT NULL COMMENT '变更类型: 1-增补项，2-删除项，3-变更项',
  `change_type_desc` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更类型描述',
  `target_id` bigint NULL DEFAULT NULL COMMENT '变更项原数据Id',
  `original_target_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '原目标量',
  `original_plan_num` decimal(28, 8) NULL COMMENT '原计划量',
  `memo` varchar(512) NULL COMMENT '备注',
  `parent_id` bigint NULL COMMENT '父ID',
  `leaf_flag` tinyint NULL COMMENT '是否末级',
  `tree_index` varchar(64) NULL COMMENT '序号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc_prosub_plan_detail_change_his`  (
  `id` bigint NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int NULL DEFAULT NULL COMMENT '版本锁',
  `plan_id` bigint NULL DEFAULT NULL COMMENT '所属总计划Id',
  `source_type` tinyint NULL DEFAULT NULL COMMENT '来源：1-目标成本，2-分包档案',
  `source_id` bigint NULL DEFAULT NULL COMMENT '来源出业务Id',
  `doc_category_id` bigint NULL DEFAULT NULL COMMENT '清单分类Id',
  `doc_id` bigint NULL DEFAULT NULL COMMENT '清单Id',
  `detail_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单编号',
  `detail_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单名称',
  `job_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `detail_measure_rules` varchar(255) NULL COMMENT '计量规则',
  `unit` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位',
  `target_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '目标量',
  `plan_num` decimal(28, 8) NULL COMMENT '计划量',
  `plan_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价',
  `tax_rate` decimal(28, 8) NULL COMMENT '税率',
  `plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额',
  `plan_tax_price` decimal(28, 8) NULL COMMENT '单价（含税）',
  `plan_tax_mny` decimal(28, 8) NULL COMMENT '金额（含税）',
  `tax` decimal(28, 8) NULL COMMENT '税额',
  `change_type` tinyint NULL DEFAULT NULL COMMENT '变更类型: 1-增补项，2-删除项，3-变更项',
  `change_type_desc` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更类型描述',
  `target_id` bigint NULL DEFAULT NULL COMMENT '变更项原数据Id',
  `parent_id` bigint NULL DEFAULT NULL COMMENT '父ID',
  `leaf_flag` tinyint NULL DEFAULT NULL COMMENT '是否末级',
  `tree_index` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序号',
  `memo` varchar(512) NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

