SET FOREIGN_KEY_CHECKS=0;

CREATE TABLE `ejc-conbase`.`ejc_conbase_contract_clause_category_relation`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `clause_id` bigint(20) NULL DEFAULT NULL COMMENT '合同条款Id',
  `category_id` bigint(20) NULL DEFAULT NULL COMMENT '合同类别Id',
  `category_inner_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同分类内码',
  `category_property` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同内码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '合同条款分类关系' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-conbase`.`ejc_conbase_contract_clause_setting`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `clause_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '条款名称',
  `enable_status` tinyint(4) NULL DEFAULT NULL COMMENT '启用状态：0-停用，1-启用',
  `enable_type` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '1-全部分类可用，2-部分分类可用',
  `range_names` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '可用分类名称',
  `sequence` int(11) NULL DEFAULT NULL COMMENT '排序号',
  `code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '合同条款设置' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-conbase`.`ejc_conbase_contract_template`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `category_id` bigint(20) NULL DEFAULT NULL COMMENT '所属分类主键Id',
  `category_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属分类名称',
  `cur_version_id` bigint(20) NULL DEFAULT NULL COMMENT '当前最新版本Id',
  `template_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板名称',
  `file_type` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件类型: w-doc,p-ppt,s-excel,f-pdf',
  `file_size` bigint(20) NULL DEFAULT NULL COMMENT '文件大小（B为单位）',
  `sequence` int(11) NULL DEFAULT NULL COMMENT '排序号',
  `file_path` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件路径',
  `online_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '预览地址',
  `description` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板描述',
  `file_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板文件名称',
  `enable_status` tinyint(4) NULL DEFAULT NULL COMMENT '停启用状态：0停用，1-启用',
  `file_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件id',
  `cur_version` bigint(20) NULL DEFAULT NULL COMMENT '当前最新版本号',
  `code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编码',
  `bill_type_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分类对应单据类型编码，每个大的分类对应一种单据类型',
  `metadata` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '模板元数据',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '合同模板' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-conbase`.`ejc_conbase_contract_template_category`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `category_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分类名称',
  `inner_code` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '内码',
  `pid` bigint(20) NULL DEFAULT NULL COMMENT '父级分类Id',
  `enable_status` tinyint(4) NULL DEFAULT NULL COMMENT '启用状态：0-停用，1-启用',
  `source_type` tinyint(4) NULL DEFAULT NULL COMMENT '类别：0-内置项，1-新增项',
  `code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分类编码',
  `sequence` int(11) UNSIGNED NULL DEFAULT NULL COMMENT '排序号',
  `category_property` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分类属性：每个大的分类下该属性保持一致',
  `is_top` int(11) NULL DEFAULT NULL COMMENT '0-固定分类，1-下级分类',
  `bill_type_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分类对应单据类型编码，每个大的分类对应一种单据类型',
  `contract_property_id` bigint(20) NULL DEFAULT NULL COMMENT '合同属性Id',
  `contract_property_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同属性名称',
  `contract_property_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同属性编码',
  `p_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父级分类名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '合同模板分类' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-conbase`.`ejc_conbase_contract_template_version`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `template_version` bigint(20) NULL DEFAULT NULL COMMENT '版本号',
  `template_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板名称',
  `file_path` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件路径',
  `file_size` bigint(20) NULL DEFAULT NULL COMMENT '文件大小（B为单位）',
  `file_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板文件类型',
  `online_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '在线预览地址',
  `category_id` bigint(20) NULL DEFAULT NULL COMMENT '所属分类Id',
  `category_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属分类名称',
  `file_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板文件名称',
  `template_id` bigint(20) NULL DEFAULT NULL COMMENT '对应模板Id',
  `sequence` int(11) NULL DEFAULT NULL COMMENT '排序号',
  `file_id` bigint(20) NULL DEFAULT NULL COMMENT '文件id',
  `bill_type_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分类对应单据类型编码，每个大的分类对应一种单据类型',
  `metadata` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '模板元数据',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '合同模板版本' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-conbase`.`ejc_conbase_seal_management`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `source_seal_id` bigint(20) NULL DEFAULT NULL COMMENT '印章ID（第三方返回）',
  `source_seal_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章名称',
  `seal_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签章类型，COMPANY(\"企业公章\"),LP(\"法定代表人章\")',
  `source_key` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章图片key',
  `img_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '图片地址',
  `source_status_description` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方返回的印章状态名称',
  `source_status` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方返回的印章状态，NORMAL(\"正 常\"),FREEZE(\"冻结\"),DELETE(\"删 除\"),INVALID(\"失效\")',
  `enable_status` int(11) NULL DEFAULT NULL COMMENT '印章状态，1-启用，0-停用',
  `seal_category` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章类型，PHYSICS(物理章),ELECTRONIC(电子章)',
  `source_company_id` bigint(20) NULL DEFAULT NULL COMMENT '公司ID,第三方',
  `source_company_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属公司名称，第三方',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '组织id',
  `org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属组织名称',
  `seal_sub_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章类型（类别）子类别',
  `seal_sub_type_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章类型名称子类别',
  `is_match` tinyint(1) NULL DEFAULT NULL COMMENT '是否匹配 1匹配 0 不匹配',
  `bill_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编码',
  `seal_use_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章使用者 \',\'拼接',
  `seal_default_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '默认印章使用者',
  `seal_default_id` bigint(50) NULL DEFAULT NULL COMMENT '默认印章使用者id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '印章管理' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-conbase`.`ejc_conbase_seal_management_user`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `user_id` bigint(20) NULL DEFAULT NULL COMMENT '用户id',
  `user_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户名称',
  `source_user_id` bigint(20) NULL DEFAULT NULL COMMENT '用户id（第三方系统返回的）',
  `source_user_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户名称（第三方系统返回的）',
  `phone` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '手机号',
  `email` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '邮箱',
  `user_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户类型,user-使用者,manager-管理员',
  `pid` bigint(20) NULL DEFAULT NULL COMMENT '印章管理表id',
  `is_default` int(20) NULL DEFAULT NULL COMMENT '是否是默认的印章 1-是； 0-否',
  `source_seal_id` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '印章管理子表-用户' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-conbase`.`ejc_conbase_signature_setting`  (
  `default_seal_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '默认印章名',
  `unit_category` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位类别',
  `org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部编码',
  `org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部名称',
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `create_id` bigint(20) NULL DEFAULT NULL COMMENT '创建人id 自用',
  `unit_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位名称',
  `unit_id` bigint(20) NULL DEFAULT NULL COMMENT '单位id',
  `parent_org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部所属组织编码',
  `parent_org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部所属组织名称',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部所属组织id',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `create_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人名字',
  `code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编码',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部id',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `enable_status` int(11) NULL DEFAULT NULL COMMENT '状态，1-启用，0-停用',
  `seal_create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建人名自用',
  `org_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '签章设置' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-conbase`.`ejc_conbase_signature_setting_sub`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `seal_id` bigint(20) NULL DEFAULT NULL COMMENT '印章id,印章管理主键id',
  `source_seal_id` bigint(20) NULL DEFAULT NULL COMMENT '印章ID（第三方返回）',
  `source_seal_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章名称',
  `seal_category` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章类别',
  `pid` bigint(50) NULL DEFAULT NULL COMMENT '签章设置表id',
  `source_status` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方返回的印章状态，NORMAL(\"正 常\"),FREEZE(\"冻结\"),DELETE(\"删 除\"),INVALID(\"失效\")\n ',
  `seal_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签章类型，COMPANY(\"企业公章\"),LP(\"法定代表人章\")',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '签章设置子表' ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS=1;