


-- 分包价格库-清单明细
CREATE TABLE `ejc_prosub_price_contract`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者账号',
  `update_time` datetime(0) DEFAULT NULL COMMENT '修改时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者账号',
  `dr` tinyint(4) DEFAULT 0 COMMENT '删除标识',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) DEFAULT 0 COMMENT '版本号',

  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单据编号',
  `bill_state` tinyint(2) DEFAULT 0 COMMENT '单据状态（审批必须字段）',

  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `contract_flag` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-主合同 1-补充协议',
  `performance_status` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】',
  `pc_card_url` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同来源地址',

  `supplier_id` bigint(20) DEFAULT NULL COMMENT '乙方Id',
  `supplier_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '乙方名称',
  `project_id` bigint(20) DEFAULT NULL COMMENT '项目ID',
  `project_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目名称',
  `project_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目编号',
  `org_id` bigint(20) DEFAULT NULL COMMENT '所属单位id',
  `org_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所属单位名称',
  `org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所属单位编码',
  `parent_org_id` bigint(20) DEFAULT NULL COMMENT '父级组织',
  `parent_org_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `parent_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目部上级组织编码',

  `area` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目地区',
  `area_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目地区',
  `measure_rule` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计量规则',
  `work_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `sign_date` date DEFAULT NULL COMMENT '签订时间',

  `contract_tax_rate` decimal(28, 8) DEFAULT NULL COMMENT '税率',
  `contract_num` decimal(28, 8) DEFAULT NULL COMMENT '数量',
  `contract_price` decimal(28, 8) DEFAULT NULL COMMENT '合同单价(无税)',
  `contract_tax_price` decimal(28, 8) DEFAULT NULL COMMENT '单价(含税)',
  `contract_mny` decimal(28, 8) DEFAULT NULL COMMENT '合同金额(无税)',
  `contract_tax_mny` decimal(28, 8) DEFAULT NULL COMMENT '合同金额(含税)',

  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '备注',
  `out_flag` tinyint(4) DEFAULT NULL COMMENT '是否移除（0-否未移除，1-是）',

  `doc_id` bigint(20) DEFAULT NULL COMMENT '清单id-档案Id',
  `doc_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '清单编码-档案编码',
  `doc_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '清单名称-档案名称',
  `doc_category_id` bigint(20) DEFAULT NULL COMMENT '所属上级id-档案分类Id',
  `doc_category_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所属上级名称-档案分类名称',
  `doc_inner_code` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '分类内码',
  `unit_id` bigint(20) DEFAULT NULL COMMENT '计量单位主键',
  `unit_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '计量单位',
  `price_type_id` bigint(20) DEFAULT NULL COMMENT '价格类型id',
  `price_type_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '价格类型',

  `target_result_id` bigint(20) DEFAULT NULL COMMENT '定标结果Id',

  `source_id` bigint(20) DEFAULT NULL COMMENT '来源id',
  `settlement_date` date DEFAULT NULL COMMENT '结算日期（最终结算日期）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分包价格库-清单明细' ROW_FORMAT = Compact;



CREATE TABLE `ejc_prosub_price_guide`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者账号',
  `update_time` datetime(0) DEFAULT NULL COMMENT '修改时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者账号',
  `dr` tinyint(4) DEFAULT 0 COMMENT '删除标识',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) DEFAULT 0 COMMENT '版本号',

  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单据编号',
  `bill_state` tinyint(2) DEFAULT 0 COMMENT '单据状态（审批必须字段）',

  `theme` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '主题',
  `org_id` bigint(20) DEFAULT NULL COMMENT '组织id',
  `org_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '组织名称',
  `org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '组织编码',
  `employee_id` bigint(20) DEFAULT NULL COMMENT '发布人id',
  `employee_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '发布人名称',
  `publish_date` date DEFAULT NULL COMMENT '发布日期',
  `flag` tinyint(4) DEFAULT NULL COMMENT '开启状态(0-开启,1-关闭)',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '描述',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',

  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分包指导价' ROW_FORMAT = Compact;



CREATE TABLE `ejc_prosub_price_guide_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者账号',
  `update_time` datetime(0) DEFAULT NULL COMMENT '修改时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者账号',
  `dr` tinyint(4) DEFAULT 0 COMMENT '删除标识',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) DEFAULT 0,

  `guide_id` bigint(20) NOT NULL COMMENT '主表ID',
  `doc_id` bigint(20) DEFAULT NULL COMMENT '清单id-档案Id',
  `doc_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '清单编码-档案编码',
  `doc_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '清单名称-档案名称',
  `doc_category_id` bigint(20) DEFAULT NULL COMMENT '所属上级id-档案分类Id',
  `doc_category_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所属上级名称-档案分类名称',
  `doc_inner_code` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '分类内码',

  `unit_id` bigint(20) DEFAULT NULL COMMENT '计量单位主键',
  `unit_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '计量单位',

  `min_price` decimal(28, 8) DEFAULT NULL COMMENT '最低价(无税)',
  `min_tax_price` decimal(28, 8) DEFAULT NULL COMMENT '最低价(含税)',
  `max_price` decimal(28, 8) DEFAULT NULL COMMENT '最高价(无税)',
  `max_tax_price` decimal(28, 8) DEFAULT NULL COMMENT '最高价(含税)',

  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '备注',
  `contract_price_area` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '合同价格区间（无税）',
  `contract_tax_price_area` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '合同价格区间（含税）',
  `market_price` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市场价（无税）',
  `market_tax_price` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '市场价（含税）',

  `source_id` bigint(20) DEFAULT NULL COMMENT '来源id',
  `source_type` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '来源类型（laborPriceLib-劳务分包价格库，proPriceLib-专业分包价格库,proSubDoc-专业分包档案，laborSubDoc-劳务分包档案)',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分包指导价-价格明细' ROW_FORMAT = Compact;

