CREATE TABLE `ejc_contract_lawsuit`
(
    `id`                          bigint(20)     DEFAULT NULL COMMENT '主键ID',
    `create_user_id`              bigint(20)     DEFAULT NULL COMMENT '创建者账号',
    `create_user_code`            varchar(64)    DEFAULT NULL COMMENT '创建时间',
    `create_time`                 datetime       DEFAULT NULL COMMENT '修改者账号',
    `update_user_code`            varchar(64)    DEFAULT NULL COMMENT '修改者账号',
    `update_time`                 datetime       DEFAULT NULL COMMENT '修改时间',
    `dr`                          tinyint(4)     DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
    `tenant_id`                   bigint(20)     DEFAULT NULL COMMENT '租户ID',
    `sync_es_flag`                tinyint(4)     DEFAULT NULL COMMENT '是否同步es',
    `version`                     int(11)        DEFAULT NULL COMMENT '版本号',
    `bill_code`                   varchar(64)    DEFAULT NULL COMMENT '单据编码',
    `bill_state`                  tinyint(4)     DEFAULT NULL COMMENT '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
    `org_id`                      bigint(20)     DEFAULT NULL COMMENT '项目部id',
    `org_code`                    varchar(64)    DEFAULT NULL COMMENT '项目部编码',
    `org_name`                    varchar(128)   DEFAULT NULL COMMENT '项目部名称',
    `parent_org_id`               bigint(20)     DEFAULT NULL COMMENT '项目部所属组织id',
    `parent_org_code`             varchar(64)    DEFAULT NULL COMMENT '项目部所属组织编码',
    `parent_org_name`             varchar(128)   DEFAULT NULL COMMENT '项目部所属组织名称',
    `contract_id`                 bigint(20)     DEFAULT NULL COMMENT '合同id',
    `contract_name`               varchar(128)   DEFAULT NULL COMMENT '合同名称',
    `contract_code`               varchar(64)    DEFAULT NULL COMMENT '合同编码',
#     是否集采合同

#    合同分类 contract_property
    `contract_category_id`        bigint(20)     DEFAULT NULL COMMENT '合同类别id',
    `contract_category_code`      varchar(64)    DEFAULT NULL COMMENT '合同类别编码',
    `contract_category_name`      varchar(128)   DEFAULT NULL COMMENT '合同类别名称',


    `supplement_flag`             tinyint(4)     DEFAULT NULL COMMENT '是否主合同：0-主合同 1-补充协议',
    `project_id`                  bigint(20)     DEFAULT NULL COMMENT '项目Id',
    `project_name`                varchar(128)   DEFAULT NULL COMMENT '项目名称',
    `project_code`                varchar(64)    DEFAULT NULL COMMENT '项目编号',
    `supplier_id`                 bigint(20)     DEFAULT NULL COMMENT '乙方id（供应商）',
    `supplier_name`               varchar(128)   DEFAULT NULL COMMENT '乙方名称（供应商）',
    `contract_tax_mny`            decimal(28, 8) DEFAULT NULL COMMENT '合同金额',
    `settle_mny`            decimal(28, 8) DEFAULT NULL COMMENT '结算金额',
    `settle_date`               datetime       DEFAULT NULL COMMENT '结算日期',
    `lawsuit_settle_mny`            decimal(28, 8) DEFAULT NULL COMMENT '诉讼费结算金额',
    `memo`                        varchar(1024)  DEFAULT NULL COMMENT '备注 非必填，0-500字',

    `employee_id`                 bigint(20)     DEFAULT NULL COMMENT '经办人id（申请人）',
    `employee_name`               varchar(128)   DEFAULT NULL COMMENT '经办人名称（申请人）',
    `department_id`               bigint(20)     DEFAULT NULL COMMENT '经办（申请人）部门id',
    `department_name`             varchar(128)   DEFAULT NULL COMMENT '经办（申请人）部门名称'
) comment '付款申请';
# 子表
CREATE TABLE `ejc_contract_pay_detail`
(
    `id`                        bigint(20)     DEFAULT NULL COMMENT '主键ID',
    `create_user_id`            bigint(20)     DEFAULT NULL COMMENT '创建者账号',
    `create_user_code`          varchar(64)    DEFAULT NULL COMMENT '创建时间',
    `create_time`               datetime       DEFAULT NULL COMMENT '修改者账号',
    `update_user_code`          varchar(64)    DEFAULT NULL COMMENT '修改者账号',
    `update_time`               datetime       DEFAULT NULL COMMENT '修改时间',
    `dr`                        tinyint(4)     DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除',
    `tenant_id`                 bigint(20)     DEFAULT NULL COMMENT '租户ID',
    `sync_es_flag`              tinyint(4)     DEFAULT NULL COMMENT '是否同步es ',
    `version`                   int(11)        DEFAULT NULL COMMENT '版本号',
    `pay_id`                    bigint(20)     DEFAULT NULL COMMENT '付款申请id',
    `source_id`                 bigint(20)     DEFAULT NULL COMMENT '结算id 来源',
    `source_bill_code`          varchar(64)    DEFAULT NULL COMMENT '结算单据号',
    `source_type`               varchar(20)    DEFAULT NULL COMMENT '来源类型',
    `contract_id`               bigint(20)     DEFAULT NULL COMMENT '合同id',
    `project_org_id`            bigint(20)     DEFAULT NULL COMMENT '项目部所属组织id',
    `supplier_id`               bigint(20)     DEFAULT NULL COMMENT '乙方id',

    `settle_date`               datetime       DEFAULT NULL COMMENT '结算日期',
    `current_settle_mny`        decimal(28, 8) DEFAULT NULL COMMENT '本期结算金额',
    `current_apply_mny`         decimal(28, 8) DEFAULT NULL COMMENT '本期申请金额',
    `already_apply_mny`         decimal(28, 8) DEFAULT NULL COMMENT '已申请金额',
    `residue_apply_mny`         decimal(28, 8) DEFAULT NULL COMMENT '剩余可申请金额',
    `advance_payment_deduction` decimal(28, 8) DEFAULT NULL COMMENT '预付款扣减分摊',
    `actual_payment_mny`        decimal(28, 8) DEFAULT NULL COMMENT '实际付款金额',
    `actual_apply_mny`          decimal(28, 8) DEFAULT NULL COMMENT '实际申请占用金额 默认等于申请金额 关闭后默认等于实际付款 ',

    `memo`                      varchar(1024)  DEFAULT NULL COMMENT '备注 非必填，0-500字'

) comment '付款申请 详情';
