create table `ejc-prosub`.ejc_prosub_team
(
    id                 bigint(20)    not null comment '主键ID'
        primary key,
    create_user_code   varchar(50)   null comment '创建者账号',
    create_time        datetime      null comment '创建时间',
    update_user_code   varchar(50)   null comment '修改者账号',
    update_time        datetime      null comment '修改时间',
    dr                 tinyint       null comment '删除标识',
    tenant_id          bigint(20)    null comment '租户ID',
    sync_es_flag       tinyint       null comment '是否同步es(1:是，0：否)',
    version            int           null comment '乐观锁',


    contract_id        bigint(20)    null comment '合同id',
    contract_name      varchar(50)   null comment '合同名称',
    contract_code      varchar(50)   null comment '合同编码',
    supplement_flag    tinyint(4) DEFAULT NULL COMMENT '是否主合同：0-主合同 1-补充协议',
    compile_name       varchar(50)   null comment '编制人',
    compile_id         bigint(20)    null comment '编制人id ',
    compile_date       date          null comment '编制日期',
    org_id             bigint(20)    null comment '项目组织ID',
    org_name           varchar(128)  null comment '项目组织名称',
    parent_org_code    varchar(50)   null comment '组织编码',
    parent_org_name    varchar(50)   null comment '组织名称',
    parent_org_id      bigint(20)    null comment '组织id',
    memo               varchar(1024) null comment '备注',
    contract_type      tinyint(4)    null comment '合同类型：0-劳务合同 1-专业合同',
    contract_type_name varchar(50)   null comment '合同类型名称',
    project_id         bigint        null comment '项目Id',
    project_name       varchar(50)   null comment '项目名称（带入）',
    project_code       varchar(50)   null comment '项目编号',
    supplier_id        bigint(20)    null comment '供应商id',
    supplier_name      varchar(50)   null comment '供应商名称',
    team_users         text          null comment '供应商名称',
    commit_data        datetime      null comment '提交日期',
    bill_state         tinyint       null comment '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
    bill_code          varchar(50)   null comment '编码',
    commit_date        datetime      null comment '提交日期',
    effective_date     datetime      null comment '生效日期',
    commit_user_code   varchar(50)   null comment '提交人账号',
    commit_user_name   varchar(50)   null comment '提交人名字'
) comment '班组主表';

create table `ejc-prosub`.ejc_prosub_team_detail
(
    id                 bigint(20)    not null comment '主键ID'
        primary key,
    create_user_code   varchar(50)   null comment '创建者账号',
    create_time        datetime      null comment '创建时间',
    update_user_code   varchar(50)   null comment '修改者账号',
    update_time        datetime      null comment '修改时间',
    dr                 tinyint       null comment '删除标识',
    tenant_id          bigint(20)    null comment '租户ID',
    sync_es_flag       tinyint       null comment '是否同步es(1:是，0：否)',
    version            int           null comment '乐观锁',
    team_id            bigint(20)    null comment '父表id',
    team_contract_id   bigint(20)    null comment '合同id',
    team_contract_name varchar(50)   null comment '合同名称',
    team_user_name     varchar(50)   null comment '联系人',
    team_user_phone    varchar(50)   null comment '联系电话',
    team_user_card     varchar(50)   null comment '身份证号码',

    team_detail_name   varchar(50)   null comment '班组名称',
    team_detail_status varchar(20)   null comment '班组状态 0停用;1 启用',
    memo               varchar(1024) null comment '备注'
) comment '班组子表';

alter table `ejc-prosub`.ejc_prosub_team
    add contract_type tinyint(4) null comment '合同类型：0-劳务合同 1-专业合同' after memo;

alter table `ejc-prosub`.ejc_prosub_team
    add contract_type_name varchar(50) null comment '合同类型名称' after contract_type;

ALTER TABLE `ejc-prosub`.`ejc_prosub_team`
    ADD COLUMN `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id';
ALTER TABLE `ejc-prosub`.`ejc_prosub_team`
    ADD COLUMN `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编码';
ALTER TABLE `ejc-prosub`.`ejc_prosub_team`
    ADD COLUMN `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称';



ALTER TABLE `ejc-prosub`.`ejc_prosub_team_detail`
    ADD COLUMN `team_user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '联系人';
ALTER TABLE `ejc-prosub`.`ejc_prosub_team_detail`
    ADD COLUMN `team_user_phone` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '联系电话';
ALTER TABLE `ejc-prosub`.`ejc_prosub_team_detail`
    ADD COLUMN `team_user_card` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '身份证号码';


ALTER TABLE `ejc-prosub`.`ejc_prosub_team`
    ADD COLUMN `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商Id';
ALTER TABLE `ejc-prosub`.`ejc_prosub_team`
    ADD COLUMN `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商名称';
ALTER TABLE `ejc-prosub`.`ejc_prosub_team`
    ADD COLUMN `team_users` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '班组';

