alter table ejc_prosub_settle
    add con_contract_name varchar(256) null comment '承包合同名称',
    add con_contract_code varchar(128) null comment '承包合同编码',
    add con_contract_id bigint null comment '承包合同id',
    add contract_currency bigint null comment '承包合同币种',
    add contract_exchange_rate decimal(20,8) null comment '承包合同汇率',
    add contract_amount decimal(20,8) null comment '承包合同金额',
    add contract_rmb_amount decimal(20,8) null comment '承包合同人民币金额',
    add sub_contract_currency bigint null comment '分包合同币种',
    add sub_contract_exchange_rate decimal(20,8) null comment '分包合同汇率',
    add sub_contract_amount decimal(20,8) null comment '分包合同金额',
    add sub_contract_rmb_amount decimal(20,8) null comment '分包合同人民币金额',
    add apply_tax_rate decimal(20,8) null comment '报审税率',
    add apply_settlement_amount_in decimal(20,8) null comment '合同内结算报审金额',
    add currency bigint null comment '报审币种',
    add exchange_rate decimal(20,8) null comment '汇率',
    add apply_settlement_rmb_amount_in decimal(20,8) null comment '合同内结算报审金额（人民币）',
    add apply_settlement_amount_out decimal(20,8) null comment '合同外报审金额',
    add apply_settlement_rmb_amount_out decimal(20,8) null comment '合同外报审金额（人民币）',
    add apply_total decimal(20,8) null comment '报审总额',
    add apply_total_excute_tax decimal(20,8) null comment '报审总额（不含税）',
    add taxes decimal(20,8) null comment '报审税金（综合汇总）',
    add composite_tax_rate decimal(20,8) null comment '综合税率',
    add settlement_sub_date datetime null comment '结算提交日期',
    add apply_handling_department varchar(64) null comment '报审经办部门',
    add apply_operator bigint null comment '报审经办人',
    add apply_handling_date datetime null comment '报审经办日期',
    add apply_remark varchar(200) null comment '报审备注',
    add apply_handling_department_id bigint null comment '报审经办部门id',
    add apply_operator_code varchar(64) null comment '报审经办人账号',
    add first_trial_tax_rate decimal(20,8) null comment '初审税率',
    add first_trial_amount decimal(20,8) null comment '初审金额',
    add first_trial_reduce_amount decimal(20,8) null comment '初审减金额',
    add first_trial_reduction_rate decimal(20,8) null comment '初审核减率',
    add first_trial_rmb_amount decimal(20,8) null comment '初审金额（人民币）',
    add first_trial_reduce_rmb_amount decimal(20,8) null comment '初审减金额（人民币）',
    add first_trial_amount_in decimal(20,8) null comment '初审合同内金额',
    add first_trial_reduce_amount_in decimal(20,8) null comment '合同内核减金额',
    add first_trial_amount_out decimal(20,8) null comment '初审合同外金额',
    add first_trial_reduce_amount_out decimal(20,8) null comment '合同外初审核减金额',
    add first_trial_department varchar(64) null comment '初审经办部门',
    add first_trial_operator bigint null comment '初审经办人',
    add first_trial_finish_date datetime null comment '初审完成时间',
    add first_trial_remark varchar(256) null comment '初审备注',
    add first_trial_department_id bigint null comment '初审经办部门id',
    add first_trial_operator_code varchar(64) null comment '初审经办人账号',
    add reexamine_tax_rate decimal(20,8) null comment '复审税率',
    add reexamine_amount decimal(20,8) null comment '复审金额',
    add reexamine_reduce_amount decimal(20,8) null comment '复审核减金额',
    add reexamine_reduction_rate decimal(20,8) null comment '复审核减率',
    add reexamine_rmb_amount decimal(20,8) null comment '复审金额（人民币）',
    add reexamine_reduce_rmb_amount decimal(20,8) null comment '复审核减金额（人民币）',
    add reexamine_amount_in decimal(20,8) null comment '复审合同内金额',
    add reexamine_reduce_amount_in decimal(20,8) null comment '合同内核减金额',
    add reexamine_amount_out decimal(20,8) null comment '复审合同外金额',
    add reexamine_reduce_amount_out decimal(20,8) null comment '合同外复审核减金额',
    add reexamine_deviation decimal(20,8) null comment '审核偏差',
    add reexamine_deviation_rmb decimal(20,8) null comment '审核偏差（人民币）',
    add reexamine_deviation_rate decimal(20,8) null comment '复审偏差率',
    add reexamine_department varchar(64) null comment '复审经办部门',
    add reexamine_operator bigint null comment '复审经办人',
    add reexamine_finish_date datetime null comment '复审审核完成时间',
    add reexamine_remark varchar(256) null comment '复审备注',
    add reexamine_department_id bigint null comment '复审经办部门id',
    add reexamine_operator_code varchar(64) null comment '复审经办人账号';


alter table ejc_prosub_settle_detail
    add first_trial_settlement_count decimal(20,8) null comment '初审结算量',
    add first_trial_main_price decimal(20,8) null comment '初审主材单价',
    add first_trial_construction_price decimal(20,8) null comment '初审施工单价',
    add first_trial_main_amount decimal(20,8) null comment '初审主材费',
    add first_trial_construction_amount decimal(20,8) null comment '初审施工费',
    add first_trial_amount decimal(20,8) null comment '初审金额',
    add first_trial_amount_excute_tax decimal(20,8) null comment '初审不含税金额',
    add reexamine_settlement_count decimal(20,8) null comment '复审结算量',
    add reexamine_main_price decimal(20,8) null comment '复审主材单价',
    add reexamine_construction_price decimal(20,8) null comment '复审施工单价',
    add reexamine_main_amount decimal(20,8) null comment '复审主材费',
    add reexamine_construction_amount decimal(20,8) null comment '复审施工费',
    add reexamine_amount decimal(20,8) null comment '复审金额',
    add tax_rate decimal(20,8) null comment '税率',
    add parent_source_bill_code varchar(128) null comment '父单据CODE',
    add reexamine_amount_excute_tax decimal(20,8) null comment '复审不含税金额';


create table ejc_prosub_settle_change_visa_claim
(
    id                bigint         not null comment '主键ID'
        primary key,
    create_user_code  varchar(64)    null comment '创建者账号',
    create_time       datetime       null comment '创建时间',
    update_user_code  varchar(64)    null comment '修改者账号',
    update_time       datetime       null comment '修改时间',
    dr                tinyint        null comment '删除标识',
    tenant_id         bigint         null comment '租户ID',
    sync_es_flag      tinyint        null comment '是否同步es(1:是，0：否)',
    version           int            null comment '乐观锁',
    amount_excute_tax decimal(20, 8) null comment '金额（不含税）',
    settle_id         bigint         null comment '结算id',
    visa_No           varchar(64)    null comment '签证编号',
    title             varchar(64)    null comment '标题',
    amount            decimal(20, 8) null comment '金额',
    tax_rate          decimal(20, 8) null comment '税率'
)
    comment '变更签证索赔费用';




