package com.ejianc.business.pro.supplier.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 供应商专家组长考察列表
 * 
 * @author generator
 * 
 */
public class InvExpertLeaderVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long canInId; // 准入单id
    private String code; // 单据编码
    private Integer billState; // 单据状态
    private String billStateName; // 单据状态
    private String supplierName; // 供应商名称
    private String mainBusiness; // 主营类别
    private Long applyOrgId; // 申请单位id
    private String applyOrgName; // 申请单位
    private Long leaderId; // 考察组长id
    private String leader; // 考察组长
    private String exportIds; // 考察专家ids
    private String exportNames; // 考察专家
    private String schedule; // 考察进度
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 考察开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date submitDate; // 提交日期
    private Integer score; // 平均得分
    private String result; // 考察结果：合格  不合格
    private String memo; // 汇总说明
    private Long gradeId; // 建议评定等级
    private String sourceFrom; // 数据来源 supplier  subLeader

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getSourceFrom() {
        return sourceFrom;
    }

    public void setSourceFrom(String sourceFrom) {
        this.sourceFrom = sourceFrom;
    }

    public Long getCanInId() {
        return canInId;
    }

    public void setCanInId(Long canInId) {
        this.canInId = canInId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMainBusiness() {
        return mainBusiness;
    }

    public void setMainBusiness(String mainBusiness) {
        this.mainBusiness = mainBusiness;
    }
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    public Long getLeaderId() {
        return leaderId;
    }

    public void setLeaderId(Long leaderId) {
        this.leaderId = leaderId;
    }
    public String getLeader() {
        return leader;
    }

    public void setLeader(String leader) {
        this.leader = leader;
    }
    public String getExportIds() {
        return exportIds;
    }

    public void setExportIds(String exportIds) {
        this.exportIds = exportIds;
    }
    public String getExportNames() {
        return exportNames;
    }

    public void setExportNames(String exportNames) {
        this.exportNames = exportNames;
    }
    public String getSchedule() {
        return schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getSubmitDate() {
        return submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }
    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }
    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 评定等级
     */
    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getGradeId() {
        return gradeId;
    }

    /**
     * 评定等级
     */
    @ReferDeserialTransfer
    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }


    public void setBillStateName() {
        switch (billState){
            case 0:
                this.billStateName = "自由态";
                break;
            case 1:
                this.billStateName = "已提交";
                break;
            case 2:
            case 5:
                this.billStateName = "审批中";
                break;
            case 3:
                this.billStateName = "审批通过";
                break;
            case 4:
            case 6:
                this.billStateName = "审批驳回";
                break;
        }
    }
    public String getBusinessName(String mainBusiness) {
        switch (mainBusiness){
            case "material":
                mainBusiness = "物资";
                break;
            case "equipment":
                mainBusiness = "设备";
                break;
            case "revolvMaterial":
                mainBusiness = "周转材";
                break;
            case "labor":
                mainBusiness = "劳务分包";
                break;
            case "major":
                mainBusiness = "专业分包";
                break;
            case "consult":
                mainBusiness = "咨询";
                break;
            case "other":
                mainBusiness = "其他";
                break;
        }
        return mainBusiness;
    }
}
