package com.ejianc.business.pro.supplier.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.List;

/**
 * 事件评价
 * 
 * @author generator
 * 
 */
public class ProcessVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String name; // 单据名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 单据编码
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; //合同编码
    private String contractType; // 合同类型
    private String contractTypeName;
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private java.math.BigDecimal contractAmount; // 合同金额
    private Long supplyId; // 供应商id
    private String supplyName; // 供应商名称
    private String source; // 评价来源
    private Long checkOrgId; // 考核单位id
    private String checkOrgName; // 考核单位名称
    private java.math.BigDecimal buckleBranch; //
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date date; // 评价时间
    private Long processId; // 经办人id
    private String process; // 经办人
    private String memo; // 备注
    private Long createUserId;
    private String createUserName;
    private String phone;
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub

    private List<ProcessContentVO> processContentEntities = new ArrayList<>(); // 过程评价内容

    private Long orgId; // 项目id
    private String orgName; // 项目名称
    private String orgCode; // 项目编码
    private Long parentOrgId; // 项目所属组织id
    private String parentOrgName; // 项目所属组织名称
    private String parentOrgCode; // 项目所属组织编码

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }

    /**
     * 单据名称
     */
    public String getName() {
        return name;
    }

    /**
     * 单据名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编码
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编码
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode="contractPool")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同类型
     */
    public String getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 合同金额
     */
    public java.math.BigDecimal getContractAmount() {
        return contractAmount;
    }

    /**
     * 合同金额
     */
    public void setContractAmount(java.math.BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    /**
     * 供应商id
     */
    public Long getSupplyId() {
        return supplyId;
    }

    /**
     * 供应商id
     */
    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    /**
     * 供应商名称
     */
    public String getSupplyName() {
        return supplyName;
    }

    /**
     * 供应商名称
     */
    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    /**
     * 评价来源
     */
    public String getSource() {
        return source;
    }

    /**
     * 评价来源
     */
    public void setSource(String source) {
        this.source = source;
    }
    /**
     * 考核单位id
     */
    public Long getCheckOrgId() {
        return checkOrgId;
    }

    /**
     * 考核单位id
     */
    public void setCheckOrgId(Long checkOrgId) {
        this.checkOrgId = checkOrgId;
    }
    /**
     * 考核单位名称
     */
    public String getCheckOrgName() {
        return checkOrgName;
    }

    /**
     * 考核单位名称
     */
    public void setCheckOrgName(String checkOrgName) {
        this.checkOrgName = checkOrgName;
    }
    /**
     * 
     */
    public java.math.BigDecimal getBuckleBranch() {
        return buckleBranch;
    }

    /**
     * 
     */
    public void setBuckleBranch(java.math.BigDecimal buckleBranch) {
        this.buckleBranch = buckleBranch;
    }
    /**
     * 评价时间
     */
    public java.util.Date getDate() {
        return date;
    }

    /**
     * 评价时间
     */
    public void setDate(java.util.Date date) {
        this.date = date;
    }
    /**
     * 经办人id
     */
    public Long getProcessId() {
        return processId;
    }

    /**
     * 经办人id
     */
    public void setProcessId(Long processId) {
        this.processId = processId;
    }
    /**
     * 经办人
     */
    public String getProcess() {
        return process;
    }

    /**
     * 经办人
     */
    public void setProcess(String process) {
        this.process = process;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     /**
      * 过程评价内容
      */
    public List<ProcessContentVO> getProcessContentEntities() {
        return processContentEntities;
    }

    public void setProcessContentEntities(List<ProcessContentVO> processContentEntities) {
        this.processContentEntities = processContentEntities;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }
}
