package com.ejianc.business.pro.supplier.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.pro.supplier.vo.YearContentVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 年度评价
 * 
 * @author generator
 * 
 */
public class YearVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String name; // 考核内容
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 单据编码
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractType; // 合同类型
    private String contractTypeName; // 合同类型
    private Long supplyId; // 供应商id
    private String supplyName; // 供应商名称
    private java.math.BigDecimal totalAmount; // 累计金额
    private String primaryGrade; // 原登记
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endDate; // 截止时间
    private Integer totalNum; // 累计合作次数
    private java.math.BigDecimal processBranch; // 过程扣分
    private java.math.BigDecimal incidentBranch; // 事件扣分
    private java.math.BigDecimal totalBranch; // 
    private Long grade; // 等级评定
    private String gradeName; // 评价名称
    private Long punishType; // 处置方式
    private String punishTypeName; // 处置方式名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date handleDate; // 办理时间
    private Long processId; // 经办人id
    private String process; // 经办人
    private String memo; // 备注
    private Integer status;

    private String supplyType; // 供应商类别
    private String supplyTypeName; // 供应商类别名称
    private Integer thiYearNum; // 本年合同数
    private Long cooperationProjectId; // 合作项目id
    private String cooperationProjectName; // 合作项目
    private Long cooperationOrgId; // 合作单位id
    private String cooperationOrgName; // 合作单位名字
    private Integer yearDeduct; // 年度扣分
    private Long createUserId;
    private String createUserName;
    private String phone;
    private String supplyQueryType;
    private List<YearContentVO> yearContentEntities = new ArrayList<>(); // 年度评价内容
    // 计算开始时间
    private String oldStartDate;

    private Long orgId; // 项目id
    private String orgName; // 项目名称
    private String orgCode; // 项目编码
    private Long parentOrgId; // 项目所属组织id
    private String parentOrgName; // 项目所属组织名称
    private String parentOrgCode; // 项目所属组织编码


    //导出使用
    private String billStateName;


    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }


    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public String getOldStartDate() {
        return oldStartDate;
    }

    public void setOldStartDate(String oldStartDate) {
        this.oldStartDate = oldStartDate;
    }
    /**
     * 考核内容
     */
    public String getName() {
        return name;
    }

    /**
     * 考核内容
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编码
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编码
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同类型
     */
    public String getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    /**
     * 供应商id
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplyId() {
        return supplyId;
    }

    /**
     * 供应商id
     */
    @ReferDeserialTransfer
    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    /**
     * 供应商名称
     */
    public String getSupplyName() {
        return supplyName;
    }

    /**
     * 供应商名称
     */
    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    /**
     * 累计金额
     */
    public java.math.BigDecimal getTotalAmount() {
        return totalAmount;
    }

    /**
     * 累计金额
     */
    public void setTotalAmount(java.math.BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }
    /**
     * 原登记
     */
    public String getPrimaryGrade() {
        return primaryGrade;
    }

    /**
     * 原登记
     */
    public void setPrimaryGrade(String primaryGrade) {
        this.primaryGrade = primaryGrade;
    }
    /**
     * 截止时间
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 截止时间
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 累计合作次数
     */
    public Integer getTotalNum() {
        return totalNum;
    }

    /**
     * 累计合作次数
     */
    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }
    /**
     * 过程扣分
     */
    public java.math.BigDecimal getProcessBranch() {
        return processBranch;
    }

    /**
     * 过程扣分
     */
    public void setProcessBranch(java.math.BigDecimal processBranch) {
        this.processBranch = processBranch;
    }
    /**
     * 事件扣分
     */
    public java.math.BigDecimal getIncidentBranch() {
        return incidentBranch;
    }

    /**
     * 事件扣分
     */
    public void setIncidentBranch(java.math.BigDecimal incidentBranch) {
        this.incidentBranch = incidentBranch;
    }
    /**
     * 
     */
    public java.math.BigDecimal getTotalBranch() {
        return totalBranch;
    }

    /**
     * 
     */
    public void setTotalBranch(java.math.BigDecimal totalBranch) {
        this.totalBranch = totalBranch;
    }
    /**
     * 等级评定
     */
    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getGrade() {
        return grade;
    }

    /**
     * 等级评定
     */
    @ReferDeserialTransfer
    public void setGrade(Long grade) {
        this.grade = grade;
    }
    /**
     * 评价名称
     */
    public String getGradeName() {
        return gradeName;
    }

    /**
     * 评价名称
     */
    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    /**
     * 处置方式
     */
    @ReferSerialTransfer(referCode="abnormal_grade")
    public Long getPunishType() {
        return punishType;
    }

    /**
     * 处置方式
     */
    @ReferDeserialTransfer
    public void setPunishType(Long punishType) {
        this.punishType = punishType;
    }
    /**
     * 处置方式名称
     */
    public String getPunishTypeName() {
        return punishTypeName;
    }

    /**
     * 处置方式名称
     */
    public void setPunishTypeName(String punishTypeName) {
        this.punishTypeName = punishTypeName;
    }
    /**
     * 办理时间
     */
    public java.util.Date getHandleDate() {
        return handleDate;
    }

    /**
     * 办理时间
     */
    public void setHandleDate(java.util.Date handleDate) {
        this.handleDate = handleDate;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getProcessId() {
        return processId;
    }

    /**
     * 经办人id
     *
     */
    @ReferDeserialTransfer
    public void setProcessId(Long processId) {
        this.processId = processId;
    }
    /**
     * 经办人
     */
    public String getProcess() {
        return process;
    }

    /**
     * 经办人
     */
    public void setProcess(String process) {
        this.process = process;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<YearContentVO> getYearContentEntities() {
        return yearContentEntities;
    }

    public void setYearContentEntities(List<YearContentVO> yearContentEntities) {
        this.yearContentEntities = yearContentEntities;
    }

    /**
      * 年度评价内容
      */


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }

    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }

    public Integer getThiYearNum() {
        return thiYearNum;
    }

    public void setThiYearNum(Integer thiYearNum) {
        this.thiYearNum = thiYearNum;
    }

    public Long getCooperationProjectId() {
        return cooperationProjectId;
    }

    public void setCooperationProjectId(Long cooperationProjectId) {
        this.cooperationProjectId = cooperationProjectId;
    }

    public String getCooperationProjectName() {
        return cooperationProjectName;
    }

    public void setCooperationProjectName(String cooperationProjectName) {
        this.cooperationProjectName = cooperationProjectName;
    }

    public Long getCooperationOrgId() {
        return cooperationOrgId;
    }

    public void setCooperationOrgId(Long cooperationOrgId) {
        this.cooperationOrgId = cooperationOrgId;
    }

    public String getCooperationOrgName() {
        return cooperationOrgName;
    }

    public void setCooperationOrgName(String cooperationOrgName) {
        this.cooperationOrgName = cooperationOrgName;
    }

    public Integer getYearDeduct() {
        return yearDeduct;
    }

    public void setYearDeduct(Integer yearDeduct) {
        this.yearDeduct = yearDeduct;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }
}
