package com.ejianc.business.pro.supplier.api;

import com.ejianc.business.pro.supplier.hystrix.AbnormalHystrix;
import com.ejianc.business.pro.supplier.vo.AbnormalVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@FeignClient(name= "ejc-prosupplier-web", url="${common.env.feign-client-url}", path="ejc-prosupplier-web", fallback = AbnormalHystrix.class)
public interface IAbnormalApi {

    /**
     * @Description queryCheckDTO 查询校验对象
     * @param
     */
    @RequestMapping(value = "/api/abnormal/queryAbnormal", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<List<AbnormalVO>> queryAbnormal();
}
