package com.ejianc.business.pro.supplier.dto;

import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HearUserDTO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long hearUserId;
    // 累计得分 过程 事件
    private BigDecimal sumBranch = BigDecimal.ZERO;
    private BigDecimal gcBranch = BigDecimal.ZERO;
    private BigDecimal sjBranch = BigDecimal.ZERO;
    // 项目次数
    private Integer proCount = 0;
    private Set<Long> proId = new HashSet<>();
    // 合同次数
    private Integer contCount = 0;
    // 合同额
    private BigDecimal contractTaxMny = BigDecimal.ZERO;
    // 单笔最大合同额
    private BigDecimal maxContractTaxMny = BigDecimal.ZERO;
    // 单笔最大合同额的合作单位
    private Long maxOrgId;
    private String maxOrgName;
    private String maxOrgCode;

    public Long getHearUserId() {
        return hearUserId;
    }

    public void setHearUserId(Long hearUserId) {
        this.hearUserId = hearUserId;
    }

    public BigDecimal getSumBranch() {
        return sumBranch;
    }

    public void setSumBranch(BigDecimal sumBranch) {
        this.sumBranch = sumBranch;
    }

    public BigDecimal getGcBranch() {
        return gcBranch;
    }

    public void setGcBranch(BigDecimal gcBranch) {
        this.gcBranch = gcBranch;
    }

    public BigDecimal getSjBranch() {
        return sjBranch;
    }

    public void setSjBranch(BigDecimal sjBranch) {
        this.sjBranch = sjBranch;
    }

    public Integer getProCount() {
        return proCount;
    }

    public void setProCount(Integer proCount) {
        this.proCount = proCount;
    }

    public Integer getContCount() {
        return contCount;
    }

    public void setContCount(Integer contCount) {
        this.contCount = contCount;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getMaxContractTaxMny() {
        return maxContractTaxMny;
    }

    public void setMaxContractTaxMny(BigDecimal maxContractTaxMny) {
        this.maxContractTaxMny = maxContractTaxMny;
    }

    public Set<Long> getProId() {
        return proId;
    }

    public void setProId(Set<Long> proId) {
        this.proId = proId;
    }

    public Long getMaxOrgId() {
        return maxOrgId;
    }

    public void setMaxOrgId(Long maxOrgId) {
        this.maxOrgId = maxOrgId;
    }

    public String getMaxOrgName() {
        return maxOrgName;
    }

    public void setMaxOrgName(String maxOrgName) {
        this.maxOrgName = maxOrgName;
    }

    public String getMaxOrgCode() {
        return maxOrgCode;
    }

    public void setMaxOrgCode(String maxOrgCode) {
        this.maxOrgCode = maxOrgCode;
    }

    public void addPro(Long proId){
        boolean add = this.proId.add(proId);
        if(add){
            this.proCount += 1;
        }
    }
    // boolean 返回是否是最大单的组织
    public boolean addContractTaxMny(BigDecimal contractTaxMny){
        this.contractTaxMny = ComputeUtil.safeAdd(this.contractTaxMny , contractTaxMny);
        boolean greaterThan = ComputeUtil.isGreaterThan(contractTaxMny, this.maxContractTaxMny);
        if(greaterThan){
            this.maxContractTaxMny = contractTaxMny;
            return true;
        }
        return false;
    }
}
