package com.ejianc.business.pro.supplier.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.List;

/**
 * 供应商考察主表
 * 
 * @author generator
 * 
 */
public class InvestigateVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 考察单位id
    private String orgName; // 考察单位
    private Long memberId; // 考察成员
    private String member; // 考察成员
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date date; // 考察日期
    private Long gradeId; // 评定等级
    private String grade; // 评定等级
    private Long processId; // 经办人
    private String process; // 经办人
    private String memo; // 综合评价
    private Long canInId; // 准入表id
    private String code;
    private String supplyQueryType;
    private List<InvestigateContentVO> investigateContentEntities = new ArrayList<>(); // 供应商考察内容

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 考察单位id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 考察单位id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 考察单位
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 考察单位
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 考察成员
     */
    @ReferSerialTransfer(referCode="group-member")
    public Long getMemberId() {
        return memberId;
    }

    /**
     * 考察成员
     */
    @ReferDeserialTransfer
    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }
    /**
     * 考察成员
     */
    public String getMember() {
        return member;
    }

    /**
     * 考察成员
     */
    public void setMember(String member) {
        this.member = member;
    }
    /**
     * 考察日期
     */
    public java.util.Date getDate() {
        return date;
    }

    /**
     * 考察日期
     */
    public void setDate(java.util.Date date) {
        this.date = date;
    }
    /**
     * 评定等级
     */
    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getGradeId() {
        return gradeId;
    }

    /**
     * 评定等级
     */
    @ReferDeserialTransfer
    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    /**
     * 评定等级
     */
    public String getGrade() {
        return grade;
    }

    /**
     * 评定等级
     */
    public void setGrade(String grade) {
        this.grade = grade;
    }
    /**
     * 经办人
     */
    public Long getProcessId() {
        return processId;
    }

    /**
     * 经办人
     */
    public void setProcessId(Long processId) {
        this.processId = processId;
    }
    /**
     * 经办人
     */
    public String getProcess() {
        return process;
    }

    /**
     * 经办人
     */
    public void setProcess(String process) {
        this.process = process;
    }
    /**
     * 综合评价
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 综合评价
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 准入表id
     */
    public Long getCanInId() {
        return canInId;
    }

    /**
     * 准入表id
     */
    public void setCanInId(Long canInId) {
        this.canInId = canInId;
    }

    /**
      * 供应商考察内容
      */
    public List<InvestigateContentVO> getInvestigateContentEntities() {
        return investigateContentEntities;
    }

    public void setInvestigateContentEntities(List<InvestigateContentVO> investigateContentEntities) {
        this.investigateContentEntities = investigateContentEntities;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
