package com.ejianc.business.pro.supplier.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 年度评价批量操作参数
 *
 * @author CJ
 * @Description:
 * @date 2022/12/24 11:09
 */
public class YearBatchOperateParam implements Serializable {

    private static final long serialVersionUID = 1071468959441910817L;

    public static final String OPERATE_TYPE_EFFECT = "effect";
    public static final String OPERATE_TYPE_ADJUST = "adjust";

    /**
     * 操作类型：effect-批量通过，adjust-批量调整
     */
    private String operateType;

    /**
     * 批量操作的年度评价Id列表
     */
    private List<Long> yearIdList;

    /**
     * 调整后得分
     */
    private BigDecimal adjustedScore;

    /**
     * 调整后等级评定
     */
    private Long adjustedGrade;

    /**
     * 调整后等级评定名称
     */
    private String adjustedGradeName;

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public List<Long> getYearIdList() {
        return yearIdList;
    }

    public void setYearIdList(List<Long> yearIdList) {
        this.yearIdList = yearIdList;
    }

    public BigDecimal getAdjustedScore() {
        return adjustedScore;
    }

    public void setAdjustedScore(BigDecimal adjustedScore) {
        this.adjustedScore = adjustedScore;
    }

    public Long getAdjustedGrade() {
        return adjustedGrade;
    }

    public void setAdjustedGrade(Long adjustedGrade) {
        this.adjustedGrade = adjustedGrade;
    }

    public String getAdjustedGradeName() {
        return adjustedGradeName;
    }

    public void setAdjustedGradeName(String adjustedGradeName) {
        this.adjustedGradeName = adjustedGradeName;
    }
}
