package com.ejianc.business.pro.supplier.vo.appraise;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author songlx
 * @version 1.0
 * @description: 评价结果VO
 * @date 2022/4/24
 */
public class AppraiseResultVO implements Serializable {

    private static final long serialVersionUID = 1L;
    // 供应商id
    private Long supplyId;
    // 供应商名称
    private String supplyName;
    // 计算出的等级id
    private Long grade;
    // 计算出的等级name
    private String gradeName;
    // 计算出的正常权重
    private Integer weight;
    // 计算出的异常权重
    private Integer errWeight;
    // 原等级
    private String primaryGrade;
    // 累计金额
    private BigDecimal totalAmount;
    // 合同数量(合作数量)
    private Integer totalNum;
    // 过程扣分
    private BigDecimal processBranch;
    // 事件扣分
    private BigDecimal incidentBranch;
    private BigDecimal totalBranch;

    // 截止时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;
    // 合同类型 (供应商类型)
    private String contractType;
    // 负责人id
    private Long headUserId;
    // 负责人name
    private String headUserName;
    // 计算开始时间
    private String oldStartDate;
    private String cooperationProjectName; // 合作项目 年度这里指个数
    private Long cooperationOrgId; // 合作单位id
    private String cooperationOrgName; // 合作单位名字

    private Long punishType; // 处置方式
    private String punishTypeName; // 处置方式名称
    private String supplyType; // 供应商类别
    private String supplyTypeName; // 供应商类别名称
    private Integer thiYearNum; // 本年合同数
    private String supplyQueryType; //查询类型
    private Integer evaluationObjState; // 评价对象（只有评价类型是劳务分包合同时该字段才会赋值）：1、劳务供应商；2、分包负责人；
    private String  evaluationObjName; // 评价对象名称

    public BigDecimal getTotalBranch() {
        return totalBranch;
    }

    public void setTotalBranch(BigDecimal totalBranch) {
        this.totalBranch = totalBranch;
    }

    public Integer getEvaluationObjState() {
        return evaluationObjState;
    }

    public void setEvaluationObjState(Integer evaluationObjState) {
        this.evaluationObjState = evaluationObjState;
    }

    public String getEvaluationObjName() {
        return evaluationObjName;
    }

    public void setEvaluationObjName(String evaluationObjName) {
        this.evaluationObjName = evaluationObjName;
    }

    public String getCooperationProjectName() {
        return cooperationProjectName;
    }

    public void setCooperationProjectName(String cooperationProjectName) {
        this.cooperationProjectName = cooperationProjectName;
    }

    public Long getCooperationOrgId() {
        return cooperationOrgId;
    }

    public void setCooperationOrgId(Long cooperationOrgId) {
        this.cooperationOrgId = cooperationOrgId;
    }

    public String getCooperationOrgName() {
        return cooperationOrgName;
    }

    public void setCooperationOrgName(String cooperationOrgName) {
        this.cooperationOrgName = cooperationOrgName;
    }

    public String getOldStartDate() {
        return oldStartDate;
    }

    public void setOldStartDate(String oldStartDate) {
        this.oldStartDate = oldStartDate;
    }

    public Long getHeadUserId() {
        return headUserId;
    }

    public void setHeadUserId(Long headUserId) {
        this.headUserId = headUserId;
    }

    public String getHeadUserName() {
        return headUserName;
    }

    public void setHeadUserName(String headUserName) {
        this.headUserName = headUserName;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Long getPunishType() {
        return punishType;
    }

    public void setPunishType(Long punishType) {
        this.punishType = punishType;
    }

    public String getPunishTypeName() {
        return punishTypeName;
    }

    public void setPunishTypeName(String punishTypeName) {
        this.punishTypeName = punishTypeName;
    }

    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }

    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }

    public Integer getThiYearNum() {
        return thiYearNum;
    }

    public void setThiYearNum(Integer thiYearNum) {
        this.thiYearNum = thiYearNum;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }

    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    public String getPrimaryGrade() {
        return primaryGrade;
    }

    public void setPrimaryGrade(String primaryGrade) {
        this.primaryGrade = primaryGrade;
    }

    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public Integer getErrWeight() {
        return errWeight;
    }

    public void setErrWeight(Integer errWeight) {
        this.errWeight = errWeight;
    }

    public Long getSupplyId() {
        return supplyId;
    }

    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }

    public Long getGrade() {
        return grade;
    }

    public void setGrade(Long grade) {
        this.grade = grade;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public BigDecimal getProcessBranch() {
        return processBranch;
    }

    public void setProcessBranch(BigDecimal processBranch) {
        this.processBranch = processBranch;
    }

    public BigDecimal getIncidentBranch() {
        return incidentBranch;
    }

    public void setIncidentBranch(BigDecimal incidentBranch) {
        this.incidentBranch = incidentBranch;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
}
