package com.ejianc.business.pro.supplier.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 供应商每个专家考察列表
 * 
 * @author generator
 * 
 */
public class InvExpertVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long canInId; // 准入单id
    private Long canSubId; // 准入单专家列表id
    private String code; // 单据编码
    private String supplierName; // 供应商名称
    private String mainBusiness; // 主营类别
    private Long applyOrgId; // 申请单位id
    private String applyOrgName; // 申请单位
    private String leader; // 考察组长
    private String exportIds; // 考察专家ids
    private String exportNames; // 考察专家
    private Long exportId; // 当前考察专家id
    private String exportName; // 当前考察专家
    private String state; // 考察状态：1、待考察，2、已考察，3、已驳回，4、已过期
    private String reason; // 驳回原因
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date submitDate; // 提交日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 考察开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date invDate; // 考察日期
    private Integer score; // 得分
    private String result; // 考察结果：合格  不合格
    private String memo; // 综合评价
    private String sourceFrom; // 数据来源 supplier  subLeader
    private Long collectId; // 专家汇总单id

    private List<InvestigateContentVO> investigateContentEntities = new ArrayList<>(); // 供应商考察内容

    public List<InvestigateContentVO> getInvestigateContentEntities() {
        return investigateContentEntities;
    }

    public Long getCollectId() {
        return collectId;
    }

    public void setCollectId(Long collectId) {
        this.collectId = collectId;
    }

    public String getSourceFrom() {
        return sourceFrom;
    }

    public void setSourceFrom(String sourceFrom) {
        this.sourceFrom = sourceFrom;
    }

    public void setInvestigateContentEntities(List<InvestigateContentVO> investigateContentEntities) {
        this.investigateContentEntities = investigateContentEntities;
    }

    public String getExportIds() {
        return exportIds;
    }

    public void setExportIds(String exportIds) {
        this.exportIds = exportIds;
    }

    public String getExportNames() {
        return exportNames;
    }

    public void setExportNames(String exportNames) {
        this.exportNames = exportNames;
    }

    public Long getExportId() {
        return exportId;
    }

    public void setExportId(Long exportId) {
        this.exportId = exportId;
    }

    public String getExportName() {
        return exportName;
    }

    public void setExportName(String exportName) {
        this.exportName = exportName;
    }

    public Long getCanInId() {
        return canInId;
    }

    public void setCanInId(Long canInId) {
        this.canInId = canInId;
    }
    public Long getCanSubId() {
        return canSubId;
    }

    public void setCanSubId(Long canSubId) {
        this.canSubId = canSubId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMainBusiness() {
        return mainBusiness;
    }

    public void setMainBusiness(String mainBusiness) {
        this.mainBusiness = mainBusiness;
    }
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    public String getLeader() {
        return leader;
    }

    public void setLeader(String leader) {
        this.leader = leader;
    }
    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
    public Date getSubmitDate() {
        return submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getInvDate() {
        return invDate;
    }

    public void setInvDate(Date invDate) {
        this.invDate = invDate;
    }
    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }
    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getBusinessName(String mainBusiness) {
        switch (mainBusiness){
            case "material":
                mainBusiness = "物资";
                break;
            case "equipment":
                mainBusiness = "设备";
                break;
            case "revolvMaterial":
                mainBusiness = "周转材";
                break;
            case "labor":
                mainBusiness = "劳务分包";
                break;
            case "major":
                mainBusiness = "专业分包";
                break;
            case "consult":
                mainBusiness = "咨询";
                break;
            case "other":
                mainBusiness = "其他";
                break;
        }
        return mainBusiness;
    }
    public String getStateName(String state) {
        switch (state){
            case "1":
                state = "待考察";
                break;
            case "2":
                state = "已考察";
                break;
            case "3":
                state = "已驳回："+reason;
                break;
            case "4":
                state = "已过期";
                break;
        }
        return state;
    }
}
