package com.ejianc.business.pro.supplier.consts;

import java.sql.SQLOutput;
import java.util.HashMap;
import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 评价跳转连接
 * @date 2022/5/26
 */
public enum SupplyQueryTypeUrlEnum {



    //***start********云南*******************

    物资设备过程评价("过程评价", "materialEquipment", "/processEvaluationList/card?supplyType=materialEquipment&id="),
    分包过程评价("过程评价", "sub", "/processSubcontractList/card?supplyType=sub&id="),
    其他过程评价("过程评价", "other", "/processSubcontractList/card?supplyType=other&id="),

    物资设备事件评价("事件评价", "materialEquipment", "/process/card?supplyType=materialEquipment&id="),
    分包事件评价("事件评价", "sub", "/processSubList/card?supplyType=sub&id="),
    其他事件评价("事件评价", "other", "/process/card?supplyType=other&id="),

    物资设备年度评价("年度评价", "materialEquipment", "/annualEvaluation/card?supplyType=materialEquipment&id="),
    分包年度评价("年度评价", "sub", "/annualSubcontract/card?supplyType=sub&id="),
    其他年度评价("年度评价", "other", "/annualEvaluation/card?supplyType=other&id="),
    //***end********云南********************

    //***start********郑州一建*******************

    物资过程评价("过程评价", "material", "/processEvaluationList/card?supplyType=material&id="),
    设备过程评价("过程评价", "equipment", "/processEvaluationList/card?supplyType=equipment&id="),
    专业分包过程评价("过程评价", "proSub", "/processSubcontractList/card?supplyType=proSub&id="),
    劳务分包过程评价("过程评价", "laborSub", "/processSubcontractList/card?supplyType=laborSub&id="),
    其他过程评价1("过程评价", "other", "/processEvaluationList/card?supplyType=other&id="),

    物资事件评价("事件评价", "material", "/process/card?supplyType=material&id="),
    设备事件评价("事件评价", "equipment", "/process/card?supplyType=equipment&id="),
    专业分包事件评价("事件评价", "proSub", "/processSubList/card?supplyType=proSub&id="),
    劳务分包事件评价("事件评价", "laborSub", "/processSubList/card?supplyType=laborSub&id="),
    其他事件评价1("事件评价", "other", "/process/card?supplyType=other&id="),


    物资年度评价("年度评价", "material", "/annualEvaluation/card?supplyType=material&id="),
    设备年度评价("年度评价", "equipment", "/annualEvaluation/card?supplyType=equipment&id="),
    专业分包年度评价("年度评价", "proSub", "/annualSubcontract/card?supplyType=proSub&id="),
    劳务分包年度评价("年度评价", "laborSub", "/annualSubcontract/card?supplyType=laborSub&id="),
    其他年度评价1("年度评价", "other", "/annualEvaluation/card?supplyType=other&id=");

    //***start********郑州一建*******************


    private String type;
    private String code;
    private String url;


    private static Map<String, SupplyQueryTypeUrlEnum> enumMap = new HashMap();

    static {
        for (SupplyQueryTypeUrlEnum urlEnum : SupplyQueryTypeUrlEnum.values()) {
            enumMap.put(urlEnum.getType() + urlEnum.getCode(), urlEnum);
        }
    }

    public static String getUrl(String typeAndcode) {
        SupplyQueryTypeUrlEnum supplyQueryTypeUrlEnum = enumMap.get(typeAndcode);
        return supplyQueryTypeUrlEnum != null ? supplyQueryTypeUrlEnum.getUrl() : null;
    }

    SupplyQueryTypeUrlEnum(String type, String code, String url) {
        this.type = type;
        this.code = code;
        this.url = url;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public static void main(String[] args) {
        System.out.println(SupplyQueryTypeUrlEnum.getUrl("事件评价material"));
    }

}
