package com.ejianc.business.pro.supplier.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 分包供应商准入表
 * 
 * @author generator
 * 
 */
public class SubcontractCanInVO extends BaseVO {

    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 供应商编号
    private String name; // 供应商名称/个人姓名
    private String supplyType; // 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
    private String supplyTypeName; // 供方类别名称
    private String personal; // 个人：p，企业：e
    private String groupInOrOut; // 集团内外：内in，外out
    private String materialContentId; // 物资供货内容id
    private String materialContent; // 物资供货内容名称
    private String materialMemo; // 物资补充描述
    private String equipmentContentId; // 设备供货内容id
    private String equipmentContent; // 设备供货内容
    private String equipmentMemo; // 设备补充描述
    private String majorContentId; // 专业分包供货内容id
    private String majorContent; // 专业分包供货内容
    private String majorMemo; // 专业分包补充描述
    private String laborContentId; // 劳务分包供货内容id
    private String laborContent; // 劳务分包供货内容
    private String laborMemo; // 劳务分包补充描述
    private String subContentId; // 分包班组供货内容id
    private String subContent; // 分包班组供货内容
    private String subMemo; // 分包班组补充描述
    private String otherContentId; // 其他供货内容id
    private String otherContent; // 其他供货内容
    private String otherMemo; // 其他补充描述
    private String applyOrgName; // 申请单位
    private Long applyOrgId; // 申请单位id
    private Long enterpriseNature; // 企业性质id
    private String enterpriseNatureName; // 企业性质名称
    private String taxpayerNum; // 纳税人识别号/身份证号
    private String legalPerson; // 法人代表/别名
    private String legalPhone; // 法人电话/联系电话
    private String area; // 所在地区
    private String areaName; // 所在地区
    private Integer inOrOut; // 国内外：1国内，2国外
    private String address; // 公司地址
    private Long gradeId; // 供应商等级
    private String gradeName; // 供应商等级
    private String businessRange; // 经营范围
    private String memo; // 准入说明
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date timeOut; // 有效期
    private Boolean coordination; // 是否协同
    private String coordinationName; // 协同姓名
    private String coordinationPhone; // 协同手机号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date registerDate; // 注册日期
    private java.math.BigDecimal registerMny; // 注册资金
    private java.math.BigDecimal turnover; // 年营业额
    private java.lang.Long registerCountryId; // 注册国家id
    private java.lang.String registerCountryName; // 注册国家名称
    private java.lang.Boolean hasInvestigate; // 是否考察
    private java.lang.Boolean investigate; // 是否需要考察
    private String headUserName;//分包负责人
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub

    private String ocrJsonStr; // 营业执照或者身份证百度OCR识别结果
    private Boolean infoPass; // 企业或者个人信息是否校验通过

    private String businessPerson;	//业务代表
    private String businessPhone;	//业务代表电话

    private Long inviteId;//邀请供应商主键

    private List<BankVO> banks = new ArrayList<>(); // 供应商准入---单位银行信息
    private List<CertsVO> certs = new ArrayList<>(); // 供应商准入---证书
    private List<HistoryVO> history = new ArrayList<>(); // 供应商准入---历史业绩
    private List<SubleadersVO> subLeaders = new ArrayList<>(); // 供应商准入---分包供应商
    private List<LaborVO> labors = new ArrayList<>(); // 供应商准入---劳务员

    public List<LaborVO> getLabors() {
        return labors;
    }

    public void setLabors(List<LaborVO> labors) {
        this.labors = labors;
    }

    public String getBusinessPerson() {
        return businessPerson;
    }

    public void setBusinessPerson(String businessPerson) {
        this.businessPerson = businessPerson;
    }

    public String getBusinessPhone() {
        return businessPhone;
    }

    public void setBusinessPhone(String businessPhone) {
        this.businessPhone = businessPhone;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 供应商编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 供应商编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 供应商名称/个人姓名
     */
    public String getName() {
        return name;
    }

    /**
     * 供应商名称/个人姓名
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
     */
    public String getSupplyType() {
        return supplyType;
    }

    /**
     * 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
     */
    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }
    /**
     * 供方类别名称
     */
    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    /**
     * 供方类别名称
     */
    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    /**
     * 个人：p，企业：e
     */
    public String getPersonal() {
        return personal;
    }

    /**
     * 个人：p，企业：e
     */
    public void setPersonal(String personal) {
        this.personal = personal;
    }
    /**
     * 集团内外：内in，外out
     */
    public String getGroupInOrOut() {
        return groupInOrOut;
    }

    /**
     * 集团内外：内in，外out
     */
    public void setGroupInOrOut(String groupInOrOut) {
        this.groupInOrOut = groupInOrOut;
    }
    /**
     * 物资供货内容id
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getMaterialContentId() {
        return materialContentId;
    }

    /**
     * 物资供货内容id
     */
    @ReferDeserialTransfer
    public void setMaterialContentId(String materialContentId) {
        this.materialContentId = materialContentId;
    }
    /**
     * 物资供货内容名称
     */
    public String getMaterialContent() {
        return materialContent;
    }

    /**
     * 物资供货内容名称
     */
    public void setMaterialContent(String materialContent) {
        this.materialContent = materialContent;
    }
    /**
     * 物资补充描述
     */
    public String getMaterialMemo() {
        return materialMemo;
    }

    /**
     * 物资补充描述
     */
    public void setMaterialMemo(String materialMemo) {
        this.materialMemo = materialMemo;
    }
    /**
     * 设备供货内容id
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getEquipmentContentId() {
        return equipmentContentId;
    }

    /**
     * 设备供货内容id
     */
    @ReferDeserialTransfer
    public void setEquipmentContentId(String equipmentContentId) {
        this.equipmentContentId = equipmentContentId;
    }
    /**
     * 设备供货内容
     */
    public String getEquipmentContent() {
        return equipmentContent;
    }

    /**
     * 设备供货内容
     */
    public void setEquipmentContent(String equipmentContent) {
        this.equipmentContent = equipmentContent;
    }
    /**
     * 设备补充描述
     */
    public String getEquipmentMemo() {
        return equipmentMemo;
    }

    /**
     * 设备补充描述
     */
    public void setEquipmentMemo(String equipmentMemo) {
        this.equipmentMemo = equipmentMemo;
    }
    /**
     * 专业分包供货内容id
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getMajorContentId() {
        return majorContentId;
    }

    /**
     * 专业分包供货内容id
     */
    @ReferDeserialTransfer
    public void setMajorContentId(String majorContentId) {
        this.majorContentId = majorContentId;
    }
    /**
     * 专业分包供货内容
     */
    public String getMajorContent() {
        return majorContent;
    }

    /**
     * 专业分包供货内容
     */
    public void setMajorContent(String majorContent) {
        this.majorContent = majorContent;
    }
    /**
     * 专业分包补充描述
     */
    public String getMajorMemo() {
        return majorMemo;
    }

    /**
     * 专业分包补充描述
     */
    public void setMajorMemo(String majorMemo) {
        this.majorMemo = majorMemo;
    }
    /**
     * 劳务分包供货内容id
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getLaborContentId() {
        return laborContentId;
    }

    /**
     * 劳务分包供货内容id
     */
    @ReferDeserialTransfer
    public void setLaborContentId(String laborContentId) {
        this.laborContentId = laborContentId;
    }
    /**
     * 劳务分包供货内容
     */
    public String getLaborContent() {
        return laborContent;
    }

    /**
     * 劳务分包供货内容
     */
    public void setLaborContent(String laborContent) {
        this.laborContent = laborContent;
    }
    /**
     * 劳务分包补充描述
     */
    public String getLaborMemo() {
        return laborMemo;
    }

    /**
     * 劳务分包补充描述
     */
    public void setLaborMemo(String laborMemo) {
        this.laborMemo = laborMemo;
    }
    /**
     * 分包班组供货内容id
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getSubContentId() {
        return subContentId;
    }

    /**
     * 分包班组供货内容id
     */
    @ReferDeserialTransfer
    public void setSubContentId(String subContentId) {
        this.subContentId = subContentId;
    }
    /**
     * 分包班组供货内容
     */
    public String getSubContent() {
        return subContent;
    }

    /**
     * 分包班组供货内容
     */
    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }
    /**
     * 分包班组补充描述
     */
    public String getSubMemo() {
        return subMemo;
    }

    /**
     * 分包班组补充描述
     */
    public void setSubMemo(String subMemo) {
        this.subMemo = subMemo;
    }
    /**
     * 其他供货内容id
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getOtherContentId() {
        return otherContentId;
    }

    /**
     * 其他供货内容id
     */
    @ReferDeserialTransfer
    public void setOtherContentId(String otherContentId) {
        this.otherContentId = otherContentId;
    }
    /**
     * 其他供货内容
     */
    public String getOtherContent() {
        return otherContent;
    }

    /**
     * 其他供货内容
     */
    public void setOtherContent(String otherContent) {
        this.otherContent = otherContent;
    }
    /**
     * 其他补充描述
     */
    public String getOtherMemo() {
        return otherMemo;
    }

    /**
     * 其他补充描述
     */
    public void setOtherMemo(String otherMemo) {
        this.otherMemo = otherMemo;
    }
    /**
     * 申请单位
     */
    public String getApplyOrgName() {
        return applyOrgName;
    }

    /**
     * 申请单位
     */
    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    /**
     * 申请单位id
     */
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    /**
     * 申请单位id
     */
    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    /**
     * 企业性质id
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEnterpriseNature() {
        return enterpriseNature;
    }

    /**
     * 企业性质id
     */
    @ReferDeserialTransfer
    public void setEnterpriseNature(Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }
    /**
     * 企业性质名称
     */
    public String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    /**
     * 企业性质名称
     */
    public void setEnterpriseNatureName(String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }
    /**
     * 纳税人识别号/身份证号
     */
    public String getTaxpayerNum() {
        return taxpayerNum;
    }

    /**
     * 纳税人识别号/身份证号
     */
    public void setTaxpayerNum(String taxpayerNum) {
        this.taxpayerNum = taxpayerNum;
    }
    /**
     * 法人代表/别名
     */
    public String getLegalPerson() {
        return legalPerson;
    }

    /**
     * 法人代表/别名
     */
    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    /**
     * 法人电话/联系电话
     */
    public String getLegalPhone() {
        return legalPhone;
    }

    /**
     * 法人电话/联系电话
     */
    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }
    /**
     * 所在地区
     */
    public String getArea() {
        return area;
    }

    /**
     * 所在地区
     */
    public void setArea(String area) {
        this.area = area;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    /**
     * 国内外：1国内，2国外
     */
    public Integer getInOrOut() {
        return inOrOut;
    }

    /**
     * 国内外：1国内，2国外
     */
    public void setInOrOut(Integer inOrOut) {
        this.inOrOut = inOrOut;
    }
    /**
     * 公司地址
     */
    public String getAddress() {
        return address;
    }

    /**
     * 公司地址
     */
    public void setAddress(String address) {
        this.address = address;
    }
    /**
     * 供应商等级
     */
    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getGradeId() {
        return gradeId;
    }

    /**
     * 供应商等级
     */
    @ReferDeserialTransfer
    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    /**
     * 供应商等级
     */
    public String getGradeName() {
        return gradeName;
    }

    /**
     * 供应商等级
     */
    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    /**
     * 经营范围
     */
    public String getBusinessRange() {
        return businessRange;
    }

    /**
     * 经营范围
     */
    public void setBusinessRange(String businessRange) {
        this.businessRange = businessRange;
    }
    /**
     * 准入说明
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 准入说明
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 有效期
     */
    public java.util.Date getTimeOut() {
        return timeOut;
    }

    /**
     * 有效期
     */
    public void setTimeOut(java.util.Date timeOut) {
        this.timeOut = timeOut;
    }
    /**
     * 是否协同
     */
    public Boolean getCoordination() {
        return coordination;
    }

    /**
     * 是否协同
     */
    public void setCoordination(Boolean coordination) {
        this.coordination = coordination;
    }
    /**
     * 协同姓名
     */
    public String getCoordinationName() {
        return coordinationName;
    }

    /**
     * 协同姓名
     */
    public void setCoordinationName(String coordinationName) {
        this.coordinationName = coordinationName;
    }
    /**
     * 协同手机号
     */
    public String getCoordinationPhone() {
        return coordinationPhone;
    }

    /**
     * 协同手机号
     */
    public void setCoordinationPhone(String coordinationPhone) {
        this.coordinationPhone = coordinationPhone;
    }

    public Boolean getHasInvestigate() {
        return hasInvestigate;
    }

    public void setHasInvestigate(Boolean hasInvestigate) {
        this.hasInvestigate = hasInvestigate;
    }

    public Boolean getInvestigate() {
        return investigate;
    }

    public void setInvestigate(Boolean investigate) {
        this.investigate = investigate;
    }

    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }

    public BigDecimal getRegisterMny() {
        return registerMny;
    }

    public void setRegisterMny(BigDecimal registerMny) {
        this.registerMny = registerMny;
    }

    public BigDecimal getTurnover() {
        return turnover;
    }

    public void setTurnover(BigDecimal turnover) {
        this.turnover = turnover;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getRegisterCountryId() {
        return registerCountryId;
    }

    @ReferDeserialTransfer
    public void setRegisterCountryId(Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }

    public String getRegisterCountryName() {
        return registerCountryName;
    }

    public void setRegisterCountryName(String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }

    public Long getInviteId() {
        return inviteId;
    }

    public void setInviteId(Long inviteId) {
        this.inviteId = inviteId;
    }

    public List<BankVO> getBanks() {
        return banks;
    }

    public void setBanks(List<BankVO> banks) {
        this.banks = banks;
    }

    public List<CertsVO> getCerts() {
        return certs;
    }

    public void setCerts(List<CertsVO> certs) {
        this.certs = certs;
    }

    public List<HistoryVO> getHistory() {
        return history;
    }

    public void setHistory(List<HistoryVO> history) {
        this.history = history;
    }

    public List<SubleadersVO> getSubLeaders() {
        return subLeaders;
    }

    public void setSubLeaders(List<SubleadersVO> subLeaders) {
        this.subLeaders = subLeaders;
    }

    public String getHeadUserName() {
        return headUserName;
    }

    public void setHeadUserName(String headUserName) {
        this.headUserName = headUserName;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }

    public String getOcrJsonStr() {
        return ocrJsonStr;
    }

    public void setOcrJsonStr(String ocrJsonStr) {
        this.ocrJsonStr = ocrJsonStr;
    }

    public Boolean getInfoPass() {
        return infoPass;
    }

    public void setInfoPass(Boolean infoPass) {
        this.infoPass = infoPass;
    }
}
