package com.ejianc.business.pro.supplier.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.pro.supplier.vo.SubleaderCanInSubVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 分包供应商分包负责人准入
 * 
 * @author generator
 * 
 */
public class SubleaderCanInVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 单据编号
    private Long supplyId; // 供应商名称
    private String supplyName; // 供应商名称
    private String supplyTaxNum; // 供应商纳税人识别号
    private String applyPerson; // 申请人
    private Long orgId; // 申请单位
    private String orgName; // 申请单位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date applyDate; // 申请日期
    private String supplyTypeName; // 供应商类别
    private String supplyContent; //
    private String area; // 所在地区
    private String supplyGrade; // 供应商等级
    private String subLeaders; // 分包负责人
    private String subLeadersGrade; // 分包负责人等级
    private String subLeadersGradeId;
    private String supplyGradeId; // 供应商等级id
    private String memo; // 备注

    private String scatteredSupplierFlag; //零星供应商标识：0-否，1-是

    public String getScatteredSupplierFlag() {
        return scatteredSupplierFlag;
    }

    public void setScatteredSupplierFlag(String scatteredSupplierFlag) {
        this.scatteredSupplierFlag = scatteredSupplierFlag;
    }

    private List<SubleaderCanInSubVO> subleaderCanInSubEntities = new ArrayList<>(); // 分包负责人准入--分包负责人

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 单据编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 供应商名称
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplyId() {
        return supplyId;
    }

    /**
     * 供应商名称
     */
    @ReferDeserialTransfer
    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    /**
     * 供应商名称
     */
    public String getSupplyName() {
        return supplyName;
    }

    /**
     * 供应商名称
     */
    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    /**
     * 供应商纳税人识别号
     */
    public String getSupplyTaxNum() {
        return supplyTaxNum;
    }

    /**
     * 供应商纳税人识别号
     */
    public void setSupplyTaxNum(String supplyTaxNum) {
        this.supplyTaxNum = supplyTaxNum;
    }
    /**
     * 申请人
     */
    public String getApplyPerson() {
        return applyPerson;
    }

    /**
     * 申请人
     */
    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }
    /**
     * 申请单位
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 申请单位
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 申请单位
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 申请单位
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 申请日期
     */
    public java.util.Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(java.util.Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 供应商类别
     */
    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    /**
     * 供应商类别
     */
    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    /**
     * 供货内容
     */
    public String getSupplyContent() {
        return supplyContent;
    }

    /**
     * 供货内容
     */
    public void setSupplyContent(String supplyContent) {
        this.supplyContent = supplyContent;
    }
    /**
     * 所在地区
     */
    public String getArea() {
        return area;
    }

    /**
     * 所在地区
     */
    public void setArea(String area) {
        this.area = area;
    }
    /**
     * 供应商等级
     */
    public String getSupplyGrade() {
        return supplyGrade;
    }

    /**
     * 供应商等级
     */
    public void setSupplyGrade(String supplyGrade) {
        this.supplyGrade = supplyGrade;
    }
    /**
     * 分包负责人
     */
    public String getSubLeaders() {
        return subLeaders;
    }

    /**
     * 分包负责人
     */
    public void setSubLeaders(String subLeaders) {
        this.subLeaders = subLeaders;
    }
    /**
     * 分包负责人等级
     */
    public String getSubLeadersGrade() {
        return subLeadersGrade;
    }

    /**
     * 分包负责人等级
     */
    public void setSubLeadersGrade(String subLeadersGrade) {
        this.subLeadersGrade = subLeadersGrade;
    }
    
     /**
      * 分包负责人准入--分包负责人
      */
    public List<SubleaderCanInSubVO> getSubleaderCanInSubEntities() {
        return subleaderCanInSubEntities;
    }

    public void setSubleaderCanInSubEntities(List<SubleaderCanInSubVO> subleaderCanInSubEntities) {
        this.subleaderCanInSubEntities = subleaderCanInSubEntities;
    }
    @ReferSerialTransfer(referCode="pro-supply-grade")
    public String getSubLeadersGradeId() {
        return subLeadersGradeId;
    }

    @ReferDeserialTransfer
    public void setSubLeadersGradeId(String subLeadersGradeId) {
        this.subLeadersGradeId = subLeadersGradeId;
    }
    @ReferSerialTransfer(referCode="pro-supply-grade")
    public String getSupplyGradeId() {
        return supplyGradeId;
    }

    @ReferDeserialTransfer
    public void setSupplyGradeId(String supplyGradeId) {
        this.supplyGradeId = supplyGradeId;
    }
}
