package com.ejianc.business.pro.supplier.api;

import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.pro.supplier.hystrix.CheckSupplierHystrix;
import com.ejianc.business.pro.supplier.vo.CertificateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@FeignClient(name= "ejc-prosupplier-web", url="${common.env.feign-client-url}", path="ejc-prosupplier-web", fallback = CheckSupplierHystrix.class)
public interface ICheckSupplierApi {

    /**
     * @Description queryCheckDTO 查询校验对象
     * @param id
     */
    @RequestMapping(value = "/api/checkSupplier/queryCheckDTO", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<CheckSupplierDTO> queryCheckDTO(@RequestParam(value = "id") Long id);


    /**
     * @description: 获取证件档案
     *
     * @param id
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.pro.supplier.vo.CertificateVO>
     * @author songlx
     * @date: 2022/5/28
     */
    @RequestMapping(value = "/api/checkSupplier/getCertificateVOById", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<CertificateVO> getCertificateVOById(@RequestParam(value = "id") Long id);

    @RequestMapping(value = "/api/checkSupplier/queryGrade", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<Map<Long, Integer>> queryGrade(@RequestBody Map<String, List<Long>> map);

    @RequestMapping(value = "/api/checkSupplier/queryTotalBranch", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<Map<Long, BigDecimal>> queryTotalBranch(@RequestBody Map<String, List<Long>> map);

}
