/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.BrandEntity;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.bean.ProductionEntity;
import com.ejianc.business.pro.supplier.service.IBrandService;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.business.pro.supplier.service.IProductionService;
import com.ejianc.business.pro.supplier.vo.BrandReportVO;
import com.ejianc.business.pro.supplier.vo.CanInReportVO;
import com.ejianc.business.pro.supplier.vo.CanInVO;
import com.ejianc.business.pro.supplier.vo.ProductionVO;
import com.ejianc.business.pro.supplier.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.util.QRCodeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"canIn"})
public class CanInController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "pro-supplier-code";
    @Autowired
    private ICanInService service;
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBrandService brandService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private QRCodeUtil qrCodeUtil;
    @Autowired
    private ISupplierApi iSupplierApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CanInVO> saveOrUpdate(@RequestBody CanInVO saveOrUpdateVO) {
        CommonResponse exist;
        CanInEntity entity = (CanInEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CanInEntity.class));
        if ("maker".equals(entity.getEnterpriseType()) && CollectionUtils.isNotEmpty(entity.getBrandList())) {
            for (BrandEntity brand : entity.getBrandList()) {
                for (ProductionEntity production : brand.getProductionsList()) {
                    if (!"del".equals(brand.getRowState())) continue;
                    production.setRowState("del");
                }
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(exist = this.iSupplierApi.judgeTaxpayerNumIsRepeat(saveOrUpdateVO.getSocialCreditCode(), "e")).isSuccess()) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u5e93\u4e2d\uff1a\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u91cd\u590d!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("socialCreditCode", new Parameter("eq", (Object)saveOrUpdateVO.getSocialCreditCode()));
        param.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        List entities = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)entities)) {
            return CommonResponse.error((String)("\u8be5\u4f9b\u5e94\u5546\u6b63\u5728\u8d70\u3010" + ((CanInEntity)((Object)entities.get(0))).getOrgName() + "\u3011\u7684\u51c6\u5165\u6d41\u7a0b\uff0c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u91cd\u590d!"));
        }
        QueryParam params = new QueryParam();
        params.getParams().put("name", new Parameter("eq", (Object)saveOrUpdateVO.getName()));
        params.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        entities = this.service.queryList(params);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u6b63\u5728\u8d70\u3010" + ((CanInEntity)((Object)entities.get(0))).getOrgName() + "\u3011\u7684\u51c6\u5165\u6d41\u7a0b\uff0c\u540d\u79f0\u91cd\u590d!");
        }
        if ("maker".equals(entity.getEnterpriseType()) && CollectionUtils.isNotEmpty(entity.getBrandList())) {
            for (BrandEntity brand : entity.getBrandList()) {
                this.brandService.saveOrUpdate((Object)brand, false);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CanInVO vo = (CanInVO)BeanMapper.map((Object)((Object)entity), CanInVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdates"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CanInVO> saveOrUpdates(@RequestBody CanInVO saveOrUpdateVO) {
        CanInEntity entity = (CanInEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CanInEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CanInVO vo = (CanInVO)BeanMapper.map((Object)((Object)entity), CanInVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CanInVO> queryDetail(Long id) {
        CanInEntity entity = (CanInEntity)((Object)this.service.selectById(id));
        if ("maker".equals(entity.getEnterpriseType()) && CollectionUtils.isNotEmpty(entity.getBrandList())) {
            List ids = entity.getBrandList().stream().map(x -> x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("brandId", new Parameter("in", ids));
            List productionList = this.productionService.queryList(param);
            Map<Long, List<ProductionEntity>> hourMap = productionList.stream().collect(Collectors.groupingBy(x -> x.getBrandId()));
            for (BrandEntity brand : entity.getBrandList()) {
                brand.setProductionsList(hourMap.get(brand.getId()));
            }
        }
        CanInVO vo = (CanInVO)BeanMapper.map((Object)((Object)entity), CanInVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CanInVO> vos) {
        QueryParam param = new QueryParam();
        for (CanInVO vo : vos) {
            CanInEntity entity = (CanInEntity)((Object)this.service.selectById(vo.getId()));
            param.getParams().put("socialCreditCode", new Parameter("eq", (Object)entity.getSocialCreditCode()));
            List list = this.inviteService.queryList(param);
            if (!ListUtil.isNotEmpty((List)list)) continue;
            for (InviteEntity inviteEntity : list) {
                inviteEntity.setBillState(0);
            }
            this.inviteService.saveOrUpdateBatch(list);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("org_name");
        param.getFuzzyFields().add("socialCreditCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CanInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CanIn-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCanInData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> refCanInData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CanInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getQrCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getQrCode() {
        return CommonResponse.success((String)"", (Object)this.qrCodeUtil.getBase64QRCode("https://www.baidu.com/"));
    }

    @RequestMapping(value={"/queryBrandList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryBrandList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("brandTypeName");
        List supplierIds = new ArrayList();
        if (!"999999".equals(InvocationInfoProxy.getTenantid())) {
            CommonResponse response = this.iSupplierApi.getBaseSupplierIdByTenantId(InvocationInfoProxy.getTenantid());
            supplierIds = (List)response.getData();
            this.logger.info("\u5f15\u5165\u4f9b\u5e94\u5546id--" + JSONObject.toJSONString(supplierIds));
        }
        ArrayList<BrandReportVO> resList = new ArrayList<BrandReportVO>();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<BrandReportVO> typeList = this.service.queryBrandTypeList(page, wrapper);
        resList.addAll(typeList);
        List<BrandReportVO> brandList = this.service.queryBrandList();
        resList.addAll(brandList);
        JSONObject res = new JSONObject();
        res.put("records", (Object)TreeNodeBUtil.buildTree(resList));
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/querySupplierList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> querySupplierList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("supplierName");
        if ("999999".equals(InvocationInfoProxy.getTenantid())) {
            // empty if block
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Long brandId = Long.valueOf(((Parameter)param.getParams().get("brandId")).toString());
        param.getParams().remove("brandId");
        List<CanInReportVO> resList = this.service.querySupplierList(page, wrapper, brandId);
        JSONObject res = new JSONObject();
        res.put("records", resList);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryProductionList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> queryProductionList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("productName");
        param.getFuzzyFields().add("supplyMode");
        param.getFuzzyFields().add("priceRange");
        IPage page = this.productionService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

