/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.supplier.bean.AbnormalEntity;
import com.ejianc.business.pro.supplier.bean.GradeEntity;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.bean.LimitEntity;
import com.ejianc.business.pro.supplier.bean.ProcessEntity;
import com.ejianc.business.pro.supplier.bean.YearEntity;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.ILimitService;
import com.ejianc.business.pro.supplier.service.IYearService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;
import com.ejianc.business.pro.supplier.vo.appraise.CalRuleVo;
import com.ejianc.business.pro.supplier.vo.appraise.ProjectSubVo;
import com.ejianc.business.pro.supplier.vo.appraise.SupplyBaseVo;
import com.ejianc.business.pro.supplier.vo.appraise.SupplySubVo;
import com.ejianc.business.pro.supplier.vo.appraise.TypeBaseVo;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.google.common.collect.HashBasedTable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="yearAppraiseService")
public class YearAppraiseService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "YEAY_EVALUATE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAbnormalService abnormalService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    ISupplierApi proSupplierApi;
    @Autowired
    private IYearService yearService;
    @Autowired
    private ILimitService limitService;
    @Autowired
    private IGradeService gradeService;
    @Autowired
    private SessionManager sessionManager;
    private static final BigDecimal level1 = new BigDecimal(-10L);
    private static final BigDecimal level2 = new BigDecimal(-20L);
    private static final BigDecimal level3 = new BigDecimal(-30L);

    public String getStartDate(AppraiseParamVO appraiseParamVO) {
        String nowDateStr = DateUtil.format(new Date(), "yyyy-MM-dd");
        String substring = nowDateStr.substring(5, 10);
        if (!appraiseParamVO.getYearPushDate().equals(substring)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.isNotNull((Object)"old_start_date");
        wrapper.orderByDesc((Object)"create_time");
        List list = this.yearService.list((Wrapper)wrapper);
        if (list.size() != 0) {
            Date createTime = ((YearEntity)((Object)list.get(0))).getCreateTime();
            return DateUtil.format(createTime, "yyyy-MM-dd");
        }
        Integer startYear = DateUtil.getYear() - 1;
        return startYear + "-" + appraiseParamVO.getYearPushDate();
    }

    public Map<Long, SupplySubVo> sumSubGrade(List<ProcessEntity> processList, List<IncidentEntity> incidentList) {
        ProjectSubVo projectSubVo1;
        ProjectSubVo projectSubVo;
        Map projectMap;
        SupplySubVo supplySubVo1;
        HashMap<Long, ProjectSubVo> projectSubMap;
        String entityStr;
        String supplySubVoStr;
        SupplySubVo supplySubVo;
        HashMap<Long, SupplySubVo> supplySubMap = new HashMap<Long, SupplySubVo>();
        for (ProcessEntity processEntity : processList) {
            supplySubVo = (SupplySubVo)supplySubMap.get(processEntity.getSupplyId());
            this.logger.info("ProcessEntity");
            this.logger.info(processEntity.getId().toString());
            this.logger.info(processEntity.getSupplyId() + "" + processEntity.getBuckleBranch());
            processEntity.setBuckleBranch(null == processEntity.getBuckleBranch() ? BigDecimal.ZERO : processEntity.getBuckleBranch());
            supplySubVoStr = JSONObject.toJSONString((Object)supplySubVo);
            this.logger.info("supplySubVoStr:" + supplySubVoStr);
            entityStr = JSONObject.toJSONString((Object)((Object)processEntity));
            this.logger.info("entityStr:" + entityStr);
            if (null == supplySubVo) {
                ProjectSubVo projectSubVo12 = new ProjectSubVo();
                projectSubVo12.setPrijectId(processEntity.getProjectId());
                projectSubVo12.setSubGrade(processEntity.getBuckleBranch());
                projectSubMap = new HashMap<Long, ProjectSubVo>();
                projectSubMap.put(processEntity.getProjectId(), projectSubVo12);
                supplySubVo1 = new SupplySubVo();
                supplySubVo1.setSupplyId(processEntity.getSupplyId());
                supplySubVo1.setSubGrade(processEntity.getBuckleBranch());
                supplySubVo1.setProjectMap(projectSubMap);
                supplySubVo1.setSjSubGrade(processEntity.getBuckleBranch());
                supplySubVo1.setGcSubGrade(BigDecimal.ZERO);
                supplySubMap.put(processEntity.getSupplyId(), supplySubVo1);
                continue;
            }
            projectMap = supplySubVo.getProjectMap();
            projectSubVo = (ProjectSubVo)projectMap.get(processEntity.getProjectId());
            if (null == projectSubVo) {
                projectSubVo1 = new ProjectSubVo();
                projectSubVo1.setPrijectId(processEntity.getProjectId());
                projectSubVo1.setSubGrade(processEntity.getBuckleBranch());
                projectMap.put(processEntity.getProjectId(), projectSubVo1);
                supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(processEntity.getBuckleBranch()));
                supplySubVo.setSjSubGrade(supplySubVo.getSjSubGrade().add(processEntity.getBuckleBranch()));
                continue;
            }
            projectSubVo.setSubGrade(projectSubVo.getSubGrade().add(processEntity.getBuckleBranch()));
            supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(processEntity.getBuckleBranch()));
            supplySubVo.setSjSubGrade(supplySubVo.getSjSubGrade().add(processEntity.getBuckleBranch()));
        }
        for (IncidentEntity incidentEntity : incidentList) {
            supplySubVo = (SupplySubVo)supplySubMap.get(incidentEntity.getSupplyId());
            this.logger.info("IncidentEntity");
            this.logger.info(incidentEntity.getId().toString());
            this.logger.info(incidentEntity.getSupplyId() + "" + incidentEntity.getBuckleBranch());
            incidentEntity.setBuckleBranch(null == incidentEntity.getBuckleBranch() ? BigDecimal.ZERO : incidentEntity.getBuckleBranch());
            supplySubVoStr = JSONObject.toJSONString((Object)supplySubVo);
            this.logger.info("supplySubVoStr:" + supplySubVoStr);
            entityStr = JSONObject.toJSONString((Object)((Object)incidentEntity));
            this.logger.info("entityStr:" + entityStr);
            if (null == supplySubVo) {
                ProjectSubVo projectSubVo12 = new ProjectSubVo();
                projectSubVo12.setPrijectId(incidentEntity.getProjectId());
                projectSubVo12.setSubGrade(incidentEntity.getBuckleBranch());
                projectSubMap = new HashMap();
                projectSubMap.put(incidentEntity.getProjectId(), projectSubVo12);
                supplySubVo1 = new SupplySubVo();
                supplySubVo1.setSupplyId(incidentEntity.getSupplyId());
                supplySubVo1.setSubGrade(incidentEntity.getBuckleBranch());
                supplySubVo1.setGcSubGrade(incidentEntity.getBuckleBranch());
                supplySubVo1.setProjectMap(projectSubMap);
                supplySubMap.put(incidentEntity.getSupplyId(), supplySubVo1);
                continue;
            }
            projectMap = supplySubVo.getProjectMap();
            projectSubVo = (ProjectSubVo)projectMap.get(incidentEntity.getProjectId());
            if (null == projectSubVo) {
                projectSubVo1 = new ProjectSubVo();
                projectSubVo1.setPrijectId(incidentEntity.getProjectId());
                projectSubVo1.setSubGrade(incidentEntity.getBuckleBranch());
                projectMap.put(incidentEntity.getProjectId(), projectSubVo1);
                supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(incidentEntity.getBuckleBranch()));
                supplySubVo.setGcSubGrade(supplySubVo.getGcSubGrade().add(incidentEntity.getBuckleBranch()));
                continue;
            }
            projectSubVo.setSubGrade(projectSubVo.getSubGrade().add(incidentEntity.getBuckleBranch()));
            supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(incidentEntity.getBuckleBranch()));
            supplySubVo.setGcSubGrade(supplySubVo.getGcSubGrade().add(incidentEntity.getBuckleBranch()));
        }
        return supplySubMap;
    }

    public TypeBaseVo getMaxType(SupplyBaseVo supplyBaseVo) {
        Map typeBaseMap = supplyBaseVo.getTypeBaseMap();
        BigDecimal maxMny = BigDecimal.ZERO;
        TypeBaseVo resultVo = new TypeBaseVo();
        for (TypeBaseVo vo : typeBaseMap.values()) {
            if (vo.getTypeMny().compareTo(maxMny) < 0) continue;
            maxMny = vo.getTypeMny();
            resultVo = vo;
        }
        return resultVo;
    }

    public List<AppraiseResultVO> calGradeA(Map<Long, SupplyBaseVo> supplyBaseMap, Map<Long, SupplierVO> shareSupplierMap, Map<Long, SupplySubVo> longSupplySubVoMap, List<Long> supplierIds, String startDate) {
        QueryWrapper wrapper = new QueryWrapper();
        List list = this.limitService.list((Wrapper)wrapper);
        HashBasedTable doubleMap = HashBasedTable.create();
        for (LimitEntity limitEntity : list) {
            if (!limitEntity.getState().booleanValue() || null == limitEntity.getAllYear()) continue;
            doubleMap.put((Object)limitEntity.getSupplyType(), (Object)limitEntity.getGreadId(), (Object)limitEntity.getAllYear());
        }
        HashMap<Integer, GradeEntity> weightMap = new HashMap<Integer, GradeEntity>();
        HashMap<Long, GradeEntity> weightIdMap = new HashMap<Long, GradeEntity>();
        QueryWrapper gradeWrapper = new QueryWrapper();
        List gradeList = this.gradeService.list((Wrapper)gradeWrapper);
        for (GradeEntity entity : gradeList) {
            weightMap.put(entity.getWeight(), entity);
            weightIdMap.put(entity.getId(), entity);
        }
        HashMap<Integer, AbnormalEntity> errWeightMap = new HashMap<Integer, AbnormalEntity>();
        QueryWrapper abnormalWrapper = new QueryWrapper();
        List errlist = this.abnormalService.list((Wrapper)abnormalWrapper);
        for (AbnormalEntity entity : errlist) {
            errWeightMap.put(entity.getWeight(), entity);
        }
        ArrayList<AppraiseResultVO> appraiseResultVOList = new ArrayList<AppraiseResultVO>();
        this.logger.info("supplyBaseMap:" + JSONObject.toJSONString(supplyBaseMap));
        for (Long supplierId : supplierIds) {
            SupplyBaseVo supplyBaseVo = supplyBaseMap.get(supplierId);
            this.logger.info("supplyBaseVo:" + JSONObject.toJSONString((Object)supplyBaseVo));
            if (null == supplyBaseVo) {
                this.logger.info("\u6839\u636e\u4f9b\u5e94\u5546Id-{}\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u8be5\u4f9b\u5e94\u5546\uff01", (Object)supplierId);
                continue;
            }
            TypeBaseVo maxTypeVo = this.getMaxType(supplyBaseVo);
            this.logger.info("maxTypeVo:" + JSONObject.toJSONString((Object)maxTypeVo));
            SupplierVO supplierVO = shareSupplierMap.get(supplierId);
            if (null == supplierVO.getGradeId()) {
                this.logger.info("\u4f9b\u5e94\u5546Id-{}\u6839\u636e\u5176\u73b0\u6709\u7b49\u7ea7\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u8be5\u4f9b\u5e94\u5546\uff01", (Object)supplierId);
                continue;
            }
            String supplyType = maxTypeVo.getContractType();
            this.logger.info("supplyType:" + supplyType);
            this.logger.info("maxTypeVo:" + JSONObject.toJSONString((Object)maxTypeVo));
            this.logger.info("doubleMap:" + JSONObject.toJSONString((Object)doubleMap));
            BigDecimal maxMny = (BigDecimal)doubleMap.get((Object)supplyType, (Object)supplierVO.getGradeId());
            GradeEntity gradeEntity = (GradeEntity)((Object)weightIdMap.get(supplierVO.getGradeId()));
            if (null == gradeEntity) {
                this.logger.info("\u4f9b\u5e94\u5546Id-{}\u6839\u636e\u5176\u73b0\u6709\u7b49\u7ea7Id-{}\u83b7\u53d6\u5230\u5bf9\u5e94\u4f9b\u5e94\u5546\u7b49\u7ea7\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u8be5\u4f9b\u5e94\u5546\uff01", (Object)supplierId, (Object)supplierVO.getGradeId());
                continue;
            }
            Integer nowWeight = gradeEntity.getWeight();
            SupplySubVo supplySubVo = longSupplySubVoMap.get(supplierId);
            Map projectMap = supplySubVo.getProjectMap();
            HashMap<Long, BigDecimal> proSubGrade = new HashMap<Long, BigDecimal>();
            for (ProjectSubVo vo : projectMap.values()) {
                proSubGrade.put(vo.getPrijectId(), vo.getSubGrade());
            }
            CalRuleVo calRuleVo = this.calRuleA(nowWeight, proSubGrade, supplySubVo.getSubGrade(), supplyBaseVo.getSumMny(), maxMny, new BigDecimal(90L));
            AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
            appraiseResultVO.setSupplyId(supplierId);
            appraiseResultVO.setSupplyName(supplierVO.getName());
            appraiseResultVO.setCooperationProjectName(supplyBaseVo.getProjectIds().size() + "");
            Long maxContract = this.getMaxConBytype(maxTypeVo);
            appraiseResultVO.setPrimaryGrade(gradeEntity.getName());
            appraiseResultVO.setTotalAmount(supplyBaseVo.getSumMny());
            appraiseResultVO.setTotalNum(supplyBaseVo.getCount());
            appraiseResultVO.setProcessBranch(supplySubVo.getGcSubGrade());
            appraiseResultVO.setIncidentBranch(supplySubVo.getSjSubGrade());
            appraiseResultVO.setThiYearNum(supplyBaseVo.getCount());
            appraiseResultVO.setSupplyQueryType(maxTypeVo.getContractType());
            GradeEntity gradeEntity1 = (GradeEntity)((Object)weightMap.get(calRuleVo.getNewWeight()));
            if (null == gradeEntity1) {
                gradeEntity1 = gradeEntity;
            }
            appraiseResultVO.setGrade(gradeEntity1.getId());
            appraiseResultVO.setGradeName(gradeEntity1.getName());
            appraiseResultVO.setContractType(maxTypeVo.getContractDetailType());
            appraiseResultVO.setErrWeight(calRuleVo.getNewErrWeight());
            appraiseResultVO.setOldStartDate(startDate);
            if (null != calRuleVo.getNewErrWeight()) {
                AbnormalEntity abnormalEntity = (AbnormalEntity)((Object)errWeightMap.get(calRuleVo.getNewErrWeight()));
                appraiseResultVO.setPunishType(abnormalEntity.getId());
                appraiseResultVO.setPunishTypeName(abnormalEntity.getName());
            }
            appraiseResultVOList.add(appraiseResultVO);
        }
        return appraiseResultVOList;
    }

    private Long getMaxConBytype(TypeBaseVo maxTypeVo) {
        Long maxContract = null;
        BigDecimal max = BigDecimal.ZERO;
        Map projectMap = maxTypeVo.getProjectMap();
        return maxContract;
    }

    private CalRuleVo calRuleA(Integer nowWeight, Map<Long, BigDecimal> proSubGrade, BigDecimal sumGrade, BigDecimal sumMny, BigDecimal maxMny, BigDecimal rercent) {
        this.logger.info("\u8ba1\u7b97\u7b49\u7ea7\u5f00\u59cb\u6253\u5370\u5165\u53c2");
        this.logger.info("nowWeight:" + nowWeight);
        this.logger.info("proSubGrade:" + JSONObject.toJSONString(proSubGrade));
        this.logger.info("sumGrade:" + sumGrade);
        this.logger.info("sumMny:" + sumMny);
        this.logger.info("maxMny:" + maxMny);
        this.logger.info("rercent:" + rercent);
        Integer newWeight = null;
        Integer newErrWeight = null;
        maxMny = null == maxMny ? BigDecimal.ZERO : maxMny.multiply(rercent);
        BigDecimal bigDecimal = sumMny = null == sumMny ? BigDecimal.ZERO : sumMny.multiply(new BigDecimal(100L));
        if (sumGrade.compareTo(level1) > 0) {
            if (nowWeight < 9 && sumMny.compareTo(maxMny) > 0) {
                newWeight = nowWeight + 1;
            } else if (nowWeight == 9 && sumMny.compareTo(maxMny) > 0) {
                boolean res = true;
                if (proSubGrade.values().size() >= 3) {
                    for (BigDecimal dec : proSubGrade.values()) {
                        if (dec.compareTo(level1) > 0) continue;
                        res = false;
                        break;
                    }
                } else {
                    res = false;
                }
                if (res) {
                    newWeight = nowWeight + 1;
                }
            }
        } else if (sumGrade.compareTo(level3) <= 0) {
            newErrWeight = 10;
        } else if (sumGrade.compareTo(level2) <= 0 && nowWeight > 8) {
            newWeight = nowWeight - 1;
        }
        CalRuleVo vo = new CalRuleVo();
        vo.setNewWeight(newWeight);
        vo.setNewErrWeight(newErrWeight);
        return vo;
    }

    private CalRuleVo calRuleB(BigDecimal sumGrade) {
        Integer newWeight = null;
        Integer newErrWeight = null;
        if (sumGrade.compareTo(level1) >= 0) {
            newWeight = 10;
        } else if (sumGrade.compareTo(level1) < 0 && sumGrade.compareTo(level2) <= 0) {
            newWeight = 9;
        } else if (sumGrade.compareTo(level2) < 0 && sumGrade.compareTo(level3) <= 0) {
            newWeight = 8;
        } else if (sumGrade.compareTo(level3) < 0) {
            newErrWeight = 10;
        }
        CalRuleVo vo = new CalRuleVo();
        vo.setNewWeight(newWeight);
        vo.setNewErrWeight(newErrWeight);
        return vo;
    }

    public List<AppraiseResultVO> calGradeB(Map<Long, SupplyBaseVo> supplyBaseMap, Map<Long, SupplierVO> shareSupplierMap, Map<Long, SupplySubVo> longSupplySubVoMap, List<Long> supplierIds, String startDate) {
        HashMap<Integer, GradeEntity> weightMap = new HashMap<Integer, GradeEntity>();
        HashMap<Long, GradeEntity> weightIdMap = new HashMap<Long, GradeEntity>();
        QueryWrapper gradeWrapper = new QueryWrapper();
        List gradeList = this.gradeService.list((Wrapper)gradeWrapper);
        for (GradeEntity entity : gradeList) {
            weightMap.put(entity.getWeight(), entity);
            weightIdMap.put(entity.getId(), entity);
        }
        HashMap<Integer, AbnormalEntity> errWeightMap = new HashMap<Integer, AbnormalEntity>();
        QueryWrapper abnormalWrapper = new QueryWrapper();
        List errlist = this.abnormalService.list((Wrapper)abnormalWrapper);
        for (AbnormalEntity entity : errlist) {
            errWeightMap.put(entity.getWeight(), entity);
        }
        ArrayList<AppraiseResultVO> appraiseResultVOList = new ArrayList<AppraiseResultVO>();
        for (Long supplierId : supplierIds) {
            SupplyBaseVo supplyBaseVo = supplyBaseMap.get(supplierId);
            TypeBaseVo maxTypeVo = this.getMaxType(supplyBaseVo);
            SupplierVO supplierVO = shareSupplierMap.get(supplierId);
            SupplySubVo supplySubVo = longSupplySubVoMap.get(supplierId);
            AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
            GradeEntity gradeEntity = (GradeEntity)((Object)weightIdMap.get(supplierVO.getGradeId()));
            CalRuleVo calRuleVo = this.calRuleB(supplySubVo.getSubGrade());
            appraiseResultVO.setSupplyId(supplierId);
            appraiseResultVO.setSupplyName(supplierVO.getName());
            appraiseResultVO.setCooperationProjectName(supplyBaseVo.getProjectIds().size() + "");
            Long maxContract = this.getMaxConBytype(maxTypeVo);
            appraiseResultVO.setPrimaryGrade(gradeEntity.getName());
            appraiseResultVO.setTotalAmount(supplyBaseVo.getSumMny());
            appraiseResultVO.setTotalNum(supplyBaseVo.getCount());
            appraiseResultVO.setProcessBranch(supplySubVo.getGcSubGrade());
            appraiseResultVO.setIncidentBranch(supplySubVo.getSjSubGrade());
            appraiseResultVO.setThiYearNum(supplyBaseVo.getCount());
            appraiseResultVO.setSupplyQueryType(maxTypeVo.getContractType());
            GradeEntity gradeEntity1 = (GradeEntity)((Object)weightMap.get(calRuleVo.getNewWeight()));
            if (null == gradeEntity1) {
                gradeEntity1 = gradeEntity;
            }
            appraiseResultVO.setGrade(gradeEntity1.getId());
            appraiseResultVO.setGradeName(gradeEntity1.getName());
            appraiseResultVO.setContractType(maxTypeVo.getContractDetailType());
            appraiseResultVO.setErrWeight(calRuleVo.getNewErrWeight());
            appraiseResultVO.setOldStartDate(startDate);
            if (null != calRuleVo.getNewErrWeight()) {
                AbnormalEntity abnormalEntity = (AbnormalEntity)((Object)errWeightMap.get(calRuleVo.getNewErrWeight()));
                appraiseResultVO.setPunishType(abnormalEntity.getId());
                appraiseResultVO.setPunishTypeName(abnormalEntity.getName());
            }
            appraiseResultVOList.add(appraiseResultVO);
        }
        return appraiseResultVOList;
    }

    public void sendData(List<AppraiseResultVO> appraiseResultVOList) {
        List yearEntities = BeanMapper.mapList(appraiseResultVOList, YearEntity.class);
        for (YearEntity entity : yearEntities) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setStatus(0);
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            entity.setEndDate(new Date());
            entity.setYearDeduct(0);
        }
        if (yearEntities.size() > 0) {
            this.yearService.saveOrUpdateBatch(yearEntities, yearEntities.size());
        }
    }

    public void updateSup(YearEntity entity) {
        Long grade = entity.getGrade();
        String gradeName = entity.getGradeName();
        try {
            this.proSupplierApi.upgradeSupplier(entity.getSupplyId(), grade, gradeName);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            String infomsg = sw.toString();
            this.logger.error(infomsg);
        }
        if (null != entity.getPunishType()) {
            PunishVO punishVO = new PunishVO();
            punishVO.setSupplierId(entity.getSupplyId());
            punishVO.setPunishType(entity.getPunishType());
            punishVO.setPunishDate(new Date());
            AbnormalEntity abnormalEntity = (AbnormalEntity)((Object)this.abnormalService.selectById(entity.getPunishType()));
            if (null == abnormalEntity) {
                this.logger.error("\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u5f02\u5e38\u7b49\u7ea7\u7684\u6570\u636e");
                return;
            }
            Date endDate = DateUtil.monthAdd(new Date(), abnormalEntity.getLastTime() == null ? 0 : abnormalEntity.getLastTime());
            punishVO.setExceptionEndDate(endDate);
            punishVO.setPunishApplyPerson(entity.getProcess());
            punishVO.setPunishGradeId(entity.getGrade());
            punishVO.setPunishGrade(entity.getGradeName());
            punishVO.setPunishOldGrade(entity.getPrimaryGrade());
            punishVO.setPunishApplyOrg(entity.getOrgName());
            String punishVOStr = JSONObject.toJSONString((Object)punishVO);
            this.logger.info("punishVOStr:" + punishVOStr);
            try {
                this.proSupplierApi.punishSupplier(punishVO);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)sw, true));
                String infomsg = sw.toString();
                this.logger.error(infomsg);
            }
        }
    }
}

