package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.vo.BrandReportVO;
import com.ejianc.business.pro.supplier.vo.CanInReportVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.supplier.mapper.CanInMapper;
import com.ejianc.business.pro.supplier.service.ICanInService;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 供应商准入表
 *
 * @author generator
 */
@Service("canInService")
public class CanInServiceImpl extends BaseServiceImpl<CanInMapper, CanInEntity> implements ICanInService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISupplierApi iProSupplierApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IAbnormalService abnormalService;

    @Override
    public CommonResponse<String> afterInvestigate(Long canInId ) {
        CanInEntity canInEntity = selectById(canInId);
        return pushSupplierToShare(canInEntity, "BT211210000000001");

    }

    @Override
    public CommonResponse<String> pushSupplierToShare(CanInEntity canInEntity, String billTypeCode) {
        Long billId = canInEntity.getId();
        //不需要考察 推送到共享中心
        SupplierVO supplierVO = BeanMapper.map(canInEntity, SupplierVO.class);
        supplierVO.setCoordination(canInEntity.getNeedCo());
        logger.info("billTypeCode---{}", billTypeCode);
        // 处理附件
        CommonResponse<String> fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "attachMgr",
                String.valueOf(billId), "BT200422000000028", "attachMgr");//附件
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384111794",
                String.valueOf(billId), "BT200422000000028", "K1639384111794");//法人委托授权书
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384112713",
                String.valueOf(billId), "BT200422000000028", "K1639384112713");//法人身份复印件
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384499212",
                String.valueOf(billId), "BT200422000000028", "K1639384499212");//营业执照
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384662753",
                String.valueOf(billId), "BT200422000000028", "K1639384662753");//身份证正面
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384663721",
                String.valueOf(billId), "BT200422000000028", "K1639384663721");//身份证反面
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K16393844992144",
                String.valueOf(billId), "BT200422000000028", "K16393844992144");//开户行许可证
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        if (ListUtil.isNotEmpty(canInEntity.getCerts())) {
            for (CertsEntity cert : canInEntity.getCerts()) {
                attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(cert.getId()), billTypeCode, "K1639386256873",
                        String.valueOf(cert.getId()), "BT200422000000028", "K1639386256873");//证件附件
            }
        }

        logger.info("pushSupplierToShare----{}", JSONObject.toJSONString(supplierVO));
        return iProSupplierApi.pushSupplierToBaseStore(supplierVO);
    }

    @Override
    public List<BrandReportVO> queryBrandTypeList(Page pages, QueryWrapper queryWrapper,List<Long> supplierIds) {
        return baseMapper.queryBrandTypeList(pages, queryWrapper,supplierIds);
    }

    @Override
    public List<BrandReportVO> queryBrandList(List<Long> supplierIds) {
        return baseMapper.queryBrandList(supplierIds);
    }

    @Override
    public List<CanInReportVO> querySupplierList(Page pages, QueryWrapper queryWrapper, Long brandId,List<Long> supplierIds) {
        return baseMapper.querySupplierList(pages, queryWrapper,brandId,supplierIds);
    }
}
