package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.CommentModleEntity;
import com.ejianc.business.pro.supplier.bean.InvestigateEntity;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IInvestigateService;
import com.ejianc.business.pro.supplier.vo.GradeVO;
import com.ejianc.business.pro.supplier.vo.GroupMemberInvestigate;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.bean.GroupMemberEntity;
import com.ejianc.business.pro.supplier.service.IGroupMemberService;
import com.ejianc.business.pro.supplier.vo.GroupMemberVO;

/**
 * 供应商考察组成员
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("groupMember")
public class GroupMemberController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IGroupMemberService service;

    @Autowired
    private IInvestigateService investigateService;

    @Autowired
    private ICanInService canInService;
    @Autowired
    private IBillTypeApi billTypeApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GroupMemberVO> saveOrUpdate(@RequestBody GroupMemberVO saveorUpdateVO) {
    	GroupMemberEntity entity = BeanMapper.map(saveorUpdateVO, GroupMemberEntity.class);
    	service.saveOrUpdate(entity, false);
    	GroupMemberVO vo = BeanMapper.map(entity, GroupMemberVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GroupMemberVO> queryDetail(Long id) {
    	GroupMemberEntity entity = service.selectById(id);
    	GroupMemberVO vo = BeanMapper.map(entity, GroupMemberVO.class);
        QueryWrapper<InvestigateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("member_id", vo.getId());
        List<InvestigateEntity> list =investigateService.list(queryWrapper);
        List<GroupMemberInvestigate> allList = new ArrayList<>();
        for (InvestigateEntity v:list){
            GroupMemberInvestigate groupMemberInvestigate = new GroupMemberInvestigate();
            groupMemberInvestigate.setCode(v.getCode());
            CanInEntity canInEntity =canInService.getById(v.getCanInId());
            groupMemberInvestigate.setName(canInEntity.getName());
            groupMemberInvestigate.setApplyOrgName(canInEntity.getOrgName());
            groupMemberInvestigate.setDate(v.getDate());
            allList.add(groupMemberInvestigate);
        }
        vo.setInvestigateList(allList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GroupMemberVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (GroupMemberVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                CommonResponse<String> resp = billTypeApi.checkQuote("BT211225000000004", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }
            }
        }
        service.removeByIds(vos.stream().map(GroupMemberVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GroupMemberVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("phone");
        param.getFuzzyFields().add("email");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<GroupMemberEntity> page = service.queryPage(param,false);
        IPage<GroupMemberVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), GroupMemberVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("phone");
        param.getFuzzyFields().add("email");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<GroupMemberEntity> list = service.queryList(param);
        List<GroupMemberVO> voList = new ArrayList<>();
        if(list.size()>0){
            voList = BeanMapper.mapList(list,GroupMemberVO.class);
            for (GroupMemberVO vo: voList){
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if(vo.getState() != null){
                    if(vo.getState()){
                        vo.setStateName("是");
                    }else{
                        vo.setStateName("否");
                    }
                }
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("groupMember-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refGroupMemberData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<GroupMemberVO>> refGroupMemberData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<GroupMemberEntity> page = service.queryPage(param,false);
        IPage<GroupMemberVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GroupMemberVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
