package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.bean.ProcessEntity;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;
import com.ejianc.business.pro.supplier.vo.appraise.SupplySubVo;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import groovy.util.logging.Slf4j;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author songlx
 * @version 1.0
 * @description: 郑州一建评价策略
 * @date 2022/4/24
 */

@Component("rule_b_appraise")
@Slf4j
public class RuleBAppraiseStrategy implements AppraiseStrategy{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private YearAppraiseService yearAppraiseService;
    @Autowired
    ISupplierApi proSupplierApi;
    @Autowired
    private IProcessService processService;
    @Autowired
    IPushProcessRuleBLogic pushProcessRuleBLogic;
    @Autowired
    private IIncidentService incidentService;

    /**
     * @param appraiseParamVO
     * @description: 推送过程评价
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author songlx
     * @date: 2022/4/24
     */
    @Override
    public AppraiseResultVO pushProcessAppraise(AppraiseParamVO appraiseParamVO) {

        //逻辑一
        pushProcessRuleBLogic.logicOne(appraiseParamVO);
        //逻辑二
        pushProcessRuleBLogic.logicTwo(appraiseParamVO);

        AppraiseResultVO appraiseResultVO=new AppraiseResultVO();
        return appraiseResultVO;
    }

    /**
     * @param appraiseParamVO
     * @description: 推送年度评价
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author songlx
     * @date: 2022/4/24
     */
    @Override
    public AppraiseResultVO pushYearAppraise(AppraiseParamVO appraiseParamVO) {
        // 获取年度评价周期
        String startDate = yearAppraiseService.getStartDate(appraiseParamVO);
        String endDate = DateUtil.getYear() + "-" + appraiseParamVO.getYearPushDate();
        if(StringUtils.isEmpty(startDate)){
            logger.info("当前未到设置的周期。");
            return null;
        }
        if(startDate.equals(endDate)){
            logger.info("今日已经执行过推送。");
            return null;
        }

        // 获取本年度过程、事件评价数据
        QueryWrapper<ProcessEntity> processWrapper = new QueryWrapper<>();
        processWrapper.in("bill_state",1,3);
        processWrapper.ge("date_format(create_time,'%Y-%m-%d')",startDate);
        processWrapper.le("date_format(create_time,'%Y-%m-%d')",endDate);
        List<ProcessEntity> processlist = processService.list(processWrapper);

        QueryWrapper<IncidentEntity> incidentWrapper = new QueryWrapper<>();
        incidentWrapper.in("bill_state",1,3);
        incidentWrapper.ge("date_format(create_time,'%Y-%m-%d')",startDate);
        incidentWrapper.le("date_format(create_time,'%Y-%m-%d')",endDate);
        List<IncidentEntity> incidentList = incidentService.list(incidentWrapper);
        // 供应商set
        Set<Long> supplySet = new HashSet<>();
        for (ProcessEntity entity:processlist) {
            supplySet.add(entity.getSupplyId());
        }
        for (IncidentEntity entity:incidentList) {
            supplySet.add(entity.getSupplyId());
        }
        // 去重后的供应商ids
        List<Long> supplyIds = new ArrayList<>(supplySet);
        logger.info("supplyIds:"+supplyIds);
        logger.info("processlist:"+JSONObject.toJSONString(processlist));
        logger.info("incidentList:"+JSONObject.toJSONString(incidentList));

        if(CollectionUtils.isEmpty(supplyIds)){
            logger.info("没有生效态的过程评价和事件评价，供应商id集合为空。无需推送！");
            return null;
        }

        // 获取供应商数据
        Map<String,List<Long>> map = new HashMap<>();
        map.put("ids",supplyIds);
        CommonResponse<List<SupplierDTO>> shareSupplierList = new CommonResponse<>();
        String s = JSONObject.toJSONString(shareSupplierList);
        logger.info("json:"+s);

        Map<Long, SupplierVO> shareSupplierMap = new HashMap<>();
        if(!shareSupplierList.isSuccess() || null == shareSupplierList.getData()){
            logger.info("查询供应商数据失败。");
            return null;
        }
        List<SupplierVO> vos = BeanMapper.mapList(shareSupplierList.getData(), SupplierVO.class);
        for (SupplierVO vo:vos) {
            shareSupplierMap.put(vo.getId(),vo);
        }

        //统计扣分项目(供应商维度、项目维度)
        Map<Long, SupplySubVo> longSupplySubVoMap = yearAppraiseService.sumSubGrade(processlist, incidentList);

        logger.info("shareSupplierMap:"+JSONObject.toJSONString(shareSupplierMap));
        logger.info("longSupplySubVoMap:"+JSONObject.toJSONString(longSupplySubVoMap));

        return null;
    }

    @Override
    public String pushIncidentAppraiseAnnually(AppraiseParamVO appraiseParamVO) {
        logger.info("策略B年度推送供应商过程评价未实现。。。。");
        return "策略B年度推送供应商过程评价未实现";
    }
}
