package com.ejianc.business.pro.change.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 供应商变更主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supplier_change")
public class ChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="origin_id")
    private Long originId; // 原供应商id
    @TableField(value="chang_state")
    private String changState; // 供应商自己变更状态：未生效free、审核中checking、已生效pass，审核驳回returned
    @TableField(value="origin_from")
    private String originFrom; // 谁发起的：supplier供应商，runner运营商
    @TableField(value="return_reason")
    private String returnReason; // 驳回原因
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="name")
    private String name; // 供方名称
    @TableField(value="enterprise_nature")
    private Long enterpriseNature; // 企业性质
    @TableField(value="enterprise_nature_name")
    private String enterpriseNatureName; // 企业性质名称
    @TableField(value="enterprise_type")
    private String enterpriseType; // 制造商：maker,经销商：seller
    @TableField(value="social_credit_code")
    private String socialCreditCode; // 统一社会信用代码
    @TableField(value="address")
    private String address; // 公司地址
    @TableField(value="register_time")
    private Date registerTime; // 注册日期
    @TableField(value="register_country_id")
    private Long registerCountryId; // 注册国家id
    @TableField(value="register_country_name")
    private String registerCountryName; // 注册国家名称
    @TableField(value="legal")
    private String legal; // 法定代表人
    @TableField(value="legal_phone")
    private String legalPhone; // 法人电话
    @TableField(value="business_person")
    private String businessPerson; // 业务代表
    @TableField(value="business_phone")
    private String businessPhone; // 业务代表电话
    @TableField(value="turnover")
    private BigDecimal turnover; // 年营业额
    @TableField(value="registered_capital")
    private BigDecimal registeredCapital; // 注册资金
    @TableField(value="supply_content_id")
    private String supplyContentId; // 供货内容ids
    @TableField(value="supply_content")
    private String supplyContent; // 供货内容
    @TableField(value="business_scope")
    private String businessScope; // 经营范围
    @TableField(value="bl_time")
    private Date blTime; // 营业执照有效期
    @TableField(value="tax_payer_type")
    private String taxPayerType; // 纳税人类型:commonly 一般纳税人 smallScale 小规模纳税
    @TableField(value="billing_address")
    private String billingAddress; // 开票地址
    @TableField(value="billing_phone")
    private String billingPhone; // 开票电话
    @TableField(value="bank_name")
    private String bankName; // 开户银行
    @TableField(value="bank_account")
    private String bankAccount; // 银行账号
    @TableField(value="grade_id")
    private Long gradeId; // 供应商等级id
    @TableField(value="grade_name")
    private String gradeName; // 供应商等级Name
    @TableField(value="memo")
    private String memo; // 变更说明
    @TableField(value="bill_state")
    private Integer billState; // 变更单据状态
    @TableField(value="bill_code")
    private String billCode; // 变更单编码

    @TableField(exist=false)
    @SubEntity(serviceName="changeCertsService")
    private List<ChangeCertsEntity> certs = new ArrayList<>(); // 供应商准入---证书
    @TableField(exist=false)
    @SubEntity(serviceName="changeBankService")
    private List<ChangeBankEntity> banks = new ArrayList<>(); // 供应商准入---单位银行信息
    @TableField(exist=false)
    @SubEntity(serviceName="changeBrandService",pidName = "canInId")
    private List<ChangeBrandEntity> brandList = new ArrayList<>(); // 供应商准入---品牌子表
    @TableField(exist=false)
    @SubEntity(serviceName="changeProductService",pidName = "canInId")
    private List<ChangeProductEntity> productionList = new ArrayList<>(); // 供应商准入---产品信息子表
    @TableField(exist=false)
    @SubEntity(serviceName="changeFinanceReportService")
    private List<ChangeFinanceReportEntity> financeReportList = new ArrayList<>(); // 供应商准入---财报

    public List<ChangeCertsEntity> getCerts() {
        return certs;
    }

    public void setCerts(List<ChangeCertsEntity> certs) {
        this.certs = certs;
    }

    public List<ChangeBankEntity> getBanks() {
        return banks;
    }

    public void setBanks(List<ChangeBankEntity> banks) {
        this.banks = banks;
    }

    public List<ChangeBrandEntity> getBrandList() {
        return brandList;
    }

    public void setBrandList(List<ChangeBrandEntity> brandList) {
        this.brandList = brandList;
    }

    public List<ChangeProductEntity> getProductionList() {
        return productionList;
    }

    public void setProductionList(List<ChangeProductEntity> productionList) {
        this.productionList = productionList;
    }

    public List<ChangeFinanceReportEntity> getFinanceReportList() {
        return financeReportList;
    }

    public void setFinanceReportList(List<ChangeFinanceReportEntity> financeReportList) {
        this.financeReportList = financeReportList;
    }

    public Long getOriginId() {
        return originId;
    }

    public void setOriginId(Long originId) {
        this.originId = originId;
    }
    public String getChangState() {
        return changState;
    }

    public void setChangState(String changState) {
        this.changState = changState;
    }

    public String getOriginFrom() {
        return originFrom;
    }

    public void setOriginFrom(String originFrom) {
        this.originFrom = originFrom;
    }

    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getEnterpriseNature() {
        return enterpriseNature;
    }

    public void setEnterpriseNature(Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }
    public String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    public void setEnterpriseNatureName(String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }
    public String getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(String enterpriseType) {
        this.enterpriseType = enterpriseType;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Date getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }
    public Long getRegisterCountryId() {
        return registerCountryId;
    }

    public void setRegisterCountryId(Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }
    public String getRegisterCountryName() {
        return registerCountryName;
    }

    public void setRegisterCountryName(String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }
    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }
    public String getLegalPhone() {
        return legalPhone;
    }

    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }
    public String getBusinessPerson() {
        return businessPerson;
    }

    public void setBusinessPerson(String businessPerson) {
        this.businessPerson = businessPerson;
    }
    public String getBusinessPhone() {
        return businessPhone;
    }

    public void setBusinessPhone(String businessPhone) {
        this.businessPhone = businessPhone;
    }
    public BigDecimal getTurnover() {
        return turnover;
    }

    public void setTurnover(BigDecimal turnover) {
        this.turnover = turnover;
    }
    public BigDecimal getRegisteredCapital() {
        return registeredCapital;
    }

    public void setRegisteredCapital(BigDecimal registeredCapital) {
        this.registeredCapital = registeredCapital;
    }
    public String getSupplyContentId() {
        return supplyContentId;
    }

    public void setSupplyContentId(String supplyContentId) {
        this.supplyContentId = supplyContentId;
    }
    public String getSupplyContent() {
        return supplyContent;
    }

    public void setSupplyContent(String supplyContent) {
        this.supplyContent = supplyContent;
    }
    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }
    public Date getBlTime() {
        return blTime;
    }

    public void setBlTime(Date blTime) {
        this.blTime = blTime;
    }
    public String getTaxPayerType() {
        return taxPayerType;
    }

    public void setTaxPayerType(String taxPayerType) {
        this.taxPayerType = taxPayerType;
    }
    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }
    public String getBillingPhone() {
        return billingPhone;
    }

    public void setBillingPhone(String billingPhone) {
        this.billingPhone = billingPhone;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public Long getGradeId() {
        return gradeId;
    }

    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
