package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.YearEntity;
import com.ejianc.business.pro.supplier.service.IYearService;
import com.ejianc.business.pro.supplier.service.appraise.RuleAAppraiseStrategy;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.YearVO;
import com.ejianc.business.pro.supplier.vo.appraise.ContVo;
import com.ejianc.business.pro.supplier.vo.appraise.ResultContVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 年度评价
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("year")
public class YearController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IUserApi userApi;

    private static final String BILL_CODE = "YEAY_EVALUATE";//此处需要根据实际修改
    
    @Autowired
    private IYearService service;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private RuleAAppraiseStrategy rule_a_appraise;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<YearVO> saveOrUpdate(@RequestBody YearVO saveorUpdateVO) {
    	YearEntity entity = BeanMapper.map(saveorUpdateVO, YearEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setCreateUserId(InvocationInfoProxy.getUserid());
        CommonResponse<UserVO> voCommonResponse =userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if(voCommonResponse.isSuccess()){
            UserVO user =voCommonResponse.getData();
            entity.setCreateUserName(user.getUserName());
            entity.setPhone(user.getUserMobile());
        }
        entity.setOrgId(sessionManager.getUserContext().getOrgId());
        entity.setOrgCode(sessionManager.getUserContext().getOrgCode());
        entity.setOrgName(sessionManager.getUserContext().getOrgName());
    	service.saveOrUpdate(entity, false);
    	YearVO vo = BeanMapper.map(entity, YearVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<YearVO> queryDetail(Long id) {
    	YearEntity entity = service.selectById(id);
    	YearVO vo = BeanMapper.map(entity, YearVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<YearVO> vos) {
        service.removeByIds(vos.stream().map(YearVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<YearVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("cooperationOrgName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<YearEntity> page = service.queryPage(param,false);
        IPage<YearVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), YearVO.class));
        List<YearVO> records = pageData.getRecords();
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("supplyName");
        fuzzyFields.add("cooperationOrgName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);


        List<YearEntity> list = service.queryList(param);
        List<YearVO> records = BeanMapper.mapList(list, YearVO.class);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);

        String exportFileName = "Year-materialEquipment-export.xlsx"; //默认物资设备年度评价
        if("other".equals(param.getParams().get("supplyQueryType").getInputType())) {
            exportFileName = "Year-other-export.xlsx";
        }
        ExcelExport.getInstance().export(exportFileName, beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refYearData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<YearVO>> refYearData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<YearEntity> page = service.queryPage(param,false);
        IPage<YearVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), YearVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

     @RequestMapping(value = "/queryRecordList", method = RequestMethod.GET)
     @ResponseBody
     public CommonResponse<List<ResultContVo>> queryRecordList(Long id,Long supplyId){
         YearEntity yearEntity = service.selectById(id);
         ResultContVo resultContVo = new ResultContVo();
         List<ResultContVo> result = new ArrayList<>();
         result.add(resultContVo);
         return CommonResponse.success("查询成功！",result);
     }
}
