package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.*;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("canIn") 
public class CanInBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ICanInService service;

	@Autowired
	private ISupplierApi iProSupplierApi;

	@Autowired
	private IBillCodeApi billCodeApi;

	@Autowired
	private IInvestigateModleService iInvestigateModleService;

	@Autowired
	private IInvestigateService investigateService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CanInEntity canInEntity = service.selectById(billId);
		if(canInEntity == null){
			return CommonResponse.error("没有查到该准入单！");
		}
		QueryParam param = new QueryParam();
		param.getParams().put("id",new Parameter(QueryParam.NE,billId));
		param.getParams().put("socialCreditCode",new Parameter(QueryParam.EQ,canInEntity.getSocialCreditCode()));
		List<CanInEntity> canInEntities = service.queryList(param);

		if(CollectionUtils.isNotEmpty(canInEntities)){
			if("p".equals(canInEntity.getPersonal())) {
				return CommonResponse.error("供应商库已存在身份证号为【"+canInEntity.getSocialCreditCode()+"】的个人供应商！");
			}else {
				return CommonResponse.error("供应商库已存在统一社会信用代码为【"+canInEntity.getSocialCreditCode()+"】的企业供应商！");
			}
		}
		logger.info("canInEntity:{}",JSONObject.toJSONString(canInEntity));
		CommonResponse<String> exist = iProSupplierApi.judgeTaxpayerNumIsRepeat(canInEntity.getSocialCreditCode(),"e");
		if(!exist.isSuccess()){
			return exist;
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO  根据是否需要考察 分为需要考察和不需要考察，不需要考察需要推送到共享中心供方档案
		CanInEntity canInEntity = service.selectById(billId);
		if(canInEntity == null){
			return CommonResponse.error("没有查到该准入单！");
		}
		if(canInEntity.getInvestigate() == null || !canInEntity.getInvestigate()){
			//不需要考察 推送到共享中心
			return service.pushSupplierToShare(canInEntity,billTypeCode);
		}else {
			//需要考察 推送生成  考察列表
			InvestigateEntity entity= new InvestigateEntity();
			CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode("INVESTIGATE", InvocationInfoProxy.getTenantid());
			entity.setId(IdWorker.getId());
			if(billCode.isSuccess()) {
				entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
			}else{
				entity.setCode(("KC-"+ IdWorker.getId()).substring(0,8));//此处需要根据实际修改 删除本行或者下一行
			}
			entity.setCanInId(billId);
			entity.setBillState(0);
			entity.setSupplierName(canInEntity.getName());
			entity.setScore("0");
			entity.setInvestigateResults("noPass");
			entity.setState("to");
			entity.setEnterpriseType(canInEntity.getEnterpriseType());
			entity.setSupplyContent(canInEntity.getSupplyContent());
			List<InvestigateModleContentEntity> modelContentEntities = iInvestigateModleService.queryTypeName(canInEntity.getEnterpriseType());
			if(ListUtil.isEmpty(modelContentEntities)){
				return CommonResponse.error("该供应商需要考察，未找到考察模板，请联系管理员配置后再次审批！");
			}
			for (InvestigateModleContentEntity modelContentEntity : modelContentEntities) {
				InvestigateContentEntity contentEntity = BeanMapper.map(modelContentEntity,InvestigateContentEntity.class);
				contentEntity.setId(IdWorker.getId());
				contentEntity.setPid(entity.getId());
				contentEntity.setSubScore("0");
				entity.getInvestigateContentEntities().add(contentEntity);
			}
			investigateService.saveOrUpdate(entity,false);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("不支持撤回或者弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
