package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.*;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.*;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.supplier.vo.PunishVO;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

@Component("yearAppraiseService")
public class YearAppraiseService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "YEAY_EVALUATE";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAbnormalService abnormalService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    ISupplierApi proSupplierApi;
    @Autowired
    private IYearService yearService;
    @Autowired
    private ILimitService limitService;
    @Autowired
    private IGradeService gradeService;
    @Autowired
    private SessionManager sessionManager;

    private static final BigDecimal level1 = new BigDecimal(-10L);
    private static final BigDecimal level2 = new BigDecimal(-20L);
    private static final BigDecimal level3 = new BigDecimal(-30L);

    /**
     * @param appraiseParamVO
     * @description: 判断今日是否是推送日期，并且获取本次推送年度的起始时间
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author xuannl
     * @date: 2022/5/06
     */
    public String getStartDate(AppraiseParamVO appraiseParamVO) {
        String nowDateStr = DateUtil.format(new Date(), DateUtil.DATE);
        String substring = nowDateStr.substring(5,10);
        // 如果今日不是设置的结算周期，返回空
        if(!appraiseParamVO.getYearPushDate().equals(substring)){
            return null;
        }
        // 如果之前有过年度评价，起始日期就取上一次的年度评价日期，避免周期修改值后，取值不准确。
        // 供应商年度评价不可手动新增！！！，如后续需要支持手动新增，需要对获取起始日期重新处理！
        QueryWrapper<YearEntity> wrapper = new QueryWrapper<>();
        wrapper.isNotNull("old_start_date");
        wrapper.orderByDesc("create_time");
        List<YearEntity> list = yearService.list(wrapper);
        if(list.size() != 0){
            Date createTime = list.get(0).getCreateTime();
            return DateUtil.format(createTime, DateUtil.DATE);
        }else{
            Integer startYear = DateUtil.getYear() - 1;
            return startYear + "-" + appraiseParamVO.getYearPushDate();
        }
    }
    // 累计扣分项 (事件、过程)
    public Map<Long, SupplySubVo> sumSubGrade(List<ProcessEntity> processList, List<IncidentEntity> incidentList){
        Map<Long,SupplySubVo> supplySubMap = new HashMap<>();
        for (ProcessEntity entity:processList
        ) {
            SupplySubVo supplySubVo = supplySubMap.get(entity.getSupplyId());

            logger.info("ProcessEntity");
            logger.info(entity.getId().toString());
            logger.info(entity.getSupplyId()+""+entity.getBuckleBranch());
            entity.setBuckleBranch(null == entity.getBuckleBranch() ? BigDecimal.ZERO : entity.getBuckleBranch());
            String supplySubVoStr = JSONObject.toJSONString(supplySubVo);
            logger.info("supplySubVoStr:"+supplySubVoStr);
            String entityStr = JSONObject.toJSONString(entity);
            logger.info("entityStr:"+entityStr);
            if(null == supplySubVo){
                // 添加到project数据集
                ProjectSubVo projectSubVo1 = new ProjectSubVo();
                projectSubVo1.setPrijectId(entity.getProjectId());
                projectSubVo1.setSubGrade(entity.getBuckleBranch());
                Map<Long,ProjectSubVo> projectSubMap = new HashMap<>();
                projectSubMap.put(entity.getProjectId(),projectSubVo1);
                // 添加到供应商数据集
                SupplySubVo supplySubVo1 = new SupplySubVo();
                supplySubVo1.setSupplyId(entity.getSupplyId());
                supplySubVo1.setSubGrade(entity.getBuckleBranch());
                supplySubVo1.setProjectMap(projectSubMap);
                supplySubVo1.setSjSubGrade(entity.getBuckleBranch());
                supplySubVo1.setGcSubGrade(BigDecimal.ZERO);
                supplySubMap.put(entity.getSupplyId(),supplySubVo1);
            }else{
                Map<Long, ProjectSubVo> projectMap = supplySubVo.getProjectMap();
                ProjectSubVo projectSubVo = projectMap.get(entity.getProjectId());
                if(null == projectSubVo){
                    // 添加到project数据集
                    ProjectSubVo projectSubVo1 = new ProjectSubVo();
                    projectSubVo1.setPrijectId(entity.getProjectId());
                    projectSubVo1.setSubGrade(entity.getBuckleBranch());
                    projectMap.put(entity.getProjectId(),projectSubVo1);
                    supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setSjSubGrade(supplySubVo.getSjSubGrade().add(entity.getBuckleBranch()));
                }else{
                    projectSubVo.setSubGrade(projectSubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setSjSubGrade(supplySubVo.getSjSubGrade().add(entity.getBuckleBranch()));
                }
            }
        }

        for (IncidentEntity entity:incidentList
        ) {
            SupplySubVo supplySubVo = supplySubMap.get(entity.getSupplyId());
            logger.info("IncidentEntity");
            logger.info(entity.getId().toString());
            logger.info(entity.getSupplyId()+""+entity.getBuckleBranch());
            entity.setBuckleBranch(null == entity.getBuckleBranch() ? BigDecimal.ZERO : entity.getBuckleBranch());
            String supplySubVoStr = JSONObject.toJSONString(supplySubVo);
            logger.info("supplySubVoStr:"+supplySubVoStr);
            String entityStr = JSONObject.toJSONString(entity);
            logger.info("entityStr:"+entityStr);

            if(null == supplySubVo){
                // 添加到project数据集
                ProjectSubVo projectSubVo1 = new ProjectSubVo();
                projectSubVo1.setPrijectId(entity.getProjectId());
                projectSubVo1.setSubGrade(entity.getBuckleBranch());
                Map<Long,ProjectSubVo> projectSubMap = new HashMap<>();
                projectSubMap.put(entity.getProjectId(),projectSubVo1);
                // 添加到供应商数据集
                SupplySubVo supplySubVo1 = new SupplySubVo();
                supplySubVo1.setSupplyId(entity.getSupplyId());
                supplySubVo1.setSubGrade(entity.getBuckleBranch());
                supplySubVo1.setGcSubGrade(entity.getBuckleBranch());
                supplySubVo1.setProjectMap(projectSubMap);
                supplySubMap.put(entity.getSupplyId(),supplySubVo1);
            }else{
                Map<Long, ProjectSubVo> projectMap = supplySubVo.getProjectMap();
                ProjectSubVo projectSubVo = projectMap.get(entity.getProjectId());
                if(null == projectSubVo){
                    // 添加到project数据集
                    ProjectSubVo projectSubVo1 = new ProjectSubVo();
                    projectSubVo1.setPrijectId(entity.getProjectId());
                    projectSubVo1.setSubGrade(entity.getBuckleBranch());
                    projectMap.put(entity.getProjectId(),projectSubVo1);
                    supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setGcSubGrade(supplySubVo.getGcSubGrade().add(entity.getBuckleBranch()));
                }else{
                    projectSubVo.setSubGrade(projectSubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setGcSubGrade(supplySubVo.getGcSubGrade().add(entity.getBuckleBranch()));
                }
            }
        }
        return supplySubMap;
    }

    // 获取供应商下最大的类别额
    public TypeBaseVo getMaxType(SupplyBaseVo supplyBaseVo){
        Map<String, TypeBaseVo> typeBaseMap = supplyBaseVo.getTypeBaseMap();
        BigDecimal maxMny = BigDecimal.ZERO;
        TypeBaseVo resultVo = new TypeBaseVo();
        for (TypeBaseVo vo:typeBaseMap.values()
        ) {
            if(vo.getTypeMny().compareTo(maxMny) >= 0){
                maxMny = vo.getTypeMny();
                resultVo = vo;
            }
        }
        return resultVo;
    }

    // 计算最终扣分结果
    public List<AppraiseResultVO> calGradeA(Map<Long,SupplyBaseVo> supplyBaseMap, Map<Long, SupplierVO> shareSupplierMap, Map<Long, SupplySubVo> longSupplySubVoMap, List<Long> supplierIds,String startDate){
        QueryWrapper<LimitEntity> wrapper = new QueryWrapper<>();
        List<LimitEntity> list = limitService.list(wrapper);
        // 引用双键map key 供应商分类 等级 val 限额
        Table<String, Long, BigDecimal> doubleMap = HashBasedTable.create();
        for (LimitEntity limitEntity : list) {
            // 是否开启 如果限额为空代表不限制，等于没有开启
            if(limitEntity.getState() && null != limitEntity.getAllYear()){
                doubleMap.put(limitEntity.getSupplyType(),limitEntity.getGreadId(),limitEntity.getAllYear());
            }

        }
        // 获取等级
        Map<Integer, GradeEntity> weightMap = new HashMap<>();
        Map<Long,GradeEntity> weightIdMap = new HashMap<>();
        QueryWrapper<GradeEntity> gradeWrapper = new QueryWrapper<>();
        List<GradeEntity> gradeList = gradeService.list(gradeWrapper);
        for (GradeEntity entity:gradeList
        ) {
            weightMap.put(entity.getWeight(),entity);
            weightIdMap.put(entity.getId(),entity);
        }
        // 获取异常等级
        Map<Integer,AbnormalEntity> errWeightMap = new HashMap<>();
        QueryWrapper<AbnormalEntity> abnormalWrapper = new QueryWrapper<>();
        List<AbnormalEntity> errlist = abnormalService.list(abnormalWrapper);
        for (AbnormalEntity entity:errlist
        ) {
            errWeightMap.put(entity.getWeight(),entity);
        }


        // 开始计算
        List<AppraiseResultVO> appraiseResultVOList = new ArrayList<>();

        logger.info("supplyBaseMap:"+JSONObject.toJSONString(supplyBaseMap));
        for (Long supplierId:supplierIds
        ) {
            SupplyBaseVo supplyBaseVo = supplyBaseMap.get(supplierId);
            // 获取大最大额度的类别
            logger.info("supplyBaseVo:"+JSONObject.toJSONString(supplyBaseVo));
            if(null == supplyBaseVo) {
                logger.info("根据供应商Id-{}获取到供应商信息为空，跳过该供应商！", supplierId);
                continue;
            }
            TypeBaseVo maxTypeVo = getMaxType(supplyBaseVo);
            logger.info("maxTypeVo:"+JSONObject.toJSONString(maxTypeVo));
            // 获取供应商信息(拿等级、权重)
            SupplierVO supplierVO = shareSupplierMap.get(supplierId);
            if(null == supplierVO.getGradeId()) {
                logger.info("供应商Id-{}根据其现有等级信息为空，跳过该供应商！", supplierId);
                continue;
            }
            // 获取该等级下最大合同额的 最大限额
            String supplyType = maxTypeVo.getContractType();
            logger.info("supplyType:"+supplyType);
            logger.info("maxTypeVo:"+JSONObject.toJSONString(maxTypeVo));
            logger.info("doubleMap:"+JSONObject.toJSONString(doubleMap));
            BigDecimal maxMny = doubleMap.get(supplyType, supplierVO.getGradeId());
            // 获取供应商现在的等级信息
            GradeEntity gradeEntity = weightIdMap.get(supplierVO.getGradeId());
            if(null == gradeEntity) {
                logger.info("供应商Id-{}根据其现有等级Id-{}获取到对应供应商等级信息为空，跳过该供应商！", supplierId,supplierVO.getGradeId());
                continue;
            }
            Integer nowWeight = gradeEntity.getWeight();

            SupplySubVo supplySubVo = longSupplySubVoMap.get(supplierId);
            Map<Long, ProjectSubVo> projectMap = supplySubVo.getProjectMap();
            Map<Long,BigDecimal> proSubGrade = new HashMap<>();
            for (ProjectSubVo vo:projectMap.values()
            ) {
                proSubGrade.put(vo.getPrijectId(),vo.getSubGrade());
            }
            // 调用计算规则
            CalRuleVo calRuleVo = calRuleA(nowWeight, proSubGrade, supplySubVo.getSubGrade(), supplyBaseVo.getSumMny(), maxMny, new BigDecimal(90L));
            AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
            appraiseResultVO.setSupplyId(supplierId);
            appraiseResultVO.setSupplyName(supplierVO.getName());
            appraiseResultVO.setCooperationProjectName(supplyBaseVo.getProjectIds().size()+"");
            // 获取最大类别下的  最大金额的合同，取他的合作单位
            Long maxContract = getMaxConBytype(maxTypeVo);

            appraiseResultVO.setPrimaryGrade(gradeEntity.getName());
            appraiseResultVO.setTotalAmount(supplyBaseVo.getSumMny());
            appraiseResultVO.setTotalNum(supplyBaseVo.getCount());
            appraiseResultVO.setProcessBranch(supplySubVo.getGcSubGrade());
            appraiseResultVO.setIncidentBranch(supplySubVo.getSjSubGrade());
            appraiseResultVO.setThiYearNum(supplyBaseVo.getCount());
            appraiseResultVO.setSupplyQueryType(maxTypeVo.getContractType());
            GradeEntity gradeEntity1 = weightMap.get(calRuleVo.getNewWeight());
            if(null == gradeEntity1){
                gradeEntity1 = gradeEntity;
            }
            appraiseResultVO.setGrade(gradeEntity1.getId());
            appraiseResultVO.setGradeName(gradeEntity1.getName());
            appraiseResultVO.setContractType(maxTypeVo.getContractDetailType());
            appraiseResultVO.setErrWeight(calRuleVo.getNewErrWeight());
            appraiseResultVO.setOldStartDate(startDate);
            if(null != calRuleVo.getNewErrWeight()){
                AbnormalEntity abnormalEntity = errWeightMap.get(calRuleVo.getNewErrWeight());
                appraiseResultVO.setPunishType(abnormalEntity.getId());
                appraiseResultVO.setPunishTypeName(abnormalEntity.getName());
            }
            appraiseResultVOList.add(appraiseResultVO);
        }
        return appraiseResultVOList;
    }


    private Long getMaxConBytype(TypeBaseVo maxTypeVo){
        Long maxContract = null;
        BigDecimal max = BigDecimal.ZERO;
        Map<Long, ProjectBaseVo> projectMap = maxTypeVo.getProjectMap();
        return maxContract;
    }

    /**
     *
     * @param nowWeight 原等级
     * @param proSubGrade 项目对应的扣分值
     * @param sumGrade 总扣分
     * @param sumMny 总合同额
     * @param maxMny 限制最大值
     * @param rercent 阈值百分比(整数 90、80、100)
     */
    private CalRuleVo calRuleA(Integer nowWeight,Map<Long, BigDecimal> proSubGrade,BigDecimal sumGrade,BigDecimal sumMny,BigDecimal maxMny,BigDecimal rercent){
        // 新的正常权重 异常权重
        logger.info("计算等级开始打印入参");
        logger.info("nowWeight:"+nowWeight);
        logger.info("proSubGrade:"+JSONObject.toJSONString(proSubGrade));
        logger.info("sumGrade:"+sumGrade);
        logger.info("sumMny:"+sumMny);
        logger.info("maxMny:"+maxMny);
        logger.info("rercent:"+rercent);
        Integer newWeight = null;
        Integer newErrWeight = null;
        // 额度*倍数
        maxMny = null == maxMny ? BigDecimal.ZERO : maxMny.multiply(rercent);
        sumMny = null == sumMny ? BigDecimal.ZERO : sumMny.multiply(new BigDecimal(100L));
        // 年度得值大于-10分
        if(sumGrade.compareTo(level1) > 0){
            if(nowWeight < 9 && sumMny.compareTo(maxMny) > 0){
                // 现在的等级小于9  并且 合同额大于限额
                newWeight = nowWeight + 1;
            }else if(nowWeight == 9 && sumMny.compareTo(maxMny) > 0){
                // 现在的等级小于9  并且 合同额大于限额 并且超过三个项目 每个项目扣分小于10分
                // 是否满足增加权重规则
                boolean res = true;
                if(proSubGrade.values().size() >= 3){
                    for (BigDecimal dec:proSubGrade.values()
                    ) {
                        if(dec.compareTo(level1) <= 0){
                            res = false;
                            break;
                        }
                    }
                }else{
                    res = false;
                }
                if(res){
                    newWeight = nowWeight + 1;
                }
            }
        }else if(sumGrade.compareTo(level3) <= 0){
            newErrWeight = 10;
        }else if(sumGrade.compareTo(level2) <= 0){
            if(nowWeight > 8){
                // 现在的等级大于8
                newWeight = nowWeight - 1;
            }
        }
        CalRuleVo vo = new CalRuleVo();
        vo.setNewWeight(newWeight);
        vo.setNewErrWeight(newErrWeight);
        return vo;
    }


    /**
     * 实际按照规则计算新权重方法
     * @param sumGrade 总扣分
     */
    private CalRuleVo calRuleB(BigDecimal sumGrade){
        // 新的正常权重 异常权重
        Integer newWeight = null;
        Integer newErrWeight = null;
        // 年度扣分小于10
        if(sumGrade.compareTo(level1) >= 0){
            newWeight = 10;
        }else if(sumGrade.compareTo(level1) < 0 && sumGrade.compareTo(level2) <= 0){
            newWeight = 9;
        }else if(sumGrade.compareTo(level2) < 0 && sumGrade.compareTo(level3) <= 0){
            newWeight = 8;
        }else if(sumGrade.compareTo(level3) < 0 ){
            newErrWeight = 10;
        }
        CalRuleVo vo = new CalRuleVo();
        vo.setNewWeight(newWeight);
        vo.setNewErrWeight(newErrWeight);
        return vo;
    }



    // 计算最终扣分结果
    public List<AppraiseResultVO> calGradeB(Map<Long,SupplyBaseVo> supplyBaseMap, Map<Long, SupplierVO> shareSupplierMap, Map<Long, SupplySubVo> longSupplySubVoMap, List<Long> supplierIds,String startDate){
        // 获取等级
        Map<Integer, GradeEntity> weightMap = new HashMap<>();
        Map<Long,GradeEntity> weightIdMap = new HashMap<>();
        QueryWrapper<GradeEntity> gradeWrapper = new QueryWrapper<>();
        List<GradeEntity> gradeList = gradeService.list(gradeWrapper);
        for (GradeEntity entity:gradeList
        ) {
            weightMap.put(entity.getWeight(),entity);
            weightIdMap.put(entity.getId(),entity);
        }
        // 获取异常等级
        Map<Integer,AbnormalEntity> errWeightMap = new HashMap<>();
        QueryWrapper<AbnormalEntity> abnormalWrapper = new QueryWrapper<>();
        List<AbnormalEntity> errlist = abnormalService.list(abnormalWrapper);
        for (AbnormalEntity entity:errlist
        ) {
            errWeightMap.put(entity.getWeight(),entity);
        }
        // 开始计算
        List<AppraiseResultVO> appraiseResultVOList = new ArrayList<>();
        for (Long supplierId:supplierIds
        ) {
            SupplyBaseVo supplyBaseVo = supplyBaseMap.get(supplierId);
            // 获取大最大额度的类别
            TypeBaseVo maxTypeVo = getMaxType(supplyBaseVo);
            // 获取供应商信息(拿等级、权重)
            SupplierVO supplierVO = shareSupplierMap.get(supplierId);
            SupplySubVo supplySubVo = longSupplySubVoMap.get(supplierId);
            AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
            // 获取供应商现在的等级信息
            GradeEntity gradeEntity = weightIdMap.get(supplierVO.getGradeId());
            // 计算新的权重
            CalRuleVo calRuleVo = calRuleB(supplySubVo.getSubGrade());

            appraiseResultVO.setSupplyId(supplierId);
            appraiseResultVO.setSupplyName(supplierVO.getName());
            appraiseResultVO.setCooperationProjectName(supplyBaseVo.getProjectIds().size()+"");
            // 获取最大类别下的  最大金额的合同，取他的合作单位
            Long maxContract = getMaxConBytype(maxTypeVo);
            appraiseResultVO.setPrimaryGrade(gradeEntity.getName());
            appraiseResultVO.setTotalAmount(supplyBaseVo.getSumMny());
            appraiseResultVO.setTotalNum(supplyBaseVo.getCount());
            appraiseResultVO.setProcessBranch(supplySubVo.getGcSubGrade());
            appraiseResultVO.setIncidentBranch(supplySubVo.getSjSubGrade());
            appraiseResultVO.setThiYearNum(supplyBaseVo.getCount());
            appraiseResultVO.setSupplyQueryType(maxTypeVo.getContractType());
            GradeEntity gradeEntity1 = weightMap.get(calRuleVo.getNewWeight());
            if(null == gradeEntity1){
                gradeEntity1 = gradeEntity;
            }
            appraiseResultVO.setGrade(gradeEntity1.getId());
            appraiseResultVO.setGradeName(gradeEntity1.getName());
            appraiseResultVO.setContractType(maxTypeVo.getContractDetailType());
            appraiseResultVO.setErrWeight(calRuleVo.getNewErrWeight());
            appraiseResultVO.setOldStartDate(startDate);
            if(null != calRuleVo.getNewErrWeight()){
                AbnormalEntity abnormalEntity = errWeightMap.get(calRuleVo.getNewErrWeight());
                appraiseResultVO.setPunishType(abnormalEntity.getId());
                appraiseResultVO.setPunishTypeName(abnormalEntity.getName());
            }
            appraiseResultVOList.add(appraiseResultVO);
        }
        return appraiseResultVOList;
    }


    public void sendData(List<AppraiseResultVO> appraiseResultVOList){
        List<YearEntity> yearEntities = BeanMapper.mapList(appraiseResultVOList, YearEntity.class);
        for (YearEntity entity:yearEntities
        ) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setStatus(0);
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            entity.setEndDate(new Date());
            entity.setYearDeduct(0); //默认年度评价得分为0
        }

        if(yearEntities.size()>0){
            yearService.saveOrUpdateBatch(yearEntities,yearEntities.size());
        }
    }

    // 更新供应商数据 等级 处置
    public void updateSup(YearEntity entity){
        // 更新等级
        Long grade = entity.getGrade();
        String gradeName = entity.getGradeName();
        try {
            proSupplierApi.upgradeSupplier(entity.getSupplyId(),grade,gradeName,entity.getSourceType());
        }catch (Exception e){
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw,true));
            String infomsg = sw.toString();
            logger.error(infomsg);
        }
        // 更新处置方式
        if(null != entity.getPunishType()){
            PunishVO punishVO = new PunishVO();
            punishVO.setSupplierId(entity.getSupplyId());
            punishVO.setPunishType(entity.getPunishType());
            punishVO.setPunishDate(new Date());
            AbnormalEntity abnormalEntity = abnormalService.selectById(entity.getPunishType());
            if(null == abnormalEntity){
                logger.error("没有查询到对应异常等级的数据");
                return;
            }
            Date endDate = DateUtil.monthAdd(new Date(), abnormalEntity.getLastTime() == null ? 0 : abnormalEntity.getLastTime());
            punishVO.setExceptionEndDate(endDate);
            punishVO.setPunishApplyPerson(entity.getProcess());
            punishVO.setPunishGradeId(entity.getGrade());
            punishVO.setPunishGrade(entity.getGradeName());
            punishVO.setPunishOldGrade(entity.getPrimaryGrade());
            punishVO.setPunishApplyOrg(entity.getOrgName());

            String punishVOStr = JSONObject.toJSONString(punishVO);
            logger.info("punishVOStr:"+punishVOStr);
            try {
                proSupplierApi.punishSupplier(punishVO);
            }catch (Exception e){
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw,true));
                String infomsg = sw.toString();
                logger.error(infomsg);
            }
        }
    }
}
