package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.vo.BrandReportVO;
import com.ejianc.business.pro.supplier.vo.CanInReportVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.supplier.mapper.CanInMapper;
import com.ejianc.business.pro.supplier.service.ICanInService;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 供应商准入表
 *
 * @author generator
 */
@Service("canInService")
public class CanInServiceImpl extends BaseServiceImpl<CanInMapper, CanInEntity> implements ICanInService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISupplierApi iProSupplierApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IAbnormalService abnormalService;

    @Override
    public CommonResponse<String> afterInvestigate(Long canInId ) {
        CanInEntity canInEntity = selectById(canInId);
        return pushSupplierToShare(canInEntity, "BT211210000000001");
    }

    @Override
    public CommonResponse<String> pushSupplierToShare(CanInEntity canInEntity, String billTypeCode) {
        Long billId = canInEntity.getId();
        //不需要考察 推送到共享中心
        SupplierVO supplierVO = BeanMapper.map(canInEntity, SupplierVO.class);
        supplierVO.setCoordination(canInEntity.getNeedCo());
        logger.info("pushSupplierToShare----{}", JSONObject.toJSONString(supplierVO));
        return iProSupplierApi.pushSupplierToBaseStore(supplierVO);
    }
}
