package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.bean.CertificateEntity;
import com.ejianc.business.pro.supplier.service.ICertificateService;
import com.ejianc.business.pro.supplier.vo.CertificateVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 证件档案
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("certificate")
public class CertificateController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    
    @Autowired
    private ICertificateService service;

    @Autowired
    private IDefdocApi defdocApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CertificateVO> saveOrUpdate(@RequestBody CertificateVO saveorUpdateVO) {
    	CertificateEntity entity = BeanMapper.map(saveorUpdateVO, CertificateEntity.class);
    	service.saveOrUpdate(entity, false);
    	CertificateVO vo = BeanMapper.map(entity, CertificateVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CertificateVO> queryDetail(Long id) {
    	CertificateEntity entity = service.selectById(id);
    	CertificateVO vo = BeanMapper.map(entity, CertificateVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CertificateVO> vos) {
        service.removeByIds(vos.stream().map(CertificateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    @RequestMapping(value = "/bathSave", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> bathSave(@RequestBody List<CertificateVO> vos) {
        List<CertificateEntity> list = BeanMapper.mapList(vos,CertificateEntity.class);
        service.saveBatch(list);
        return CommonResponse.success("导入成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CertificateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /*if(param.getParams().get("name").getValue() != null){
            if()
        }*/
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("orders", "asc");
        IPage<CertificateEntity> page = new Page<>();
        param.setOrderMap(orderMap);
        try{
            page= service.queryPage(param,false);

        }catch (Exception e){

        }
        IPage<CertificateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertificateVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CertificateEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Certificate-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "certificate-import.xlsx", "证件档案导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<CertificateVO> successList = new ArrayList<>();
            List<CertificateVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 3) {
                    throw new BusinessException("请按照导入模板导入数据");
                }

                CommonResponse<List<DefdocDetailVO>> defList =defdocApi.getDefDocByDefCode("supplier_the_scope");
                Map<String,String> defMap =getDefMap(defList.getData());

                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    CertificateVO certificateVO = new CertificateVO();
                    if (StringUtils.isBlank(datas.get(0))) {
                        certificateVO.setErrorMessage("证件名称能不为空!");
                    }else{
                        certificateVO.setName(datas.get(0));
                    }

                    if (StringUtils.isBlank(datas.get(2))){
                        certificateVO.setOrders(0);
                    }else{
                        try {
                            certificateVO.setOrders(new Integer(datas.get(2)));
                        }catch (Exception e){
                            certificateVO.setErrorMessage("排序必须是数字格式");
                        }
                    }

                    if (StringUtils.isNotBlank(certificateVO.getErrorMessage())){
                        errorList.add(certificateVO);
                    }else{
                        successList.add(certificateVO);
                    }
                }
                JSONObject json = new JSONObject();
                json.put("successList", successList);
                json.put("errorList", errorList);
                return CommonResponse.success(json);
            }else{
                return CommonResponse.error("Excel为空");
            }
        }
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCertificateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CertificateVO>> refCertificateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        String theScope = null;
        String theScopeName = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            JSONObject conditionJson = JSONObject.parseObject(condition);
            theScope = conditionJson.getString("theScope");
            theScopeName = conditionJson.getString("theScopeName");

        }
        if(StringUtils.isNotEmpty(theScope)){
            param.getParams().put("theScope", new Parameter(QueryParam.LIKE, theScope));
        }
        if(StringUtils.isNotEmpty(theScopeName)){
            String[] names = theScopeName.split(",");
            ComplexParam p = new ComplexParam();
            for (String name : names) {
                ComplexParam c = new ComplexParam();
                c.setLogic(ComplexParam.OR);
                c.getParams().put("theScopeName", new Parameter(QueryParam.LIKE, name));
                p.getComplexParams().add(c);
            }
            param.getComplexParams().add(p);
        }
        IPage<CertificateEntity> page = service.queryPage(param,false);
        IPage<CertificateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertificateVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }

    public static String repeatName(String name) {
        String[] str = name.split(",");
        if(str.length == 0) {
            return null;
        }
        List<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for(int i = 0;i < str.length; i++) {
            if(!list.contains(str[i])){
                list.add(str[i]);
                sb.append(str[i]+",");
            }
        }
        return sb.toString().substring(0,sb.toString().length()-1);
    }
}
