package com.ejianc.business.pro.supplier.service.appraise;

import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;
import com.ejianc.business.pro.supplier.vo.appraise.SupplyBaseVo;
import com.ejianc.business.pro.supplier.vo.appraise.SupplySubVo;
import com.ejianc.foundation.supplier.vo.SupplierVO;

import java.util.List;
import java.util.Map;

/**
 * @author songlx
 * @description: 评价服务方法
 * @date: 2022/4/24
 */
public interface AppraiseStrategy {


    /**
     * @param appraiseParamVO
     * @description: 推送过程评价
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author songlx
     * @date: 2022/4/24
     */
    AppraiseResultVO pushProcessAppraise(AppraiseParamVO appraiseParamVO);


    /**
     * @param appraiseParamVO
     * @description: 推送年度评价
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author songlx
     * @date: 2022/4/24
     */
    AppraiseResultVO pushYearAppraise(AppraiseParamVO appraiseParamVO);


    /**
     * 查询在从设置日期起，往前一年内 没有过程评价，生效的时间评价，存在履约中、已冻结合同的供应商，按照合同维度推送过程评价
     *
     * @param appraiseParamVO
     */
    String pushIncidentAppraiseAnnually(AppraiseParamVO appraiseParamVO);
}
