package com.ejianc.business.pro.supplier.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.ICommentModleContentService;
import com.ejianc.business.pro.supplier.vo.util.TreeNodeBUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.supplier.mapper.CommentModleMapper;
import com.ejianc.business.pro.supplier.service.ICommentModleService;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 供应商评价模板
 * 
 * @author generator
 * 
 */
@Service("commentModleService")
public class CommentModleServiceImpl extends BaseServiceImpl<CommentModleMapper, CommentModleEntity> implements ICommentModleService{
    @Autowired
    private ICommentModleContentService iCommentModleContentService;

    @Autowired
    private CommentModleMapper commentModleMapper;

    @Override
    public CommentModleEntity queryTypeName(String commentType) {
        QueryWrapper<CommentModleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("comment_type", commentType);
        queryWrapper.eq("state",true);
        queryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        List<CommentModleEntity> list =this.list(queryWrapper);
        if(CollectionUtil.isNotEmpty(list)){
            CommentModleEntity entity =list.get(0);
            return entity;
        }
        return null;
    }

    /**
     * 修改状态
     * @param id
     * @param state
     */
    @Transactional
    public void updateState(Long id, Boolean state) {
        CommentModleEntity entity =this.getById(id);

        QueryWrapper<CommentModleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("comment_type", entity.getCommentType());
        queryWrapper.eq("supply_type", entity.getSupplyType());
        queryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
        queryWrapper.eq("state", true);
        queryWrapper.ne("id", id);

        if(state){
            List<CommentModleEntity> list =commentModleMapper.selectList(queryWrapper);
            if(CollectionUtil.isNotEmpty(list)){
                CommentModleEntity commentModleEntity =list.get(0);
                commentModleEntity.setState(false);
                this.saveOrUpdate(commentModleEntity);
            }
        }

        entity.setState(state);
        this.saveOrUpdate(entity);
    }

    @Transactional
    public void saveOrUpdates(CommentModleEntity entity) {
        this.saveOrUpdate(entity,false);
        checkModleName(entity);
        saveOrChild(entity);
    }

    @Transactional
    public void checkModleName(CommentModleEntity entity) {
        QueryParam param = new QueryParam();
        param.getParams().put("name",new Parameter(QueryParam.EQ,entity.getName()));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        List<CommentModleEntity> list =this.queryList(param);
        if(ListUtil.isNotEmpty(list) && list.get(0).getId()!=null && !list.get(0).getId().equals(entity.getId())){
            throw new BusinessException("模板名称已经存在！");
        }
    }

    @Transactional
    public void saveOrChild(CommentModleEntity entity) {
        List<CommentModleContentEntity> listbs = entity.getCommentModleContentEntities();
        Map<Long,Long> idMap=new HashMap<>();
        for(CommentModleContentEntity cdEntity:listbs){
            idMap.put(cdEntity.getTid(),cdEntity.getId());
        }
        for(CommentModleContentEntity cdEntity:listbs){
            if(999L!=cdEntity.getParentId()){
                cdEntity.setParentId(idMap.get(cdEntity.getParentId()));
                cdEntity.setTid(cdEntity.getId());
                if(org.apache.commons.lang3.StringUtils.isEmpty(cdEntity.getItem())){
                    throw new BusinessException("编号:"+cdEntity.getCode()+"扣分事项不能为空!");
                }
                if(cdEntity.getDeduct() == null){
                    throw new BusinessException("编号:"+cdEntity.getCode()+"扣分值不能为空!");
                }
            }else{
                if(org.apache.commons.lang3.StringUtils.isEmpty(cdEntity.getName())){
                    throw new BusinessException("编号:"+cdEntity.getCode()+"考核内容不能为空!");
                }
                cdEntity.setTid(cdEntity.getId());
            }
        }
        iCommentModleContentService.saveOrUpdateBatch(listbs,listbs.size(),false);
    }


}
