package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.CommentModleEntity;
import com.ejianc.business.pro.supplier.service.ICommentModleContentService;
import com.ejianc.business.pro.supplier.service.ICommentModleService;
import com.ejianc.business.pro.supplier.utils.ExcelImportUtil;
import com.ejianc.business.pro.supplier.vo.CommentModleContentVO;
import com.ejianc.business.pro.supplier.vo.CommentModleVO;
import com.ejianc.business.pro.supplier.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 供应商评价模板
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("commentModle")
public class CommentModleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;


    @Autowired
    private ICommentModleService service;
    @Autowired
    private ICommentModleContentService commentModleContentService;

    private static final String CODE = "COMMENT_MODLE";//此处需要根据实际修改

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CommentModleVO> saveOrUpdate(@RequestBody CommentModleVO saveorUpdateVO) {
        CommentModleEntity entity = BeanMapper.map(saveorUpdateVO, CommentModleEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> code = billCodeApi.getCodeBatchByRuleCode(CODE, InvocationInfoProxy.getTenantid());
            if(code.isSuccess()) {
                entity.setCode(code.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(entity.getState()!=null && entity.getState()){
            QueryParam queryParam = QueryParam.getInstance();
            queryParam.getParams().put("state",new Parameter(QueryParam.EQ, true));
            queryParam.getParams().put("id",new Parameter(QueryParam.NE, entity.getId()));
            queryParam.getParams().put("commentType",new Parameter(QueryParam.EQ, entity.getCommentType()));
            List<CommentModleEntity> entities = service.queryList(queryParam,false);
            if(ListUtil.isNotEmpty(entities)){
                entities.forEach(e -> e.setState(false));
                service.saveOrUpdateBatch(entities);
            }
        }
        service.saveOrUpdates(entity);

        //如果开启状态需要修改已开启的模板
        if(saveorUpdateVO.getState()){
            QueryParam params = new QueryParam();
            params.getParams().put("commentType",new Parameter(QueryParam.EQ,saveorUpdateVO.getCommentType()));
            params.getParams().put("supplyType",new Parameter(QueryParam.EQ,saveorUpdateVO.getSupplyType()));
            params.getParams().put("state",new Parameter(QueryParam.EQ,true));

            List<CommentModleEntity> lists =service.queryList(params);
            if(ListUtil.isNotEmpty(lists) && lists.get(0).getId()!=null && !lists.get(0).getId().equals(entity.getId())){
                CommentModleEntity  commentModleEntity = lists.get(0);
                commentModleEntity.setState(false);
                service.saveOrUpdate(commentModleEntity);
            }
        }

        CommentModleVO vo = BeanMapper.map(entity, CommentModleVO.class);
        vo.setCommentModleContentEntities(TreeNodeBUtil.buildTree(vo.getCommentModleContentEntities()));
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CommentModleVO> queryDetail(Long id) {
        Map<String, LinkedHashMap<String,String>> subOrderMap = new HashMap<>();
        LinkedHashMap<String,String> map = new LinkedHashMap<>();
        subOrderMap.put("commentModleContentEntities",map);
        map.put("code",QueryParam.ASC);
    	CommentModleEntity entity = service.selectById(id,subOrderMap);
        CommentModleVO vo = BeanMapper.map(entity, CommentModleVO.class);
        if(CollectionUtils.isNotEmpty(entity.getCommentModleContentEntities())){
            vo.setCommentModleContentEntities(TreeNodeBUtil.buildTree(vo.getCommentModleContentEntities()));
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CommentModleVO> vos) {
        service.removeByIds(vos.stream().map(CommentModleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CommentModleVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<CommentModleEntity> page = service.queryPage(param,false);
        IPage<CommentModleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CommentModleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<CommentModleEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CommentModle-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCommentModleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CommentModleVO>> refCommentModleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("state",new Parameter(QueryParam.EQ,true));

        String supplyType =null;
        String commentType =null;

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            JSONObject conditionJson = JSONObject.parseObject(condition);
            supplyType = conditionJson.getString("supplyType");
            commentType = conditionJson.getString("commentType");

        }
        //类型
        if(StringUtils.isNotEmpty(supplyType)){
            param.getParams().put("supplyType", new Parameter(QueryParam.IN, supplyType));
        }
        if(StringUtils.isNotEmpty(commentType)){
            param.getParams().put("commentType", new Parameter(QueryParam.EQ, commentType));
        }
        IPage<CommentModleEntity> page = service.queryPage(param,false);
        IPage<CommentModleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CommentModleVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 根据主表id查询子数据
     * @param zid
     * @return
     */
    @RequestMapping(value = "/querySubList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CommentModleVO> querySubList(Long zid) {
        CommentModleEntity entity = service.selectById(zid);
        CommentModleVO vo = BeanMapper.map(entity, CommentModleVO.class);
        if(CollectionUtils.isNotEmpty(entity.getCommentModleContentEntities())){
            vo.setCommentModleContentEntities(TreeNodeBUtil.buildTree(vo.getCommentModleContentEntities()));
        }
        return CommonResponse.success("查询数据成功！",vo);
    }

    /**
     * 根据主表id查询子数据
     * @return
     */
    @RequestMapping(value = "/queryTypeNameList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CommentModleVO> queryTypeNameList(String commentType) {
        CommentModleEntity commentModleEntity =service.queryTypeName(commentType);
        if(commentModleEntity != null){
            commentModleEntity =service.selectById(commentModleEntity.getId());
            if(commentModleEntity!= null){
                CommentModleVO vo = BeanMapper.map(commentModleEntity, CommentModleVO.class);
                if(CollectionUtils.isNotEmpty(commentModleEntity.getCommentModleContentEntities())){
                    vo.setCommentModleContentEntities(TreeNodeBUtil.buildTree(vo.getCommentModleContentEntities()));
                }
                return CommonResponse.success("查询详情数据成功！",vo);
            }
        }else{
            throw new BusinessException("没有找到对应评价模板！");
        }
        return CommonResponse.success("查询详情数据成功！",null);
    }
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "commentModle-import.xlsx", "评价内容导入模板");
    }

    /**
     * 导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<CommentModleContentVO> errorsList = new ArrayList<>();

            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                //筛选重复序号
                Map<String, Integer> indexMap = new HashMap<>();
                List<CommentModleContentVO> detailVoList = new ArrayList<>();
                Map<String, Long> tidMap = new HashMap<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    CommentModleContentVO vo = new CommentModleContentVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    String detailIndex = datas.get(0);
                    //维护父子关系
                    Long id = Long.valueOf(IdWorker.getId());
                    if (StringUtils.isNotEmpty(detailIndex)) {//序号不为空
                        String[] split = detailIndex.split("[-/.]");
                        vo.setTid(id);
                        tidMap.put(detailIndex, id);
                        if (split.length > 1) {
                            parentWarn=true;
                            vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                        }else{
                            vo.setParentId(999L);
                        }
                    } else {
                        vo.setTid(id);
                        vo.setTpid("");
                        vo.setParentId(999L);
                    }

                    if (indexMap.containsKey(detailIndex)) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(detailIndex) + 2) + "行重复");
                    } else {
                        indexMap.put(detailIndex, i);
                    }

                    if (StringUtils.isEmpty(datas.get(0))) {
                        vo.setCode(null);
                        flag = true;
                    } else {
                        vo.setCode(datas.get(0));
                    }

                    if (StringUtils.isNotEmpty(datas.get(1))) {
                        if(parentWarn){
                            vo.setName(null);

                        }else{
                            vo.setName(datas.get(1));
                        }
                    }else {
                        if (!parentWarn){
                            vo.setName(null);
                            vo.setErrorMessage("第"+i+"行数据：导入失败，原因：考核内容必填！");
                        }
                    }

                    if (StringUtils.isNotEmpty(datas.get(2))) {
                        if(parentWarn){
                            vo.setItem(datas.get(2));
                        }else{
                            vo.setItem(null);
                        }

                    }else {
                        if (parentWarn){
                            vo.setItem(null);
                            vo.setErrorMessage("第"+i+"行数据：导入失败，原因：扣分事项必填！");
                        }
                    }
                    if(parentWarn){
                        if (StringUtils.isNotEmpty(datas.get(3))) {
                            try{
                                vo.setDeduct(Integer.valueOf(datas.get(3)));
                            }catch (NumberFormatException e){
                                vo.setErrorMessage("第"+i+"行数据：导入失败，原因：扣分值不是正确的数字格式！");
                                vo.setDeduct(null);
                            }
                        }
                    }else{
                        vo.setDeduct(null);
                    }

                    parentWarn =false;
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setShadowId(vo.getTid());
                    vo.setRowState("add");
                    vo.setEditFlag(false);
                    if (StringUtils.isNotBlank(vo.getErrorMessage())){
                        errorsList.add(vo);
                    }else{
                        detailVoList.add(vo);
                    }
                }

                for (CommentModleContentVO tVo : detailVoList) {
                    tVo.setTpid(String.valueOf(tidMap.get(tVo.getTpid())));
                }
                List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                if(errorList.size() >0){
                    resp.put("errorList", errorList );
                    resp.put("errorNum", errorList.size());

                }else {
                    resp.put("errorList", errorsList );
                    resp.put("errorNum", 0);
                }
                resp.put("successList", allList.get(0));

                resp.put("successNum", result.size() - 1 - errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    /**
     * 修改状态
     * @param param
     * @return
     */
    @RequestMapping(value = "/updateState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateState(@RequestBody Map<String,String> param){
        Long id = Long.parseLong(param.get("id"));
        String commentType = String.valueOf(param.get("commentType"));
        Boolean state =  Boolean.parseBoolean(param.get("state"));
        if(state){
            QueryParam queryParam = QueryParam.getInstance();
            queryParam.getParams().put("state",new Parameter(QueryParam.EQ, true));
            queryParam.getParams().put("id",new Parameter(QueryParam.NE, id));
            queryParam.getParams().put("commentType",new Parameter(QueryParam.EQ, commentType));
            queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            List<CommentModleEntity> entities = service.queryList(queryParam,false);
            if(ListUtil.isNotEmpty(entities)){
                entities.forEach(e -> e.setState(false));
                service.saveOrUpdateBatch(entities);
            }
        }
        service.updateState(id,state);
        return CommonResponse.success("修改状态成功!");
    }
}
