/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.change.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.change.bean.ChangeBankEntity;
import com.ejianc.business.pro.change.bean.ChangeBrandEntity;
import com.ejianc.business.pro.change.bean.ChangeCertsEntity;
import com.ejianc.business.pro.change.bean.ChangeEntity;
import com.ejianc.business.pro.change.bean.ChangeFinanceReportEntity;
import com.ejianc.business.pro.change.bean.ChangeProductEntity;
import com.ejianc.business.pro.change.service.IChangeBrandService;
import com.ejianc.business.pro.change.service.IChangeProductService;
import com.ejianc.business.pro.change.service.IChangeService;
import com.ejianc.business.pro.change.vo.ChangeCertsVO;
import com.ejianc.business.pro.change.vo.ChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"change"})
public class ChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISupplierApi iSupplierApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IChangeService service;
    @Autowired
    private IChangeBrandService brandService;
    @Autowired
    private IChangeProductService productService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ChangeVO> saveOrUpdate(@RequestBody ChangeVO saveOrUpdateVO) {
        ChangeEntity entity = (ChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ChangeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.processSubs(entity);
        HashSet<Long> set = new HashSet<Long>();
        if ("maker".equals(entity.getEnterpriseType()) && CollectionUtils.isNotEmpty(entity.getBrandList())) {
            for (ChangeBrandEntity brand : entity.getBrandList()) {
                this.brandService.saveOrUpdate((Object)brand, false);
                set.add(brand.getId());
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if ("maker".equals(entity.getEnterpriseType()) && CollectionUtils.isNotEmpty(entity.getBrandList())) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(ChangeProductEntity::getBrandId, set);
            updateWrapper.set(ChangeProductEntity::getCanInId, (Object)entity.getId());
            this.productService.update((Wrapper)updateWrapper);
        }
        ChangeVO vo = (ChangeVO)BeanMapper.map((Object)((Object)entity), ChangeVO.class);
        this.processSubsReturn(vo);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private void processSubs(ChangeEntity entity) {
        if (CollectionUtils.isNotEmpty(entity.getCerts())) {
            for (ChangeCertsEntity changeCertsEntity : entity.getCerts()) {
                if (Objects.equals(changeCertsEntity.getRowState(), "del")) {
                    changeCertsEntity.setRowState(null);
                    changeCertsEntity.setIsDel(1);
                    continue;
                }
                changeCertsEntity.setIsDel(0);
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getBanks())) {
            for (ChangeBankEntity changeBankEntity : entity.getBanks()) {
                if (Objects.equals(changeBankEntity.getRowState(), "del")) {
                    changeBankEntity.setRowState(null);
                    changeBankEntity.setIsDel(1);
                    continue;
                }
                changeBankEntity.setIsDel(0);
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getBrandList())) {
            for (ChangeBrandEntity changeBrandEntity : entity.getBrandList()) {
                if (Objects.equals(changeBrandEntity.getRowState(), "del")) {
                    changeBrandEntity.setRowState(null);
                    changeBrandEntity.setIsDel(1);
                    continue;
                }
                changeBrandEntity.setIsDel(0);
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getProductionList())) {
            for (ChangeProductEntity changeProductEntity : entity.getProductionList()) {
                if (Objects.equals(changeProductEntity.getRowState(), "del")) {
                    changeProductEntity.setRowState(null);
                    changeProductEntity.setIsDel(1);
                    continue;
                }
                changeProductEntity.setIsDel(0);
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getFinanceReportList())) {
            for (ChangeFinanceReportEntity changeFinanceReportEntity : entity.getFinanceReportList()) {
                if (Objects.equals(changeFinanceReportEntity.getRowState(), "del")) {
                    changeFinanceReportEntity.setRowState(null);
                    changeFinanceReportEntity.setIsDel(1);
                    continue;
                }
                changeFinanceReportEntity.setIsDel(0);
            }
        }
    }

    private void processSubsReturn(ChangeVO entity) {
        ArrayList<ChangeCertsVO> certs;
        if (CollectionUtils.isNotEmpty((Collection)entity.getCerts())) {
            certs = new ArrayList<ChangeCertsVO>();
            for (ChangeCertsVO base : entity.getCerts()) {
                if (base.getIsDel() != 0) continue;
                certs.add(base);
            }
            entity.setCerts(certs);
        }
        if (CollectionUtils.isNotEmpty((Collection)entity.getBanks())) {
            certs = new ArrayList();
            for (ChangeCertsVO base : entity.getBanks()) {
                if (base.getIsDel() != 0) continue;
                certs.add(base);
            }
            entity.setBanks(certs);
        }
        if (CollectionUtils.isNotEmpty((Collection)entity.getBrandList())) {
            certs = new ArrayList();
            for (ChangeCertsVO base : entity.getBrandList()) {
                if (base.getIsDel() != 0) continue;
                certs.add(base);
            }
            entity.setBrandList(certs);
        }
        if (CollectionUtils.isNotEmpty((Collection)entity.getProductionList())) {
            certs = new ArrayList();
            for (ChangeCertsVO base : entity.getProductionList()) {
                if (base.getIsDel() != 0) continue;
                certs.add(base);
            }
            entity.setProductionList(certs);
        }
        if (CollectionUtils.isNotEmpty((Collection)entity.getFinanceReportList())) {
            certs = new ArrayList();
            for (ChangeCertsVO base : entity.getFinanceReportList()) {
                if (base.getIsDel() != 0) continue;
                certs.add(base);
            }
            entity.setFinanceReportList(certs);
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> queryDetail(Long id) {
        ChangeEntity entity = (ChangeEntity)((Object)this.service.selectById(id));
        if ("maker".equals(entity.getEnterpriseType()) && CollectionUtils.isNotEmpty(entity.getBrandList())) {
            List ids = entity.getBrandList().stream().map(x -> x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("brandId", new Parameter("in", ids));
            List productionList = this.productService.queryList(param);
            Map<Long, List<ChangeProductEntity>> hourMap = productionList.stream().collect(Collectors.groupingBy(x -> x.getBrandId()));
            for (ChangeBrandEntity brand : entity.getBrandList()) {
                brand.setProductionsList(hourMap.get(brand.getId()));
            }
            entity.setProductionList(null);
        }
        ChangeVO vo = (ChangeVO)BeanMapper.map((Object)((Object)entity), ChangeVO.class);
        this.processSubsReturn(vo);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ChangeVO changeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ChangeVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("socialCreditCode");
        param.getParams().put("changState", new Parameter("sql", (Object)" ( chang_state IS NULL OR chang_state NOT IN ('free','returned') ) "));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListCG"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ChangeVO>> queryListCG(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("socialCreditCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("originFrom", new Parameter("eq", (Object)"supplier"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Change-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ChangeVO>> refChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/newSupplierChange"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Long> newSupplierChange(@RequestParam Long supplierId, @RequestParam String originFrom) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        QueryParam param = new QueryParam();
        param.getParams().put("originId", new Parameter("eq", (Object)supplierId));
        param.getParams().put("billState", new Parameter("in", (Object)"0,2,4,5,6"));
        List list = this.service.queryList(param, false);
        if (ListUtil.isNotEmpty((List)list)) {
            return CommonResponse.error((String)("\u8be5\u4f9b\u5e94\u5546\u5b58\u5728\u672a\u751f\u6548\u7684\u4f9b\u5e94\u5546\u53d8\u66f4\u5355\uff0c\u7f16\u53f7\uff1a\u3010" + ((ChangeEntity)((Object)list.get(0))).getBillCode() + "\u3011"));
        }
        CommonResponse commonResponse = this.iSupplierApi.getSupplierInfo(supplierId);
        if (!commonResponse.isSuccess()) {
            return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u4fe1\u606f\u67e5\u8be2\u5931\u8d25:" + commonResponse.getMsg()));
        }
        if (commonResponse.getData() == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u67e5\u8be2\u5931\u8d25:\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        SupplierVO supplierVO = (SupplierVO)commonResponse.getData();
        ChangeEntity changeEntity = (ChangeEntity)((Object)BeanMapper.map((Object)supplierVO, ChangeEntity.class));
        changeEntity.setId(IdWorker.getId());
        changeEntity.setTenantId(InvocationInfoProxy.getTenantid());
        changeEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
        changeEntity.setCreateTime(new Date());
        changeEntity.setUpdateTime(null);
        changeEntity.setUpdateUserCode(null);
        changeEntity.setBillState(0);
        changeEntity.setOriginId(supplierId);
        changeEntity.setOriginFrom(originFrom);
        changeEntity.setChangeDate(new Date());
        if (Objects.equals(originFrom, "supplier")) {
            changeEntity.setChangState("free");
        }
        if ((billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)supplierVO))).isSuccess()) {
            changeEntity.setBillCode((String)billCode.getData());
        } else {
            changeEntity.setBillCode("CHANGE-" + DateFormatUtil.formatDate((String)"yyyyMMdd-HHmmss", (Date)new Date()));
        }
        List contactList = BeanMapper.mapList((Iterable)supplierVO.getCerts(), ChangeCertsEntity.class);
        contactList.forEach(certs -> {
            certs.setOriginId(certs.getId());
            certs.setId(IdWorker.getId());
            certs.setIsDel(0);
            certs.setCreateUserCode(InvocationInfoProxy.getUsercode());
            certs.setTenantId(InvocationInfoProxy.getTenantid());
            certs.setCreateTime(new Date());
            certs.setUpdateTime(null);
            certs.setPid(changeEntity.getId());
            certs.setUpdateUserCode(null);
        });
        changeEntity.setCerts(contactList);
        List bankList = BeanMapper.mapList((Iterable)supplierVO.getBanks(), ChangeBankEntity.class);
        bankList.forEach(changeBankEntity -> {
            changeBankEntity.setOriginId(changeBankEntity.getId());
            changeBankEntity.setId(IdWorker.getId());
            changeBankEntity.setIsDel(0);
            changeBankEntity.setTenantId(InvocationInfoProxy.getTenantid());
            changeBankEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            changeBankEntity.setCreateTime(new Date());
            changeBankEntity.setUpdateTime(null);
            changeBankEntity.setUpdateUserCode(null);
            changeBankEntity.setPid(changeEntity.getId());
        });
        changeEntity.setBanks(bankList);
        List financeReportList = BeanMapper.mapList((Iterable)supplierVO.getFinanceReportList(), ChangeFinanceReportEntity.class);
        financeReportList.forEach(changeFinanceReportEntity -> {
            changeFinanceReportEntity.setOriginId(changeFinanceReportEntity.getId());
            changeFinanceReportEntity.setId(IdWorker.getId());
            changeFinanceReportEntity.setIsDel(0);
            changeFinanceReportEntity.setTenantId(InvocationInfoProxy.getTenantid());
            changeFinanceReportEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            changeFinanceReportEntity.setCreateTime(new Date());
            changeFinanceReportEntity.setUpdateUserCode(null);
            changeFinanceReportEntity.setUpdateTime(null);
            changeFinanceReportEntity.setPid(changeEntity.getId());
        });
        changeEntity.setFinanceReportList(financeReportList);
        List brandList = BeanMapper.mapList((Iterable)supplierVO.getBrandList(), ChangeBrandEntity.class);
        brandList.forEach(brand -> {
            brand.setOriginId(brand.getId());
            brand.setIsDel(0);
            brand.setId(IdWorker.getId());
            brand.setTenantId(InvocationInfoProxy.getTenantid());
            brand.setCreateUserCode(InvocationInfoProxy.getUsercode());
            brand.setUpdateUserCode(null);
            brand.setCreateTime(new Date());
            brand.setUpdateTime(null);
            brand.setCanInId(changeEntity.getId());
        });
        changeEntity.setBrandList(brandList);
        List productionList = BeanMapper.mapList((Iterable)supplierVO.getProductionList(), ChangeProductEntity.class);
        productionList.forEach(production -> {
            production.setOriginId(production.getId());
            production.setOriginBrandId(production.getBrandId());
            for (ChangeBrandEntity brandEntity : brandList) {
                if (!brandEntity.getOriginId().equals(production.getBrandId())) continue;
                production.setBrandId(brandEntity.getId());
            }
            production.setIsDel(0);
            production.setId(IdWorker.getId());
            production.setTenantId(InvocationInfoProxy.getTenantid());
            production.setCreateUserCode(InvocationInfoProxy.getUsercode());
            production.setCreateTime(new Date());
            production.setUpdateUserCode(null);
            production.setUpdateTime(null);
            production.setCanInId(changeEntity.getId());
        });
        changeEntity.setProductionList(productionList);
        this.service.saveOrUpdate((Object)changeEntity, false);
        return CommonResponse.success((Object)changeEntity.getId());
    }

    @RequestMapping(value={"/newChange"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Long> newChange() {
        CommonResponse commonResponse = this.iSupplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if (!commonResponse.isSuccess()) {
            return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u4fe1\u606f\u67e5\u8be2\u5931\u8d25:" + commonResponse.getMsg()));
        }
        if (commonResponse.getData() == null) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u67e5\u8be2\u5931\u8d25:\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\uff01");
        }
        return this.newSupplierChange(((SupplierDTO)commonResponse.getData()).getId(), "supplier");
    }
}

