/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller.report;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.GradeEntity;
import com.ejianc.business.pro.supplier.consts.SupplyQueryTypeUrlEnum;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.business.pro.supplier.vo.IncidentVO;
import com.ejianc.business.pro.supplier.vo.PunishVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"supplierReport"})
public class SupplierReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IPunishService service;
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private IGradeService gradeService;
    @Autowired
    private IDefdocApi defdocApi;
    private static String PUNISH_REASON_CODE = "pro-supply-deal-reason";

    @RequestMapping(value={"/punishList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<PunishVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getFuzzyFields().add("supplyTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("applyDate", "desc");
        IPage page = this.service.queryPage(param, false);
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        CommonResponse orgResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(orgId);
        List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List punishVOS = BeanMapper.mapList((Iterable)page.getRecords(), PunishVO.class);
        if (CollectionUtils.isNotEmpty((Collection)punishVOS)) {
            Map<Object, Object> defMap = new HashMap();
            CommonResponse defDocByDefCode = this.defdocApi.getDefDocByDefCode(PUNISH_REASON_CODE);
            if (defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)defDocByDefCode.getData()))) {
                defMap = ((List)defDocByDefCode.getData()).stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName));
            }
            Map<Object, Object> gradeMap = new HashMap();
            List list = this.gradeService.list();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                gradeMap = list.stream().collect(Collectors.toMap(BaseEntity::getId, GradeEntity::getWeight, (key1, key2) -> key2));
            }
            for (PunishVO t : punishVOS) {
                Long oldGrade = t.getOldGrade();
                Long gradeId = t.getGradeId();
                Integer oldWeight = gradeMap.get(oldGrade) == null ? Integer.valueOf(0) : (Integer)gradeMap.get(oldGrade);
                Integer weight = gradeMap.get(gradeId) == null ? Integer.valueOf(0) : (Integer)gradeMap.get(gradeId);
                t.setIsLower(weight < oldWeight ? "\u662f" : "\u5426");
                t.setUrl("/ejc-prosupplier-frontend/#/punish/card?id=" + t.getId());
                t.setClickable(orgIdList.contains(t.getApplyOrgId()) ? Boolean.TRUE : Boolean.FALSE);
                t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription());
                t.setMemo((String)defMap.get(t.getReason()));
            }
        }
        pageData.setRecords(punishVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelPunishExport"}, method={RequestMethod.POST})
    public void excelPunishExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getFuzzyFields().add("supplyTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("applyDate", "desc");
        List punishEntityList = this.service.queryList(param);
        List punishVOS = BeanMapper.mapList((Iterable)punishEntityList, PunishVO.class);
        if (CollectionUtils.isNotEmpty((Collection)punishVOS)) {
            Map<Object, Object> defMap = new HashMap();
            CommonResponse defDocByDefCode = this.defdocApi.getDefDocByDefCode(PUNISH_REASON_CODE);
            if (defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)defDocByDefCode.getData()))) {
                defMap = ((List)defDocByDefCode.getData()).stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName));
            }
            Map<Object, Object> gradeMap = new HashMap();
            List list = this.gradeService.list();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                gradeMap = list.stream().collect(Collectors.toMap(BaseEntity::getId, GradeEntity::getWeight, (key1, key2) -> key2));
            }
            for (PunishVO t : punishVOS) {
                Long oldGrade = t.getOldGrade();
                Long gradeId = t.getGradeId();
                Integer oldWeight = gradeMap.get(oldGrade) == null ? Integer.valueOf(0) : (Integer)gradeMap.get(oldGrade);
                Integer weight = gradeMap.get(gradeId) == null ? Integer.valueOf(0) : (Integer)gradeMap.get(gradeId);
                t.setIsLower(weight < oldWeight ? "\u662f" : "\u5426");
                t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription());
                t.setMemo((String)defMap.get(t.getReason()));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", punishVOS);
        ExcelExport.getInstance().export("supplier-report-punish-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/appraiseList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<IncidentVO>> appraiseList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("appraiseType");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        CommonResponse orgResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(orgId);
        List orgIdList = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("date", "desc");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<IncidentVO> list = this.incidentService.queryAppraiseList((Page<IncidentVO>)page, wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(t -> {
                t.setUrl("/ejc-prosupplier-frontend/#" + SupplyQueryTypeUrlEnum.getUrl((String)(t.getAppraiseType() + t.getSupplyQueryType())) + t.getId());
                t.setClickable(orgIdList.contains(t.getOrgId()) ? Boolean.TRUE : Boolean.FALSE);
            });
        }
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelAppraiseExport"}, method={RequestMethod.POST})
    public void excelAppraiseExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("appraiseType");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("date", "desc");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<IncidentVO> list = this.incidentService.queryAppraiseList((Page<IncidentVO>)page, wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription()));
        }
        HashMap<String, List<IncidentVO>> beans = new HashMap<String, List<IncidentVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("supplier-report-appraise-export.xlsx", beans, response);
    }
}

