package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.bean.ProcessEntity;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.IncidentVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("pushProcessLogic")
public class PushProcessRuleALogic implements PushProcessLogic {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "INCIDENT";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;

    @Override
    public List<IncidentVO> logicOne(AppraiseParamVO appraiseParamVO) {
        List<IncidentVO> processList = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        String contractType = appraiseParamVO.getContractType();
        if (StringUtils.isNotEmpty(contractType)){
            List<String> contractTypeList = new ArrayList<>();
            queryParam.getParams().put("sourceType", new Parameter(QueryParam.IN,contractTypeList ));
        }
        return processList;
    }

    @Override
    public List<IncidentVO> logicTwo(AppraiseParamVO appraiseParamVO) {
        List<IncidentVO> processList = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        String contractType = appraiseParamVO.getContractType();
        if (StringUtils.isNotEmpty(contractType)){
            List<String> contractTypeList = new ArrayList<>();
            queryParam.getParams().put("sourceType", new Parameter(QueryParam.IN,contractTypeList ));
        }
        return processList;
    }

    @Override
    public List<IncidentVO> getAnnualIncidentPushList(AppraiseParamVO appraiseParamVO, String startDate) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractProperty", new Parameter(QueryParam.EQ, 0));


        String endDate = DateUtil.getYear() + "-" + appraiseParamVO.getYearPushDate();
        QueryWrapper<IncidentEntity> incidentQuery = new QueryWrapper<>();
        incidentQuery.select("distinct(contract_id)");
        incidentQuery.eq("dr", BaseVO.DR_UNDELETE);
        incidentQuery.ge("date_format(create_time,'%Y-%m-%d')", startDate);
        incidentQuery.le("date_format(create_time,'%Y-%m-%d')", endDate);
        List<Long> incidentIds = incidentService.listObjs(incidentQuery, (item) -> Long.valueOf(item.toString()));

        QueryWrapper<ProcessEntity> processQuery = new QueryWrapper<>();
        processQuery.select("distinct(contract_id)");
        processQuery.eq("dr", BaseVO.DR_UNDELETE);
        processQuery.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        processQuery.ge("date_format(create_time,'%Y-%m-%d')", startDate);
        processQuery.le("date_format(create_time,'%Y-%m-%d')", endDate);
        List<Long> processIds = incidentService.listObjs(incidentQuery, (item) -> Long.valueOf(item.toString()));


        return null;
    }
}
