/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.InvestigateContentEntity;
import com.ejianc.business.pro.supplier.bean.InvestigateEntity;
import com.ejianc.business.pro.supplier.bean.InvestigateModleContentEntity;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IInvestigateModleService;
import com.ejianc.business.pro.supplier.service.IInvestigateService;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="canIn")
public class CanInBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICanInService service;
    @Autowired
    private ISupplierApi iProSupplierApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IInvestigateModleService iInvestigateModleService;
    @Autowired
    private IInvestigateService investigateService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        CanInEntity canInEntity = (CanInEntity)((Object)this.service.selectById(billId));
        if (canInEntity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u8be5\u51c6\u5165\u5355\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("ne", (Object)billId));
        param.getParams().put("socialCreditCode", new Parameter("eq", (Object)canInEntity.getSocialCreditCode()));
        List canInEntities = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)canInEntities)) {
            if ("p".equals(canInEntity.getPersonal())) {
                return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u8eab\u4efd\u8bc1\u53f7\u4e3a\u3010" + canInEntity.getSocialCreditCode() + "\u3011\u7684\u4e2a\u4eba\u4f9b\u5e94\u5546\uff01"));
            }
            return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u3010" + canInEntity.getSocialCreditCode() + "\u3011\u7684\u4f01\u4e1a\u4f9b\u5e94\u5546\uff01"));
        }
        this.logger.info("canInEntity:{}", (Object)JSONObject.toJSONString((Object)((Object)canInEntity)));
        CommonResponse exist = this.iProSupplierApi.judgeTaxpayerNumIsRepeat(canInEntity.getSocialCreditCode(), "e");
        if (!exist.isSuccess()) {
            return exist;
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CanInEntity canInEntity = (CanInEntity)((Object)this.service.selectById(billId));
        if (canInEntity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u8be5\u51c6\u5165\u5355\uff01");
        }
        if (canInEntity.getInvestigate() == null || !canInEntity.getInvestigate().booleanValue()) {
            return this.service.pushSupplierToShare(canInEntity, billTypeCode);
        }
        InvestigateEntity entity = new InvestigateEntity();
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("INVESTIGATE", InvocationInfoProxy.getTenantid());
        entity.setId(IdWorker.getId());
        if (billCode.isSuccess()) {
            entity.setCode((String)billCode.getData());
        } else {
            entity.setCode(("KC-" + IdWorker.getId()).substring(0, 8));
        }
        entity.setCanInId(billId);
        entity.setBillState(0);
        entity.setSupplierName(canInEntity.getName());
        entity.setScore("0");
        entity.setInvestigateResults("noPass");
        entity.setState("to");
        entity.setEnterpriseType(canInEntity.getEnterpriseType());
        entity.setSupplyContent(canInEntity.getSupplyContent());
        List<InvestigateModleContentEntity> modelContentEntities = this.iInvestigateModleService.queryTypeName(canInEntity.getEnterpriseType());
        if (ListUtil.isEmpty(modelContentEntities)) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u9700\u8981\u8003\u5bdf\uff0c\u672a\u627e\u5230\u8003\u5bdf\u6a21\u677f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u540e\u518d\u6b21\u5ba1\u6279\uff01");
        }
        for (InvestigateModleContentEntity modelContentEntity : modelContentEntities) {
            InvestigateContentEntity contentEntity = (InvestigateContentEntity)((Object)BeanMapper.map((Object)((Object)modelContentEntity), InvestigateContentEntity.class));
            contentEntity.setId(IdWorker.getId());
            contentEntity.setPid(entity.getId());
            contentEntity.setSubScore("0");
            entity.getInvestigateContentEntities().add(contentEntity);
        }
        this.investigateService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u4e0d\u652f\u6301\u64a4\u56de\u6216\u8005\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

