package com.ejianc.business.pro.change.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 供应商品牌变更
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supplier_change_brand")
public class ChangeBrandEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="origin_id")
    private Long originId; // 原始id
    @TableField(value="is_del")
    private Integer isDel; // 是否删除
    @TableField(value="can_in_id")
    private Long canInId; // 主表主键ID
    @TableField(value="brand_type_id")
    private Long brandTypeId; // 品牌分类
    @TableField(value="brand_type_name")
    private String brandTypeName; // 品牌分类名称
    @TableField(value="brand_name")
    private String brandName; // 品牌名称
    @TableField(value="brand_code")
    private String brandCode; // 商标注册号
    @TableField(value="brand_expiration_date")
    private Date brandExpirationDate; // 商标有效期
    @TableField(value="authorize_expiration_date")
    private Date authorizeExpirationDate; // 授权有效期

    @TableField(exist=false)
    @SubEntity(serviceName="changeProductService",pidName = "brandId")
    private List<ChangeProductEntity> productionsList = new ArrayList<>(); // 供应商准入---产品信息子表

    public List<ChangeProductEntity> getProductionsList() {
        return productionsList;
    }

    public void setProductionsList(List<ChangeProductEntity> productionsList) {
        this.productionsList = productionsList;
    }

    public Long getOriginId() {
        return originId;
    }

    public void setOriginId(Long originId) {
        this.originId = originId;
    }
    public Integer getIsDel() {
        return isDel;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
    }
    public Long getCanInId() {
        return canInId;
    }

    public void setCanInId(Long canInId) {
        this.canInId = canInId;
    }
    public Long getBrandTypeId() {
        return brandTypeId;
    }

    public void setBrandTypeId(Long brandTypeId) {
        this.brandTypeId = brandTypeId;
    }
    public String getBrandTypeName() {
        return brandTypeName;
    }

    public void setBrandTypeName(String brandTypeName) {
        this.brandTypeName = brandTypeName;
    }
    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }
    public Date getBrandExpirationDate() {
        return brandExpirationDate;
    }

    public void setBrandExpirationDate(Date brandExpirationDate) {
        this.brandExpirationDate = brandExpirationDate;
    }
    public Date getAuthorizeExpirationDate() {
        return authorizeExpirationDate;
    }

    public void setAuthorizeExpirationDate(Date authorizeExpirationDate) {
        this.authorizeExpirationDate = authorizeExpirationDate;
    }
    
}
