package com.ejianc.business.pro.change.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pro.change.bean.*;
import com.ejianc.business.pro.change.service.IChangeBrandService;
import com.ejianc.business.pro.change.service.IChangeProductService;
import com.ejianc.business.pro.change.vo.*;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.change.service.IChangeService;

/**
 * 供应商变更主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("change")
public class ChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISupplierApi iSupplierApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IChangeService service;
    @Autowired
    private IChangeBrandService brandService;
    @Autowired
    private IChangeProductService productService;

    @Autowired
    private ICanInService canInService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeVO> saveOrUpdate(@RequestBody ChangeVO saveOrUpdateVO) {
    	ChangeEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        QueryParam param = new QueryParam();
        param.getParams().put("billState",new Parameter(QueryParam.IN,"0,2,4,5,6"));//非生效单据
        param.getParams().put("socialCreditCode",new Parameter(QueryParam.EQ,saveOrUpdateVO.getSocialCreditCode()));
        List<CanInEntity> canInEntities = canInService.queryList(param);
        if(CollectionUtils.isNotEmpty(canInEntities)){
            return CommonResponse.error("准入数据中：统一社会信用代码重复!");
        }
        /** 校验供应商库 */
        CommonResponse<String> exist = iSupplierApi.judgeTaxpayerNumIsRepeat(saveOrUpdateVO.getSocialCreditCode(),entity.getOriginId(), "e");
        if(!exist.isSuccess()){
            return CommonResponse.error("供应商库中：统一社会信用代码重复!");
        }
        processSubs(entity);
        // 处理孙表
        Set<Long> set = new HashSet<>();
        if(CollectionUtils.isNotEmpty(entity.getBrandList())){
            for(ChangeBrandEntity brand : entity.getBrandList()){
                brandService.saveOrUpdate(brand, false);
                set.add(brand.getId());
            }
        }
    	service.saveOrUpdate(entity, false);
        //更新孙子表里的 主表id  后续查询用
        if(CollectionUtils.isNotEmpty(entity.getBrandList())){
            LambdaUpdateWrapper<ChangeProductEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(ChangeProductEntity::getBrandId, set);
            updateWrapper.set(ChangeProductEntity::getCanInId, entity.getId());
            productService.update(updateWrapper);
        }
    	ChangeVO vo = BeanMapper.map(entity, ChangeVO.class);
        processSubsReturn(vo);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    private void processSubs(ChangeEntity entity){
        if(CollectionUtils.isNotEmpty(entity.getCerts())){
            for (ChangeCertsEntity base : entity.getCerts()) {
                if(Objects.equals(base.getRowState(),"del")){
                    base.setRowState(null);
                    base.setIsDel(1);
                }else {
                    base.setIsDel(0);
                }
            }
        }
        if(CollectionUtils.isNotEmpty(entity.getBanks())){
            for (ChangeBankEntity base : entity.getBanks()) {
                if(Objects.equals(base.getRowState(),"del")){
                    base.setRowState(null);
                    base.setIsDel(1);
                }else {
                    base.setIsDel(0);
                }
            }
        }
        if(CollectionUtils.isNotEmpty(entity.getBrandList())){
            for (ChangeBrandEntity base : entity.getBrandList()) {
                if(Objects.equals(base.getRowState(),"del")){
                    base.setRowState(null);
                    base.setIsDel(1);
                }else {
                    base.setIsDel(0);
                }
                if(ListUtil.isNotEmpty(base.getProductionsList())){
                    for (ChangeProductEntity production : base.getProductionsList()) {
                        if(Objects.equals(base.getRowState(),"del")){
                            production.setRowState(null);
                            production.setIsDel(1);
                        }else {
                            if(Objects.equals(production.getRowState(),"del")){
                                production.setRowState(null);
                                production.setIsDel(1);
                            }else {
                                production.setIsDel(0);
                            }
                        }
                    }
                }
            }
        }
        if(CollectionUtils.isNotEmpty(entity.getProductionList())){
            for (ChangeProductEntity base : entity.getProductionList()) {
                if(Objects.equals(base.getRowState(),"del")){
                    base.setRowState(null);
                    base.setIsDel(1);
                }else {
                    base.setIsDel(0);
                }
            }
        }
        if(CollectionUtils.isNotEmpty(entity.getFinanceReportList())){
            for (ChangeFinanceReportEntity base : entity.getFinanceReportList()) {
                if(Objects.equals(base.getRowState(),"del")){
                    base.setRowState(null);
                    base.setIsDel(1);
                }else {
                    base.setIsDel(0);
                }
            }
        }
    }
    private void processSubsReturn(ChangeVO entity){
        if(CollectionUtils.isNotEmpty(entity.getCerts())){
            List<ChangeCertsVO> certs = new ArrayList<>();
            for (ChangeCertsVO base : entity.getCerts()) {
                if(base.getIsDel() == 0){
                    certs.add(base);
                }
            }
            entity.setCerts(certs);
        }
        if(CollectionUtils.isNotEmpty(entity.getBanks())){
            List<ChangeBankVO> certs = new ArrayList<>();
            for (ChangeBankVO base : entity.getBanks()) {
                if(base.getIsDel() == 0){
                    certs.add(base);
                }
            }
            entity.setBanks(certs);
        }
        if(CollectionUtils.isNotEmpty(entity.getBrandList())){
            List<ChangeBrandVO> certs = new ArrayList<>();
            for (ChangeBrandVO base : entity.getBrandList()) {
                if(base.getIsDel() == 0){
                    certs.add(base);
                }
            }
            entity.setBrandList(certs);
        }
        if(CollectionUtils.isNotEmpty(entity.getProductionList())){
            List<ChangeProductVO> certs = new ArrayList<>();
            for (ChangeProductVO base : entity.getProductionList()) {
                if(base.getIsDel() == 0){
                    certs.add(base);
                }
            }
            entity.setProductionList(certs);
        }
        if(CollectionUtils.isNotEmpty(entity.getFinanceReportList())){
            List<ChangeFinanceReportVO> certs = new ArrayList<>();
            for (ChangeFinanceReportVO base : entity.getFinanceReportList()) {
                if(base.getIsDel() == 0){
                    certs.add(base);
                }
            }
            entity.setFinanceReportList(certs);
        }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeVO> queryDetail(Long id) {
    	ChangeEntity entity = service.selectById(id);
        if("maker".equals(entity.getEnterpriseType())&&CollectionUtils.isNotEmpty(entity.getBrandList())){
            //制造商需要处理子孙表
            List<Long> ids = entity.getBrandList().stream().map(x->x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("brandId", new Parameter(QueryParam.IN, ids));
            param.getParams().put("isDel", new Parameter(QueryParam.EQ, 0));
            List<ChangeProductEntity> productionList = productService.queryList(param);
            Map<Long, List<ChangeProductEntity>> hourMap = productionList.stream().collect(Collectors.groupingBy(x->x.getBrandId()));
            for(ChangeBrandEntity brand : entity.getBrandList()){
                brand.setProductionsList(hourMap.get(brand.getId()));
            }
            entity.setProductionList(null);
        }
    	ChangeVO vo = BeanMapper.map(entity, ChangeVO.class);
        processSubsReturn(vo);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ChangeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * @Description queryList 查询列表 运营平台查询
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("socialCreditCode");
        param.getParams().put("changState", new Parameter(QueryParam.SQL, " ( chang_state IS NULL OR chang_state NOT IN ('free','returned') ) "));//不查询驳回删除的
        IPage<ChangeEntity> page = service.queryPage(param,false);
        IPage<ChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询列表 采购租户查询
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListCG", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeVO>> queryListCG(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("socialCreditCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("originFrom", new Parameter(QueryParam.EQ, "supplier"));

        IPage<ChangeEntity> page = service.queryPage(param,false);
        IPage<ChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Change-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangeVO>> refChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangeEntity> page = service.queryPage(param,false);
        IPage<ChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/newSupplierChange", method = RequestMethod.GET)
    @ResponseBody
     public CommonResponse<Long> newSupplierChange(@RequestParam Long supplierId,@RequestParam String originFrom){
        QueryParam param = new QueryParam();
        param.getParams().put("originId",new Parameter(QueryParam.EQ,supplierId));
        param.getParams().put("billState",new Parameter(QueryParam.IN,"0,2,4,5,6"));
        List<ChangeEntity> list =service.queryList(param,false);
        if(ListUtil.isNotEmpty(list)){
            return CommonResponse.error("该供应商存在未生效的供应商变更单，来源："+(Objects.equals(list.get(0).getOriginFrom(),"supplier")?"供应商自己变更尚未提交" :"自制")+"，编号：【"+list.get(0).getBillCode()+"】");
        }
        CommonResponse<SupplierVO> commonResponse =  iSupplierApi.getSupplierInfo(supplierId);
        if(!commonResponse.isSuccess()){
            return CommonResponse.error("供应商信息查询失败:"+commonResponse.getMsg());
        }
        if(commonResponse.getData()==null){
            return CommonResponse.error("供应商信息查询失败:供应商不存在！");
        }
        SupplierVO supplierVO = commonResponse.getData();
        ChangeEntity changeEntity = BeanMapper.map(supplierVO,ChangeEntity.class);
        changeEntity.setId(IdWorker.getId());
        changeEntity.setTenantId(InvocationInfoProxy.getTenantid());
        changeEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
        changeEntity.setCreateTime(new Date());
        changeEntity.setUpdateTime(null);
        changeEntity.setUpdateUserCode(null);
        changeEntity.setBillState(0);
        changeEntity.setOriginId(supplierId);
        changeEntity.setOriginFrom(originFrom);
        changeEntity.setChangeDate(new Date());
        if(Objects.equals(originFrom,"supplier")){
            changeEntity.setChangState("free");
        }
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),supplierVO);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(billCode.isSuccess()) {
            changeEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        }else{
            changeEntity.setBillCode("CHANGE-"+ DateFormatUtil.formatDate("yyyyMMdd-HHmmss", new Date()));//此处需要根据实际修改 删除本行或者上一行
        }

        /** 处理子表 */
        List<ChangeCertsEntity> contactList = BeanMapper.mapList(supplierVO.getCerts(), ChangeCertsEntity.class);
        contactList.forEach(certs -> {
            certs.setOriginId(certs.getId());
            certs.setId(IdWorker.getId());
            certs.setIsDel(0);
            certs.setCreateUserCode(InvocationInfoProxy.getUsercode());
            certs.setTenantId(InvocationInfoProxy.getTenantid());
            certs.setCreateTime(new Date());
            certs.setUpdateTime(null);
            certs.setPid(changeEntity.getId());
            certs.setUpdateUserCode(null);
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(certs.getOriginId()), "BT211210000000001", "K1639386256873",
                    String.valueOf(certs.getId()), "BT211210000000001", "K1639386256873");//证件附件
        });

        changeEntity.setCerts(contactList);

        List<ChangeBankEntity> bankList = BeanMapper.mapList(supplierVO.getBanks(), ChangeBankEntity.class);
        bankList.forEach(changeBankEntity -> {
            changeBankEntity.setOriginId(changeBankEntity.getId());
            changeBankEntity.setId(IdWorker.getId());
            changeBankEntity.setIsDel(0);
            changeBankEntity.setTenantId(InvocationInfoProxy.getTenantid());
            changeBankEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            changeBankEntity.setCreateTime(new Date());
            changeBankEntity.setUpdateTime(null);
            changeBankEntity.setUpdateUserCode(null);
            changeBankEntity.setPid(changeEntity.getId());
        });
        changeEntity.setBanks(bankList);

        List<ChangeFinanceReportEntity> financeReportList = BeanMapper.mapList(supplierVO.getFinanceReportList(), ChangeFinanceReportEntity.class);
        financeReportList.forEach(changeFinanceReportEntity -> {
            changeFinanceReportEntity.setOriginId(changeFinanceReportEntity.getId());
            changeFinanceReportEntity.setId(IdWorker.getId());
            changeFinanceReportEntity.setIsDel(0);
            changeFinanceReportEntity.setTenantId(InvocationInfoProxy.getTenantid());
            changeFinanceReportEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
            changeFinanceReportEntity.setCreateTime(new Date());
            changeFinanceReportEntity.setUpdateUserCode(null);
            changeFinanceReportEntity.setUpdateTime(null);
            changeFinanceReportEntity.setPid(changeEntity.getId());
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeFinanceReportEntity.getOriginId()), "BT211210000000001", "caibaofujian",
                    String.valueOf(changeFinanceReportEntity.getId()), "BT211210000000001", "caibaofujian");//财报附件
        });
        changeEntity.setFinanceReportList(financeReportList);

        List<ChangeBrandEntity> brandList = BeanMapper.mapList(supplierVO.getBrandList(), ChangeBrandEntity.class);
        brandList.forEach(brand->{
            brand.setOriginId(brand.getId());
            brand.setIsDel(0);
            brand.setId(IdWorker.getId());
            brand.setTenantId(InvocationInfoProxy.getTenantid());
            brand.setCreateUserCode(InvocationInfoProxy.getUsercode());
            brand.setUpdateUserCode(null);
            brand.setCreateTime(new Date());
            brand.setUpdateTime(null);
            brand.setCanInId(changeEntity.getId());
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(brand.getOriginId()), "BT211210000000001", "pinpailogo",
                    String.valueOf(brand.getId()), "BT211210000000001", "pinpailogo");//品牌logo
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(brand.getOriginId()), "BT211210000000001", "shangbiaoshu",
                    String.valueOf(brand.getId()), "BT211210000000001", "shangbiaoshu");//商标证书
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(brand.getOriginId()), "BT211210000000001", "shouquanshu",
                    String.valueOf(brand.getId()), "BT211210000000001", "shouquanshu");//授权书
        });
        changeEntity.setBrandList(brandList);

        List<ChangeProductEntity> productionList = BeanMapper.mapList(supplierVO.getProductionList(), ChangeProductEntity.class);
        productionList.forEach(production->{
            production.setOriginId(production.getId());
            production.setOriginBrandId(production.getBrandId());
            for (ChangeBrandEntity brandEntity : brandList) {
                if(brandEntity.getOriginId().equals(production.getBrandId())){
                    production.setBrandId(brandEntity.getId());
                }
            }
            production.setIsDel(0);
            production.setId(IdWorker.getId());
            production.setTenantId(InvocationInfoProxy.getTenantid());
            production.setCreateUserCode(InvocationInfoProxy.getUsercode());
            production.setCreateTime(new Date());
            production.setUpdateUserCode(null);
            production.setUpdateTime(null);
            production.setCanInId(changeEntity.getId());
            attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(production.getOriginId()), "BT211210000000001", "productPicture",
                    String.valueOf(production.getId()), "BT211210000000001", "productPicture");//产品图片
        });
        changeEntity.setProductionList(productionList);
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierId), "BT211210000000001", "attachMgr",
                String.valueOf(changeEntity.getId()), "BT211210000000001", "attachMgr");//附件
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierId), "BT211210000000001", "K1639384111794",
                String.valueOf(changeEntity.getId()), "BT211210000000001", "K1639384111794");//法人委托授权书
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierId), "BT211210000000001", "K1639384112713",
                String.valueOf(changeEntity.getId()), "BT211210000000001", "K1639384112713");//法人身份复印件
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierId), "BT211210000000001", "K1639384499212",
                String.valueOf(changeEntity.getId()), "BT211210000000001", "K1639384499212");//营业执照
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(supplierId), "BT211210000000001", "K16393844992144",
                String.valueOf(changeEntity.getId()), "BT211210000000001", "K16393844992144");//开户许可证
        service.saveOrUpdate(changeEntity,false);
        return CommonResponse.success(changeEntity.getId());
     }

     /**
      * 供应商新增变更
      * */
    @RequestMapping(value = "/newChange", method = RequestMethod.GET)
    @ResponseBody
     public CommonResponse<Long> newChange(){
        CommonResponse<SupplierDTO> commonResponse =  iSupplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if(!commonResponse.isSuccess()){
            return CommonResponse.error("供应商信息查询失败:"+commonResponse.getMsg());
        }
        if(commonResponse.getData()==null){
            return CommonResponse.error("供应商信息查询失败:供应商不存在！");
        }
        return newSupplierChange(commonResponse.getData().getId(),"supplier");
     }


     /**
      * 驳回删除实现
      * */
    @RequestMapping(value = "/returnBack", method = RequestMethod.GET)
    @ResponseBody
     public CommonResponse<String> returnBack(@RequestParam Long id , @RequestParam(required = false) String reason){
        ChangeEntity changeEntity = service.getById(id);
        if(changeEntity==null){
            return CommonResponse.error("供应商变更信息不存在！");
        }
        changeEntity.setChangState("returned");
        changeEntity.setReturnReason(reason);
        service.saveOrUpdate(changeEntity,false);
        return CommonResponse.success("驳回成功！");
     }


    /**
     * 供应商企业信息查询供应商自己发起的变更记录
     * */
    @RequestMapping(value = "/queryChangeListForSelf", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ChangeVO>> queryChangeListForSelf(){
        CommonResponse<SupplierDTO> commonResponse =  iSupplierApi.getSupplierBySupplierTenantId(InvocationInfoProxy.getTenantid());
        if(!commonResponse.isSuccess()){
            return CommonResponse.error("供应商信息查询失败:"+commonResponse.getMsg());
        }
        if(commonResponse.getData()==null){
            return CommonResponse.error("供应商信息查询失败:供应商不存在！");
        }
        QueryParam queryParam = QueryParam.getInstance();
        queryParam.getParams().put("originId",new Parameter(QueryParam.EQ,commonResponse.getData().getId()));
        queryParam.getParams().put("originFrom",new Parameter(QueryParam.EQ,"supplier"));
        queryParam.getParams().put("changState",new Parameter(QueryParam.EQ,"pass"));
        List<ChangeEntity> changeEntities = service.queryList(queryParam,false);

        return CommonResponse.success(BeanMapper.mapList(changeEntities, ChangeVO.class));
    }
}
