package com.ejianc.business.pro.supplier.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 供应商准入表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_supplier_can_in")
public class CanInEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @TableField(value="code")
    private String code; // 准入编码
    @TableField(value="name")
    private String name; // 供应商名称
    @TableField(value="enterprise_nature")
    private Long enterpriseNature; // 企业性质
    @TableField(value="enterprise_nature_name")
    private String enterpriseNatureName; // 企业性质名称
    @TableField(value="enterprise_type")
    private String enterpriseType; // 制造商：maker,经销商：seller
    @TableField(value="social_credit_code")
    private String socialCreditCode; // 统一社会信用代码
    @TableField(value="address")
    private String address; // 公司地址
    @TableField(value="register_time")
    private Date registerTime; // 注册日期
    @TableField(value="register_country_id")
    private Long registerCountryId; // 注册国家id
    @TableField(value="register_country_name")
    private String registerCountryName; // 注册国家名称
    @TableField(value="legal")
    private String legal; // 法定代表人
    @TableField(value="legal_phone")
    private String legalPhone; // 法人电话
    @TableField(value="business_person")
    private String businessPerson; // 业务代表
    @TableField(value="business_phone")
    private String businessPhone; // 业务代表电话
    @TableField(value="turnover")
    private BigDecimal turnover; // 年营业额
    @TableField(value="registered_capital")
    private BigDecimal registeredCapital; // 注册资金
    @TableField(value="supply_content_id")
    private String supplyContentId; // 供货内容ids
    @TableField(value="supply_content")
    private String supplyContent; // 供货内容
    @TableField(value="business_scope")
    private String businessScope; // 经营范围
    @TableField(value="bl_time")
    private Date blTime; // 营业执照有效期
    @TableField(value="tax_payer_type")
    private String taxPayerType; // 纳税人类型:commonly 一般纳税人 smallScale 小规模纳税
    @TableField(value="billing_address")
    private String billingAddress; // 开票地址
    @TableField(value="billing_phone")
    private String billingPhone; // 开票电话
    @TableField(value="bank_name")
    private String bankName; // 开户银行
    @TableField(value="bank_account")
    private String bankAccount; // 银行账号
    @TableField(value="tenant_phone")
    private String tenantPhone; // 生成租户手机号（供方协同）
    @TableField(value="tenant_user_name")
    private String tenantUserName; // 生成租户管理员名称（供方协同）
    @TableField(value="need_co")
    private Boolean needCo; // 是否协同
    @TableField(value="org_id")
    private Long orgId; // 申请单位id
    @TableField(value="org_name")
    private String orgName; // 申请单位
    @TableField(value="personal")
    private String personal; // 个人：p，企业：e，默认e
    @TableField(value="can_in_memo")
    private String canInMemo; // 准入说明
    @TableField(value="grade_id")
    private Long gradeId; // 供应商等级id
    @TableField(value="grade_name")
    private String gradeName; // 供应商等级Name
    @TableField(value="ignore_date")
    private Date ignoreDate; // 忽略处理日期
    @TableField(value="ignore_name")
    private String ignoreName; // 忽略处理人
    @TableField(value="investigate")
    private Boolean investigate; // 是否需要考察
    @TableField(value="can_in_state")
    private String canInState; // 准入处理状态：toIn待准入，canIn准入，ignore忽略
    @TableField(value="bill_state")
    private Integer billState; // 单据状态

    @TableField(value="auth_level")
    private String authLevel; // 供应商授权等级
    @TableField(value="administration")
    private String administration; // 行政采购/非行政采购
    @TableField(value="currency_type")
    private Long currencyType; // 资金币种
    @TableField(value="real_funds")
    private BigDecimal realFunds; // 实缴资金

    @TableField(exist=false)
    @SubEntity(serviceName="canInExpertService")
    private List<CanInExpertEntity> exportList = new ArrayList<>(); // 供应商准入---考察专家列表
    @TableField(exist=false)
    @SubEntity(serviceName="certsService")
    private List<CertsEntity> certs = new ArrayList<>(); // 供应商准入---证书
    @TableField(exist=false)
    @SubEntity(serviceName="bankService")
    private List<BankEntity> banks = new ArrayList<>(); // 供应商准入---单位银行信息
    @TableField(exist=false)
    @SubEntity(serviceName="brandService",pidName = "canInId")
    private List<BrandEntity> brandList = new ArrayList<>(); // 供应商准入---品牌子表
    @TableField(exist=false)
    @SubEntity(serviceName="productionService",pidName = "canInId")
    private List<ProductionEntity> productionList = new ArrayList<>(); // 供应商准入---产品信息子表
    @TableField(exist=false)
    @SubEntity(serviceName="financeReportService")
    private List<FinanceReportEntity> financeReportList = new ArrayList<>(); // 供应商准入---财报
    @TableField(exist=false)
    @SubEntity(serviceName="historyService")
    private List<HistoryEntity> history = new ArrayList<>(); // 供应商准入---历史业绩
    @TableField(exist=false)
    @SubEntity(serviceName="factoryProductService")
    private List<FactoryProductEntity> factoryProducts = new ArrayList<>(); // 供应商准入---工厂及产品情况子表

    public List<FactoryProductEntity> getFactoryProducts() {
        return factoryProducts;
    }

    public void setFactoryProducts(List<FactoryProductEntity> factoryProducts) {
        this.factoryProducts = factoryProducts;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getEnterpriseNature() {
        return enterpriseNature;
    }

    public void setEnterpriseNature(Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }

    public String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    public void setEnterpriseNatureName(String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }

    public String getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(String enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Date getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    public Long getRegisterCountryId() {
        return registerCountryId;
    }

    public void setRegisterCountryId(Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }

    public String getRegisterCountryName() {
        return registerCountryName;
    }

    public void setRegisterCountryName(String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }

    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }

    public String getLegalPhone() {
        return legalPhone;
    }

    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }

    public String getBusinessPerson() {
        return businessPerson;
    }

    public void setBusinessPerson(String businessPerson) {
        this.businessPerson = businessPerson;
    }

    public String getBusinessPhone() {
        return businessPhone;
    }

    public void setBusinessPhone(String businessPhone) {
        this.businessPhone = businessPhone;
    }

    public BigDecimal getTurnover() {
        return turnover;
    }

    public void setTurnover(BigDecimal turnover) {
        this.turnover = turnover;
    }

    public BigDecimal getRegisteredCapital() {
        return registeredCapital;
    }

    public void setRegisteredCapital(BigDecimal registeredCapital) {
        this.registeredCapital = registeredCapital;
    }

    public String getSupplyContentId() {
        return supplyContentId;
    }

    public void setSupplyContentId(String supplyContentId) {
        this.supplyContentId = supplyContentId;
    }

    public String getSupplyContent() {
        return supplyContent;
    }

    public void setSupplyContent(String supplyContent) {
        this.supplyContent = supplyContent;
    }

    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }

    public Date getBlTime() {
        return blTime;
    }

    public void setBlTime(Date blTime) {
        this.blTime = blTime;
    }

    public String getTaxPayerType() {
        return taxPayerType;
    }

    public void setTaxPayerType(String taxPayerType) {
        this.taxPayerType = taxPayerType;
    }

    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }

    public String getBillingPhone() {
        return billingPhone;
    }

    public void setBillingPhone(String billingPhone) {
        this.billingPhone = billingPhone;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getTenantPhone() {
        return tenantPhone;
    }

    public void setTenantPhone(String tenantPhone) {
        this.tenantPhone = tenantPhone;
    }

    public String getTenantUserName() {
        return tenantUserName;
    }

    public void setTenantUserName(String tenantUserName) {
        this.tenantUserName = tenantUserName;
    }

    public Boolean getNeedCo() {
        return needCo;
    }

    public void setNeedCo(Boolean needCo) {
        this.needCo = needCo;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getPersonal() {
        return personal;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }

    public String getCanInMemo() {
        return canInMemo;
    }

    public void setCanInMemo(String canInMemo) {
        this.canInMemo = canInMemo;
    }

    public Long getGradeId() {
        return gradeId;
    }

    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }

    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }

    public Date getIgnoreDate() {
        return ignoreDate;
    }

    public void setIgnoreDate(Date ignoreDate) {
        this.ignoreDate = ignoreDate;
    }

    public String getIgnoreName() {
        return ignoreName;
    }

    public void setIgnoreName(String ignoreName) {
        this.ignoreName = ignoreName;
    }

    public Boolean getInvestigate() {
        return investigate;
    }

    public void setInvestigate(Boolean investigate) {
        this.investigate = investigate;
    }

    public String getCanInState() {
        return canInState;
    }

    public void setCanInState(String canInState) {
        this.canInState = canInState;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<BankEntity> getBanks() {
        return banks;
    }

    public void setBanks(List<BankEntity> banks) {
        this.banks = banks;
    }

    public List<CertsEntity> getCerts() {
        return certs;
    }

    public void setCerts(List<CertsEntity> certs) {
        this.certs = certs;
    }

    public List<HistoryEntity> getHistory() {
        return history;
    }

    public void setHistory(List<HistoryEntity> history) {
        this.history = history;
    }

    public List<CanInExpertEntity> getExportList() {
        return exportList;
    }

    public void setExportList(List<CanInExpertEntity> exportList) {
        this.exportList = exportList;
    }

    public List<BrandEntity> getBrandList() {
        return brandList;
    }

    public void setBrandList(List<BrandEntity> brandList) {
        this.brandList = brandList;
    }

    public List<ProductionEntity> getProductionList() {
        return productionList;
    }

    public void setProductionList(List<ProductionEntity> productionList) {
        this.productionList = productionList;
    }

    public List<FinanceReportEntity> getFinanceReportList() {
        return financeReportList;
    }

    public void setFinanceReportList(List<FinanceReportEntity> financeReportList) {
        this.financeReportList = financeReportList;
    }

    public String getAuthLevel() {
        return authLevel;
    }

    public void setAuthLevel(String authLevel) {
        this.authLevel = authLevel;
    }

    public String getAdministration() {
        return administration;
    }

    public void setAdministration(String administration) {
        this.administration = administration;
    }

    public Long getCurrencyType() {
        return currencyType;
    }

    public void setCurrencyType(Long currencyType) {
        this.currencyType = currencyType;
    }

    public BigDecimal getRealFunds() {
        return realFunds;
    }

    public void setRealFunds(BigDecimal realFunds) {
        this.realFunds = realFunds;
    }
}
