package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.BrandEntity;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.ProductionEntity;
import com.ejianc.business.pro.supplier.service.IBrandService;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IProductionService;
import com.ejianc.business.pro.supplier.vo.CanInVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.util.QRCodeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 供应商准入表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("canIn")
public class CanInController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "pro-supplier-code";//此处需要根据实际修改

    @Autowired
    private ICanInService service;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IBrandService brandService;

    @Autowired
    private IProductionService productionService;

    @Autowired
    private QRCodeUtil qrCodeUtil;

    @Autowired
    private ISupplierApi iSupplierApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CanInVO> saveOrUpdate(@RequestBody CanInVO saveOrUpdateVO) {
    	CanInEntity entity = BeanMapper.map(saveOrUpdateVO, CanInEntity.class);
        if(CollectionUtils.isNotEmpty(entity.getBrandList())){
            for(BrandEntity brand : entity.getBrandList()){
                for(ProductionEntity production : brand.getProductionsList()){
                    if("del".equals(brand.getRowState())){
                        production.setRowState("del");
                    }
                }
            }
        }
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCanInState("canIn");
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        /** 校验供应商库 */
        CommonResponse<String> exist = iSupplierApi.judgeTaxpayerNumIsRepeat(saveOrUpdateVO.getSocialCreditCode(),null, "e");
        if(!exist.isSuccess()){
            return CommonResponse.error("供应商库中：统一社会信用代码重复!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("socialCreditCode",new Parameter(QueryParam.EQ,saveOrUpdateVO.getSocialCreditCode()));
        param.getParams().put("id",new Parameter(QueryParam.NE,entity.getId()));
        List<CanInEntity> entities = service.queryList(param);
        if(ListUtil.isNotEmpty(entities)){
            return CommonResponse.error("该供应商正在走【"+entities.get(0).getOrgName()+"】的准入流程，统一社会信用代码重复!");
        }

        QueryParam params = new QueryParam();
        params.getParams().put("name",new Parameter(QueryParam.EQ,saveOrUpdateVO.getName()));
        params.getParams().put("id",new Parameter(QueryParam.NE,entity.getId()));
        entities = service.queryList(params);
        if(CollectionUtils.isNotEmpty(entities)){
            throw new BusinessException("该供应商正在走【"+entities.get(0).getOrgName()+"】的准入流程，名称重复!");
        }

        // 处理孙表
        Set<Long> set = new HashSet<>();
        if(CollectionUtils.isNotEmpty(entity.getBrandList())){
            for(BrandEntity brand : entity.getBrandList()){
                brandService.saveOrUpdate(brand, false);
                set.add(brand.getId());
            }
        }
        service.saveOrUpdate(entity, false);
        //更新孙子表里的 主表id  后续查询用
        if(CollectionUtils.isNotEmpty(entity.getBrandList())){
            LambdaUpdateWrapper<ProductionEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(ProductionEntity::getBrandId, set);
            updateWrapper.set(ProductionEntity::getCanInId, entity.getId());
            productionService.update(updateWrapper);
        }
        CanInVO vo = BeanMapper.map(entity, CanInVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 邀请供应商的提交保存
     */
    @RequestMapping(value = "/invite/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> inviteSaveOrUpdate(@RequestBody CanInVO saveOrUpdateVO) {
    	CanInEntity entity = BeanMapper.map(saveOrUpdateVO, CanInEntity.class);
        entity.setCanInState("toIn");//待准入
        if("maker".equals(entity.getEnterpriseType())&&CollectionUtils.isNotEmpty(entity.getBrandList())){
            for(BrandEntity brand : entity.getBrandList()){
                for(ProductionEntity production : brand.getProductionsList()){
                    if("del".equals(brand.getRowState())){
                        production.setRowState("del");
                    }
                }
            }
        }
        entity.setTenantId(999999L);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,999999L,saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                entity.setCode("toIn-"+ IdWorker.getId());//此处需要根据实际修改 删除本行或者下一行
            }
        }
        /** 校验供应商库 */
        CommonResponse<String> exist = iSupplierApi.judgeTaxpayerNumIsRepeat(saveOrUpdateVO.getSocialCreditCode(),null, "e");
        if(!exist.isSuccess()){
            return CommonResponse.error("该供应商信息已存在，无需再次提交!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("socialCreditCode",new Parameter(QueryParam.EQ,saveOrUpdateVO.getSocialCreditCode()));
        List<CanInEntity> entities = service.queryList(param);
        if(ListUtil.isNotEmpty(entities)){
            return CommonResponse.error("该供应商信息已存在，无需再次提交!");
        }
        QueryParam params = new QueryParam();
        params.getParams().put("name",new Parameter(QueryParam.EQ,saveOrUpdateVO.getName()));
        entities = service.queryList(params);
        if(CollectionUtils.isNotEmpty(entities)){
            throw new BusinessException("该供应商名称信息已存在，无需再次提交!");
        }
        // 处理孙表
        Set<Long> set = new HashSet<>();
        if("maker".equals(entity.getEnterpriseType())&&CollectionUtils.isNotEmpty(entity.getBrandList())){
            for(BrandEntity brand : entity.getBrandList()){
                brandService.saveOrUpdate(brand, false);
                set.add(brand.getId());
            }
        }
        service.saveOrUpdate(entity, false);
        //更新孙子表里的 主表id  后续查询用
        if("maker".equals(entity.getEnterpriseType())&&CollectionUtils.isNotEmpty(entity.getBrandList())){
            LambdaUpdateWrapper<ProductionEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(ProductionEntity::getBrandId, set);
            updateWrapper.set(ProductionEntity::getCanInId, entity.getId());
            productionService.update(updateWrapper);
        }
    	return CommonResponse.success("提交成功！");
    }


    /**
     * @Description ignoreInvite 忽略注册的供应商
     * @param ids
     */
    @RequestMapping(value = "/ignoreInvite", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> ignoreInvite(@RequestBody JSONObject json) {
        List<Long> ids = JSON.parseArray(json.getString("ids"),Long.class);
        String userName = json.getString("userName");
        QueryParam param = new QueryParam();
        param.getParams().put("id",new Parameter(QueryParam.IN,ids));
        List<CanInEntity> entities = service.queryList(param,false);
        if(ListUtil.isNotEmpty(entities)){
            entities.forEach(e -> {
                e.setCanInState("ignore");
                e.setIgnoreDate(new Date());
                e.setIgnoreName(userName);
            });
            service.saveOrUpdateBatch(entities);
        }
        return CommonResponse.success("忽略成功！");
    }

    /**
     * @Description ignoreInvite 准入注册的供应商
     * @param id
     */
    @RequestMapping(value = "/inInvite", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> inInvite(Long id,Long orgId,String orgName) {
        CanInEntity entity = service.selectById(id);
        entity.setCanInState("canIn");
        entity.setOrgId(orgId);
        entity.setOrgName(orgName);
        entity.setBillState(0);
        entity.setPersonal("e");
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("准入成功！");
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CanInVO> queryDetail(Long id) {
    	CanInEntity entity = service.selectById(id);
        if("maker".equals(entity.getEnterpriseType())&&CollectionUtils.isNotEmpty(entity.getBrandList())){
    	    //制造商需要处理子孙表
            List<Long> ids = entity.getBrandList().stream().map(x->x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("brandId", new Parameter(QueryParam.IN, ids));
            List<ProductionEntity> productionList = productionService.queryList(param);
            Map<Long, List<ProductionEntity>> hourMap = productionList.stream().collect(Collectors.groupingBy(x->x.getBrandId()));
            for(BrandEntity brand : entity.getBrandList()){
                brand.setProductionsList(hourMap.get(brand.getId()));
            }
            entity.setProductionList(null);
        }
    	CanInVO vo = BeanMapper.map(entity, CanInVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CanInVO> vos) {
        service.removeByIds(vos.stream().map(CanInVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("org_name");
        param.getFuzzyFields().add("socialCreditCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("applyOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<CanInEntity> page = service.queryPage(param,false);
        IPage<CanInVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CanInVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CanInEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CanIn-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refCanInData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> refCanInData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CanInEntity> page = service.queryPage(param,false);
        IPage<CanInVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CanInVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 获取二维码实例
     * @return
     */
    @RequestMapping(value = "/getQrCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getQrCode(){
        return CommonResponse.success("",qrCodeUtil.getBase64QRCode("https://www.baidu.com/"));
    }

}
