/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.BrandEntity;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.ProductionEntity;
import com.ejianc.business.pro.supplier.service.IBrandService;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IProductionService;
import com.ejianc.business.pro.supplier.vo.CanInVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.util.QRCodeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"canIn"})
public class CanInController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "pro-supplier-code";
    @Autowired
    private ICanInService service;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBrandService brandService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private QRCodeUtil qrCodeUtil;
    @Autowired
    private ISupplierApi iSupplierApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CanInVO> saveOrUpdate(@RequestBody CanInVO saveOrUpdateVO) {
        CommonResponse exist;
        CanInEntity entity = (CanInEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CanInEntity.class));
        if (CollectionUtils.isNotEmpty(entity.getBrandList())) {
            for (BrandEntity brand : entity.getBrandList()) {
                for (ProductionEntity production : brand.getProductionsList()) {
                    if (!"del".equals(brand.getRowState())) continue;
                    production.setRowState("del");
                }
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCanInState("canIn");
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(exist = this.iSupplierApi.judgeTaxpayerNumIsRepeat(saveOrUpdateVO.getSocialCreditCode(), null, "e")).isSuccess()) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u5e93\u4e2d\uff1a\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u91cd\u590d!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("socialCreditCode", new Parameter("eq", (Object)saveOrUpdateVO.getSocialCreditCode()));
        param.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        List entities = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)entities)) {
            return CommonResponse.error((String)("\u8be5\u4f9b\u5e94\u5546\u6b63\u5728\u8d70\u3010" + ((CanInEntity)((Object)entities.get(0))).getOrgName() + "\u3011\u7684\u51c6\u5165\u6d41\u7a0b\uff0c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u91cd\u590d!"));
        }
        QueryParam params = new QueryParam();
        params.getParams().put("name", new Parameter("eq", (Object)saveOrUpdateVO.getName()));
        params.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        entities = this.service.queryList(params);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u6b63\u5728\u8d70\u3010" + ((CanInEntity)((Object)entities.get(0))).getOrgName() + "\u3011\u7684\u51c6\u5165\u6d41\u7a0b\uff0c\u540d\u79f0\u91cd\u590d!");
        }
        HashSet<Long> set = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(entity.getBrandList())) {
            for (BrandEntity brand : entity.getBrandList()) {
                this.brandService.saveOrUpdate((Object)brand, false);
                set.add(brand.getId());
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (CollectionUtils.isNotEmpty(entity.getBrandList())) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(ProductionEntity::getBrandId, set);
            updateWrapper.set(ProductionEntity::getCanInId, (Object)entity.getId());
            this.productionService.update((Wrapper)updateWrapper);
        }
        CanInVO vo = (CanInVO)BeanMapper.map((Object)((Object)entity), CanInVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/invite/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> inviteSaveOrUpdate(@RequestBody CanInVO saveOrUpdateVO) {
        CommonResponse exist;
        CanInEntity entity = (CanInEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CanInEntity.class));
        entity.setCanInState("toIn");
        if ("maker".equals(entity.getEnterpriseType()) && CollectionUtils.isNotEmpty(entity.getBrandList())) {
            for (BrandEntity brand : entity.getBrandList()) {
                for (ProductionEntity production : brand.getProductionsList()) {
                    if (!"del".equals(brand.getRowState())) continue;
                    production.setRowState("del");
                }
            }
        }
        entity.setTenantId(999999L);
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)999999L, (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                entity.setCode("toIn-" + IdWorker.getId());
            }
        }
        if (!(exist = this.iSupplierApi.judgeTaxpayerNumIsRepeat(saveOrUpdateVO.getSocialCreditCode(), null, "e")).isSuccess()) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u518d\u6b21\u63d0\u4ea4!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("socialCreditCode", new Parameter("eq", (Object)saveOrUpdateVO.getSocialCreditCode()));
        List entities = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)entities)) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u518d\u6b21\u63d0\u4ea4!");
        }
        QueryParam params = new QueryParam();
        params.getParams().put("name", new Parameter("eq", (Object)saveOrUpdateVO.getName()));
        entities = this.service.queryList(params);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u540d\u79f0\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u518d\u6b21\u63d0\u4ea4!");
        }
        HashSet<Long> set = new HashSet<Long>();
        if ("maker".equals(entity.getEnterpriseType()) && CollectionUtils.isNotEmpty(entity.getBrandList())) {
            for (BrandEntity brand : entity.getBrandList()) {
                this.brandService.saveOrUpdate((Object)brand, false);
                set.add(brand.getId());
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if ("maker".equals(entity.getEnterpriseType()) && CollectionUtils.isNotEmpty(entity.getBrandList())) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(ProductionEntity::getBrandId, set);
            updateWrapper.set(ProductionEntity::getCanInId, (Object)entity.getId());
            this.productionService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u63d0\u4ea4\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/ignoreInvite"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> ignoreInvite(@RequestBody JSONObject json) {
        List ids = JSON.parseArray((String)json.getString("ids"), Long.class);
        String userName = json.getString("userName");
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", (Object)ids));
        List entities = this.service.queryList(param, false);
        if (ListUtil.isNotEmpty((List)entities)) {
            entities.forEach(e -> {
                e.setCanInState("ignore");
                e.setIgnoreDate(new Date());
                e.setIgnoreName(userName);
            });
            this.service.saveOrUpdateBatch(entities);
        }
        return CommonResponse.success((String)"\u5ffd\u7565\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/inInvite"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> inInvite(Long id, Long orgId, String orgName) {
        CanInEntity entity = (CanInEntity)((Object)this.service.selectById(id));
        entity.setCanInState("canIn");
        entity.setOrgId(orgId);
        entity.setOrgName(orgName);
        entity.setBillState(0);
        entity.setPersonal("e");
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u51c6\u5165\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CanInVO> queryDetail(Long id) {
        CanInEntity entity = (CanInEntity)((Object)this.service.selectById(id));
        if ("maker".equals(entity.getEnterpriseType()) && CollectionUtils.isNotEmpty(entity.getBrandList())) {
            List ids = entity.getBrandList().stream().map(x -> x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("brandId", new Parameter("in", ids));
            List productionList = this.productionService.queryList(param);
            Map<Long, List<ProductionEntity>> hourMap = productionList.stream().collect(Collectors.groupingBy(x -> x.getBrandId()));
            for (BrandEntity brand : entity.getBrandList()) {
                brand.setProductionsList(hourMap.get(brand.getId()));
            }
            entity.setProductionList(null);
        }
        CanInVO vo = (CanInVO)BeanMapper.map((Object)((Object)entity), CanInVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CanInVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("org_name");
        param.getFuzzyFields().add("socialCreditCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CanInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CanIn-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCanInData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> refCanInData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CanInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getQrCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getQrCode() {
        return CommonResponse.success((String)"", (Object)this.qrCodeUtil.getBase64QRCode("https://www.baidu.com/"));
    }
}

