package com.ejianc.business.pro.supplier.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 供应商准入邀请表
 *
 * @author generator
 *
 */
@TableName("ejc_pro_supplier_invite")
public class InviteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="apply_org_name")
    private String applyOrgName; // 申请合作单位
    @TableField(value="apply_org_id")
    private Long applyOrgId; // 申请合作单位id
    @TableField(value="apply_person")
    private String applyPerson; // 申请人
    @TableField(value="apply_person_id")
    private Long applyPersonId; // 申请人id
    @TableField(value="apply_time")
    private Date applyTime; // 申请时间
    @TableField(value="handle_person")
    private String handlePerson; // 处理人
    @TableField(value="handle_person_id")
    private Long handlePersonId; // 处理人id
    @TableField(value="handle_time")
    private Date handleTime; // 处理时间
    @TableField(value="can_in_num")
    private String canInNum; // 准入编号
    @TableField(value="supply_query_type")
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
    @TableField(value="supply_type")
    private String supplyType; // 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
    @TableField(value="supply_type_name")
    private String supplyTypeName; // 供方类别名称
    @TableField(value="personal")
    private String personal; // 个人：p，企业：e
    @TableField(value="material_content_id")
    private String materialContentId; // 物资供货内容id
    @TableField(value="material_content")
    private String materialContent; // 物资供货内容名称
    @TableField(value="material_memo")
    private String materialMemo; // 物资补充描述
    @TableField(value="equipment_content_id")
    private String equipmentContentId; // 设备供货内容id
    @TableField(value="equipment_content")
    private String equipmentContent; // 设备供货内容
    @TableField(value="equipment_memo")
    private String equipmentMemo; // 设备补充描述
    @TableField(value="major_content_id")
    private String majorContentId; // 专业分包供货内容id
    @TableField(value="major_content")
    private String majorContent; // 专业分包供货内容
    @TableField(value="major_memo")
    private String majorMemo; // 专业分包补充描述
    @TableField(value="labor_content_id")
    private String laborContentId; // 劳务分包供货内容id
    @TableField(value="labor_content")
    private String laborContent; // 劳务分包供货内容
    @TableField(value="labor_memo")
    private String laborMemo; // 劳务分包补充描述
    @TableField(value="sub_content_id")
    private String subContentId; // 分包班组供货内容id
    @TableField(value="sub_content")
    private String subContent; // 分包班组供货内容
    @TableField(value="sub_memo")
    private String subMemo; // 分包班组补充描述
    @TableField(value="other_content_id")
    private String otherContentId; // 其他供货内容id
    @TableField(value="other_content")
    private String otherContent; // 其他供货内容
    @TableField(value="other_memo")
    private String otherMemo; // 其他补充描述
    @TableField(value="enterprise_nature")
    private Long enterpriseNature; // 企业性质id
    @TableField(value="enterprise_nature_name")
    private String enterpriseNatureName; // 企业性质名称
    @TableField(value="taxpayer_num")
    private String taxpayerNum; // 纳税人识别号/身份证号
    @TableField(value="legal_person")
    private String legalPerson; // 法人代表/别名
    @TableField(value="legal_phone")
    private String legalPhone; // 法人电话/联系电话
    @TableField(value="area")
    private String area; // 所在地区
    @TableField(value="area_name")
    private String areaName; // 所在地区名称
    @TableField(value="address")
    private String address; // 公司地址
    @TableField(value="business_range")
    private String businessRange; // 经营范围
    @TableField(value="time_out")
    private Date timeOut; // 有效期
    @TableField(value="register_date")
    private Date registerDate; // 注册日期
    @TableField(value="register_mny")
    private BigDecimal registerMny; // 注册资金
    @TableField(value="turnover")
    private BigDecimal turnover; // 年营业额
    @TableField(value="check_result")
    private Integer checkResult; // 校验是否通过
    @TableField(value="ocr_json_str")
    private String ocrJsonStr; // 营业执照或者身份证百度OCR识别结果
    @TableField(exist=false)
    @SubEntity(serviceName="bankService")
    private List<BankEntity> banks = new ArrayList<>(); // 供应商准入---单位银行信息
    @TableField(exist=false)
    @SubEntity(serviceName="certsService")
    private List<CertsEntity> certs = new ArrayList<>(); // 供应商准入---证书

    public String getOcrJsonStr() {
        return ocrJsonStr;
    }

    public void setOcrJsonStr(String ocrJsonStr) {
        this.ocrJsonStr = ocrJsonStr;
    }

    public Integer getCheckResult() {
        return checkResult;
    }

    public void setCheckResult(Integer checkResult) {
        this.checkResult = checkResult;
    }

    public List<BankEntity> getBanks() {
        return banks;
    }

    public void setBanks(List<BankEntity> banks) {
        this.banks = banks;
    }

    public List<CertsEntity> getCerts() {
        return certs;
    }

    public void setCerts(List<CertsEntity> certs) {
        this.certs = certs;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    public String getApplyPerson() {
        return applyPerson;
    }

    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }
    public Long getApplyPersonId() {
        return applyPersonId;
    }

    public void setApplyPersonId(Long applyPersonId) {
        this.applyPersonId = applyPersonId;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public String getHandlePerson() {
        return handlePerson;
    }

    public void setHandlePerson(String handlePerson) {
        this.handlePerson = handlePerson;
    }
    public Long getHandlePersonId() {
        return handlePersonId;
    }

    public void setHandlePersonId(Long handlePersonId) {
        this.handlePersonId = handlePersonId;
    }
    public Date getHandleTime() {
        return handleTime;
    }

    public void setHandleTime(Date handleTime) {
        this.handleTime = handleTime;
    }
    public String getCanInNum() {
        return canInNum;
    }

    public void setCanInNum(String canInNum) {
        this.canInNum = canInNum;
    }
    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }
    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }
    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    public String getPersonal() {
        return personal;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }
    public String getMaterialContentId() {
        return materialContentId;
    }

    public void setMaterialContentId(String materialContentId) {
        this.materialContentId = materialContentId;
    }
    public String getMaterialContent() {
        return materialContent;
    }

    public void setMaterialContent(String materialContent) {
        this.materialContent = materialContent;
    }
    public String getMaterialMemo() {
        return materialMemo;
    }

    public void setMaterialMemo(String materialMemo) {
        this.materialMemo = materialMemo;
    }
    public String getEquipmentContentId() {
        return equipmentContentId;
    }

    public void setEquipmentContentId(String equipmentContentId) {
        this.equipmentContentId = equipmentContentId;
    }
    public String getEquipmentContent() {
        return equipmentContent;
    }

    public void setEquipmentContent(String equipmentContent) {
        this.equipmentContent = equipmentContent;
    }
    public String getEquipmentMemo() {
        return equipmentMemo;
    }

    public void setEquipmentMemo(String equipmentMemo) {
        this.equipmentMemo = equipmentMemo;
    }
    public String getMajorContentId() {
        return majorContentId;
    }

    public void setMajorContentId(String majorContentId) {
        this.majorContentId = majorContentId;
    }
    public String getMajorContent() {
        return majorContent;
    }

    public void setMajorContent(String majorContent) {
        this.majorContent = majorContent;
    }
    public String getMajorMemo() {
        return majorMemo;
    }

    public void setMajorMemo(String majorMemo) {
        this.majorMemo = majorMemo;
    }
    public String getLaborContentId() {
        return laborContentId;
    }

    public void setLaborContentId(String laborContentId) {
        this.laborContentId = laborContentId;
    }
    public String getLaborContent() {
        return laborContent;
    }

    public void setLaborContent(String laborContent) {
        this.laborContent = laborContent;
    }
    public String getLaborMemo() {
        return laborMemo;
    }

    public void setLaborMemo(String laborMemo) {
        this.laborMemo = laborMemo;
    }
    public String getSubContentId() {
        return subContentId;
    }

    public void setSubContentId(String subContentId) {
        this.subContentId = subContentId;
    }
    public String getSubContent() {
        return subContent;
    }

    public void setSubContent(String subContent) {
        this.subContent = subContent;
    }
    public String getSubMemo() {
        return subMemo;
    }

    public void setSubMemo(String subMemo) {
        this.subMemo = subMemo;
    }
    public String getOtherContentId() {
        return otherContentId;
    }

    public void setOtherContentId(String otherContentId) {
        this.otherContentId = otherContentId;
    }
    public String getOtherContent() {
        return otherContent;
    }

    public void setOtherContent(String otherContent) {
        this.otherContent = otherContent;
    }
    public String getOtherMemo() {
        return otherMemo;
    }

    public void setOtherMemo(String otherMemo) {
        this.otherMemo = otherMemo;
    }
    public Long getEnterpriseNature() {
        return enterpriseNature;
    }

    public void setEnterpriseNature(Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }
    public String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    public void setEnterpriseNatureName(String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }
    public String getTaxpayerNum() {
        return taxpayerNum;
    }

    public void setTaxpayerNum(String taxpayerNum) {
        this.taxpayerNum = taxpayerNum;
    }
    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    public String getLegalPhone() {
        return legalPhone;
    }

    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getBusinessRange() {
        return businessRange;
    }

    public void setBusinessRange(String businessRange) {
        this.businessRange = businessRange;
    }
    public Date getTimeOut() {
        return timeOut;
    }

    public void setTimeOut(Date timeOut) {
        this.timeOut = timeOut;
    }
    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }
    public BigDecimal getRegisterMny() {
        return registerMny;
    }

    public void setRegisterMny(BigDecimal registerMny) {
        this.registerMny = registerMny;
    }
    public BigDecimal getTurnover() {
        return turnover;
    }

    public void setTurnover(BigDecimal turnover) {
        this.turnover = turnover;
    }

}
