package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.ISubcontractUpgradeService;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.business.pro.supplier.vo.EvaluateHistoryVO;
import com.ejianc.business.pro.supplier.vo.SubcontractUpgradeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.service.ISubcontractPunishService;
import com.ejianc.business.pro.supplier.vo.SubcontractPunishVO;

/**
 * 分包供应商处置
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subcontractPunish")
public class SubcontractPunishController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ISubcontractUpgradeService subcontractUpgradeService;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISubcontractPunishService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IGradeService gradeService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubcontractPunishVO> saveOrUpdate(@RequestBody SubcontractPunishVO saveOrUpdateVO) {
    	SubcontractPunishEntity entity = BeanMapper.map(saveOrUpdateVO, SubcontractPunishEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(getBillCode(entity),InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        QueryParam param = new QueryParam();
        param.getParams().put("supplyId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getSupplyId()));
        param.getParams().put("billState",new Parameter(QueryParam.IN,"0,4"));
        param.getParams().put("supplyType", new Parameter(QueryParam.EQ, saveOrUpdateVO.getSupplyType()));
        List<SubcontractPunishEntity> list= service.queryList(param);
        if(ListUtil.isNotEmpty(list) && list.get(0).getId()!=null && !list.get(0).getId().equals(entity.getId())){
            return CommonResponse.error("该供应商存在未生效的单据！");
        }

        QueryParam upgradeParam = new QueryParam();
        upgradeParam.getParams().put("supplyId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getSupplyId()));
        upgradeParam.getParams().put("billState",new Parameter(QueryParam.IN,"0,4"));
        upgradeParam.getParams().put("supplyQueryType", new Parameter(QueryParam.EQ, saveOrUpdateVO.getSupplyType()));
        List<SubcontractUpgradeEntity> upgradeList= subcontractUpgradeService.queryList(upgradeParam);
        if(CollectionUtils.isNotEmpty(upgradeList)){
            return CommonResponse.error("该供应商评级有流程尚未审批不能添加！");
        }

        GradeEntity oldGrade =gradeService.getById(saveOrUpdateVO.getOldGrade());
        GradeEntity gradeEntity =gradeService.getById(saveOrUpdateVO.getGradeId());
        if(gradeEntity.getWeight() > oldGrade.getWeight()){
            return CommonResponse.error("评定等级必须小于原等级！");
        }

        entity.setSupplyQueryType(saveOrUpdateVO.getSupplyType());
        service.saveOrUpdate(entity, false);
    	SubcontractPunishVO vo = BeanMapper.map(entity, SubcontractPunishVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    private String getBillCode(SubcontractPunishEntity entity){
        if(entity.getSubcontractType() == 0){
            if("labor".equals(entity.getSupplyType())){
                return "pro-supplier-cz-lw";
            }else if("major".equals(entity.getSupplyType())){
                return "pro-supplier-cz-zy";
            }
        }else {
            return "pro-supplier-cz-lwfzr";
        }
        return "pro-supplier-cz-lw";
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractPunishVO> queryDetail(Long id) {
    	SubcontractPunishEntity entity = service.selectById(id);
    	SubcontractPunishVO vo = BeanMapper.map(entity, SubcontractPunishVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractPunishVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SubcontractPunishVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SubcontractPunishVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubcontractPunishVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("applyDate", "desc");

        param.setOrderMap(orderMap);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空

        IPage<SubcontractPunishEntity> page = service.queryPage(param,false);
        IPage<SubcontractPunishVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractPunishVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplyQueryType", new Parameter(QueryParam.EQ, SupplierQueryType.laborSub));        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
       // param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubcontractPunishEntity> list = service.queryList(param);
        List<SubcontractPunishVO> voList = new ArrayList<>();

        if(list.size()>0){
            voList = BeanMapper.mapList(list, SubcontractPunishVO.class);
            for (SubcontractPunishVO vo: voList){
                if(vo.getSubcontractType() != null){
                    if(vo.getSubcontractType().equals(0)){
                        vo.setSubcontractTypeName("供应商处置");
                    }else if(vo.getSubcontractType().equals(1)){
                        vo.setSubcontractTypeName("负责人处置");
                    }
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("subcontractPunish-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubcontractPunishData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubcontractPunishVO>> refSubcontractPunishData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);

        }

        IPage<SubcontractPunishEntity> page = service.queryPage(param,false);
        IPage<SubcontractPunishVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractPunishVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
     }


}
