package com.ejianc.business.pro.supplier.controller.appraise;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.pro.supplier.service.appraise.AppraiseService;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.micrometer.core.instrument.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author songlx
 * @version 1.0
 * @description: 评价接口
 * @date 2022/4/24
 */
@Controller
@RequestMapping("appraise")
public class AppraiseController implements Serializable {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    IContractPoolApi contractPoolApi;

    @Autowired
    ISettlePoolApi settlePoolApi;

    @Autowired
    AppraiseService appraiseService;

    private static String RULE_CODE = "P-k202Ay57";

    @Autowired
    IParamConfigApi paramConfigApi;

    /**
     * 年度评价推送日期前查询是否有履约中、已冻结的合同本年度没有生成过程评价、事件评价；
     * 如果没有自动根据合同维度自动推送一条过程评价
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/checkAndPushProcessAppraise")
    public CommonResponse<String> checkAndPushProcessAppraise(HttpServletRequest request) {
        //获取定时任务配置的参数
        AppraiseParamVO appraiseParamVO = this.getParamVO(request);
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd");
        String curDateStr = sdf.format(new Date());
        //校验当前是否是执行日期
        if(StringUtils.isEmpty(appraiseParamVO.getCheckDate())){
            logger.info("供应商过程评价检测任务：当前未到设置的周期。");
            return null;
        }
        if(!curDateStr.equals(appraiseParamVO.getCheckDate())) {
            logger.info("供应商过程评价检测任务：当前未非任务执行的日期。");
            return null;
        }

        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(RULE_CODE);
        if (!byCode.isSuccess()) {
            logger.info("未获取到供应商评价规则，规则编码:{}", RULE_CODE);
            return CommonResponse.success("未获取到供应商评价规则！");
        }
        String ruleName = byCode.getData().getValueData();
        logger.info("获取到供应商评价规则，规则名称:{}", ruleName);
        appraiseParamVO.setRuleName(ruleName);
        boolean rs = appraiseService.checkAndPushProcessAppraise(appraiseParamVO);
        if(rs) {
            return CommonResponse.success("执行任务成功！");
        }
        return CommonResponse.error("执行任务失败");
    }

    /**
     * @description: 推送过程评价
     * @author songlx
     * @date: 2022/4/24
     */
    @PostMapping(value = "/pushProcessAppraise")
    public CommonResponse<AppraiseResultVO> pushProcessAppraise(HttpServletRequest request) {
        //获取定时任务配置的参数
        AppraiseParamVO appraiseParamVO = this.getParamVO(request);
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(RULE_CODE);
        if (!byCode.isSuccess()) {
            logger.info("未获取到供应商评价规则，规则编码:{}", RULE_CODE);
            return CommonResponse.success("未获取到供应商评价规则！");
        }
        String ruleName = byCode.getData().getValueData();
        logger.info("获取到供应商评价规则，规则名称:{}", ruleName);
        appraiseParamVO.setRuleName(ruleName);
        AppraiseResultVO appraiseResultVO = appraiseService.pushProcessAppraise(appraiseParamVO);
        return CommonResponse.success(appraiseResultVO);
    }

    private AppraiseParamVO getParamVO(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param);
        logger.info("获取到的参数JSON是：" + param + "----");
        JSONArray parameters = json.getJSONObject(0).getJSONArray("parameters");
        AppraiseParamVO appraiseParamVO = new AppraiseParamVO();
        for (int i = 0; i < parameters.size(); i++) {
            JSONObject obj = parameters.getJSONObject(i);
            String property = (String) obj.get("property");
            switch (property) {
                case "contractMny":
                    appraiseParamVO.setContractMny(obj.getBigDecimal("value"));
                    break;
                case "settleContractRatio":
                    appraiseParamVO.setSettleContractRatio(obj.getBigDecimal("value"));
                    break;
                case "spaceLastDays":
                    appraiseParamVO.setSpaceLastDays(obj.getInteger("value"));
                    break;
                case "yearPushDate":
                    appraiseParamVO.setYearPushDate(obj.getString("value"));
                    break;
                case "contractType":
                    appraiseParamVO.setContractType(obj.getString("value"));
                    break;
                case "subManageFlag":
                    appraiseParamVO.setSubManageFlag(obj.getString("value"));
                    break;
                case "checkPushDate":
                    appraiseParamVO.setCheckDate(obj.getString("value"));
                default:
                    ;
            }
        }
        return appraiseParamVO;
    }

    /**
     * @description: 推送年度评价
     * @author songlx
     * @date: 2022/4/24
     */
    @PostMapping(value = "/pushYearAppraise")
    public CommonResponse<AppraiseResultVO> pushYearAppraise(HttpServletRequest request) {
        //获取定时任务配置的参数
        AppraiseParamVO appraiseParamVO = this.getParamVO(request);
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(RULE_CODE);
        if (!byCode.isSuccess()) {
            logger.info("未获取到供应商评价规则，规则编码:{}", RULE_CODE);
            return CommonResponse.success("未获取到供应商评价规则！");
        }
        appraiseParamVO.setRuleName(byCode.getData().getValueData());
        AppraiseResultVO appraiseResultVO = appraiseService.pushYearAppraise(appraiseParamVO);
        return CommonResponse.success(appraiseResultVO);
    }


}
