package com.ejianc.business.pro.supplier.service.appraise;

import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;

/**
 * @author songlx
 * @description: 评价服务方法
 * @date: 2022/4/24
 */
public interface AppraiseStrategy {


    /**
     * @param appraiseParamVO
     * @description: 推送过程评价
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author songlx
     * @date: 2022/4/24
     */
    AppraiseResultVO pushProcessAppraise(AppraiseParamVO appraiseParamVO);


    /**
     * @param appraiseParamVO
     * @description: 推送年度评价
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author songlx
     * @date: 2022/4/24
     */
    AppraiseResultVO pushYearAppraise(AppraiseParamVO appraiseParamVO);

    /**
     * 查询（年度评价推送日期-X天）是否有履约中、已冻结的合同本年度没有生成过程评价、事件评价；
     * 如果没有自动根据合同维度自动推送一条过程评价
     *
     * @param appraiseParamVO
     * @return
     */
    boolean checkAndPushProcessAppraise(AppraiseParamVO appraiseParamVO);
}
