package com.ejianc.business.pro.supplier.service.appraise;

import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.vo.IncidentVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.util.SupplyQueryTypeUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("pushProcessLogic")
public class PushProcessRuleALogic implements PushProcessLogic {
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "INCIDENT";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;

    @Override
    public List<IncidentVO> logicOne(AppraiseParamVO appraiseParamVO) {
        List<ContractPoolVO> pushProcessList = new ArrayList<>();
        List<IncidentVO> processList = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ,
                ContractPerformanceStateEnum.履约中.getStateCode()));
        queryParam.getParams().put("sourceType", new Parameter(QueryParam.IN,
                Arrays.asList(new String[]{ContractTypeEnum.设备采购.getTypeCode(), ContractTypeEnum.设备租赁.getTypeCode(),
                        ContractTypeEnum.物资采购合同.getTypeCode(), ContractTypeEnum.周转材合同.getTypeCode(),ContractTypeEnum.劳务分包合同.getTypeCode(),ContractTypeEnum.专业分包合同.getTypeCode(),ContractTypeEnum.其他收入合同.getTypeCode()})));
        CommonResponse<List<ContractPoolVO>> listCommonResponse = contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess()) {
            List<ContractPoolVO> contractPoolVOList = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(contractPoolVOList)) {
                //逻辑一 条件一: 合同金额大于设置的金额
                List<ContractPoolVO> contractList =
                        contractPoolVOList.stream().filter(s->s.getContractTaxMny()!=null).filter(s -> (s.getContractTaxMny().compareTo(appraiseParamVO.getContractMny()) != -1)).collect(Collectors.toList());
                Map<Long, ContractPoolVO> contractPoolMap =
                        contractList.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));
                if (CollectionUtils.isNotEmpty(contractList)) {
                    List<Long> contractIds =
                            contractList.stream().map(ContractPoolVO::getId).collect(Collectors.toList());
                    //逻辑一 条件二: 合同结算金额大于合同金额
                    QueryParam settleQueryParam = new QueryParam();
                    settleQueryParam.getParams().put("contractId", new Parameter(QueryParam.IN, contractIds));
                    CommonResponse<List<SettlePoolVO>> settleCommonResponse = settlePoolApi.queryList(settleQueryParam);
                    if (settleCommonResponse.isSuccess()) {
                        List<SettlePoolVO> settlePoolList = settleCommonResponse.getData();
                        if (CollectionUtils.isNotEmpty(settlePoolList)) {
                            Map<Long, BigDecimal> settlePoolMap = settlePoolList.stream().filter(s->s.getContractId()!=null).
                                    collect(Collectors.groupingBy(SettlePoolVO::getContractId,
                                            Collectors.reducing(BigDecimal.ZERO, SettlePoolVO::getCurTaxMny,
                                                    BigDecimal::add)));
                            Set<Long> contractIdSet = settlePoolMap.keySet();
                            for (Long contractId : contractIdSet) {
                                //合同金额 添加
                                BigDecimal contractTaxMny = contractPoolMap.get(contractId).getContractTaxMny();
                                //结算金额
                                BigDecimal settleTaxMny = settlePoolMap.get(contractId);
                                //建百分比转成小数
                                BigDecimal settleContractRatio =
                                        ComputeUtil.safeDiv(appraiseParamVO.getSettleContractRatio(),
                                        new BigDecimal(100));
                                BigDecimal settleContractMny = ComputeUtil.safeMultiply(contractTaxMny,
                                        settleContractRatio);
                                //结算金额 大于 合同金额
                                if (settleTaxMny.compareTo(settleContractMny) != -1) {
                                    pushProcessList.add(contractPoolMap.get(contractId));
                                }
                            }
                            List<Long> pushProcessContractIds =
                                    pushProcessList.stream().map(ContractPoolVO::getId).collect(Collectors.toList());
                            //没有满足两个条件 返回 null
                            if (CollectionUtils.isEmpty(pushProcessContractIds)) {
                                return null;
                            }
                            QueryParam queryIncidentParam = new QueryParam();
                            queryIncidentParam.getParams().put("contractId", new Parameter(QueryParam.IN,
                                    pushProcessContractIds));
                            queryIncidentParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ,
                                    ContractPerformanceStateEnum.履约中.getStateCode()));
                            List<IncidentEntity> incidentEntities = incidentService.queryList(queryIncidentParam, false);
                            //在一个逻辑中一个履约中合同只能存在一个过程评价
                            //1:合同id 和过程评价的数量相等 这些合同id 全部做过程评价
                            if (incidentEntities.size() == pushProcessContractIds.size()) {
                                return null;
                            }
                            //这些合同id 没有做过工程评价
                            PushProcessRuleALogic pushProcessRuleALogic = new PushProcessRuleALogic();
                            if (incidentEntities.size() == 0) {
                                processList = pushProcessRuleALogic.getProcessList(pushProcessList, null,userApi,billCodeApi,sessionManager);
                                return processList;
                            }
                            //找出没有做过程结算的合同
                            Map<Long, List<IncidentEntity>> map =
                                    incidentEntities.stream().collect(Collectors.groupingBy(IncidentEntity::getContractId));
                            processList = pushProcessRuleALogic.getProcessList(pushProcessList, map,userApi,billCodeApi,sessionManager);
                            return processList;
                        }
                    }
                }
            }
        }
        return processList;
    }

    @Override
    public List<IncidentVO> logicTwo(AppraiseParamVO appraiseParamVO) {
        List<IncidentVO> processList = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ,
                ContractPerformanceStateEnum.已终止.getStateCode()));
        queryParam.getParams().put("sourceType", new Parameter(QueryParam.IN,
                Arrays.asList(new String[]{ContractTypeEnum.设备采购.getTypeCode(), ContractTypeEnum.设备租赁.getTypeCode(),
                        ContractTypeEnum.物资采购合同.getTypeCode(), ContractTypeEnum.周转材合同.getTypeCode(),ContractTypeEnum.劳务分包合同.getTypeCode(),ContractTypeEnum.专业分包合同.getTypeCode(),ContractTypeEnum.其他收入合同.getTypeCode()})));
        CommonResponse<List<ContractPoolVO>> listCommonResponse = contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess()) {
            List<ContractPoolVO> contractPoolVOList = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(contractPoolVOList)) {
                List<Long> contractPoolIds =
                        contractPoolVOList.stream().map(ContractPoolVO::getId).collect(Collectors.toList());
                QueryParam queryIncidentParam = new QueryParam();
                queryIncidentParam.getParams().put("contractId", new Parameter(QueryParam.IN, contractPoolIds));
                queryIncidentParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ,
                        ContractPerformanceStateEnum.已终止.getStateCode()));
                List<IncidentEntity> incidentEntities = incidentService.queryList(queryIncidentParam, false);
                //找出没有做过程评价的
                PushProcessRuleALogic pushProcessRuleALogic = new PushProcessRuleALogic();
                if (incidentEntities.size() == 0) {
                    processList = pushProcessRuleALogic.getProcessList(contractPoolVOList, null,userApi,billCodeApi,sessionManager);
                    return processList;
                } else {
                    Map<Long, List<IncidentEntity>> map =
                            incidentEntities.stream().collect(Collectors.groupingBy(IncidentEntity::getContractId));
                    processList = pushProcessRuleALogic.getProcessList(contractPoolVOList, map,userApi,billCodeApi,sessionManager);
                    return processList;
                }
            }
        }
        return processList;
    }

    public   List<IncidentVO> getProcessList(List<ContractPoolVO> pushProcessList,  Map<Long, List<IncidentEntity>> map, IUserApi userApi,IBillCodeApi billCodeApi,SessionManager sessionManager) {
        List<IncidentVO> list = new ArrayList<>();
        pushProcessList.forEach(e -> {
            if (map == null) {
                IncidentVO incidentVO = new IncidentVO();
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,
                        InvocationInfoProxy.getTenantid());
                if (billCode.isSuccess()) {
                    incidentVO.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                incidentVO.setContractId(e.getContractId());
                incidentVO.setPerformanceStatus(e.getPerformanceStatus());
                incidentVO.setStatus(0);
                incidentVO.setCreateUserId(InvocationInfoProxy.getUserid());
                CommonResponse<UserVO> voCommonResponse = userApi.findUserByUserId(InvocationInfoProxy.getUserid());
                if (voCommonResponse.isSuccess()) {
                    UserVO user = voCommonResponse.getData();
                    incidentVO.setCreateUserName(user.getUserName());
                    incidentVO.setPhone(user.getUserMobile());
                }
                incidentVO.setProcessId(sessionManager.getUserContext().getUserId());
                incidentVO.setProcess(sessionManager.getUserContext().getUserName());
                incidentVO.setContractType(e.getSourceType());
                incidentVO.setContractName(e.getContractName());
                incidentVO.setProjectId(e.getProjectId());
                incidentVO.setProjectName(e.getProjectName());
                incidentVO.setContractAmount(e.getContractTaxMny());
                incidentVO.setSupplyId(e.getPartybId());
                incidentVO.setSupplyName(e.getPartyaName());
                String supplyQueryType = SupplyQueryTypeUtil.get("RULE_A", e.getSourceType());
                incidentVO.setSupplyQueryType(supplyQueryType);
                incidentVO.setCheckOrgId(sessionManager.getUserContext().getOrgId());
                incidentVO.setCheckOrgName(sessionManager.getUserContext().getOrgName());
                incidentVO.setDate(new Date());
                incidentVO.setSource("定时推送");
                list.add(incidentVO);
            } else {
                if (!map.containsKey(e.getContractId())) {
                    IncidentVO incidentVO = new IncidentVO();
                    CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,
                            InvocationInfoProxy.getTenantid());
                    if (billCode.isSuccess()) {
                        incidentVO.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    incidentVO.setContractId(e.getContractId());
                    incidentVO.setPerformanceStatus(e.getPerformanceStatus());
                    incidentVO.setStatus(0);
                    incidentVO.setCreateUserId(InvocationInfoProxy.getUserid());
                    CommonResponse<UserVO> voCommonResponse = userApi.findUserByUserId(InvocationInfoProxy.getUserid());
                    if (voCommonResponse.isSuccess()) {
                        UserVO user = voCommonResponse.getData();
                        incidentVO.setCreateUserName(user.getUserName());
                        incidentVO.setPhone(user.getUserMobile());
                    }
                    incidentVO.setProcessId(sessionManager.getUserContext().getUserId());
                    incidentVO.setProcess(sessionManager.getUserContext().getUserName());
                    incidentVO.setContractType(e.getSourceTypeName());
                    incidentVO.setContractName(e.getContractName());
                    incidentVO.setProjectId(e.getProjectId());
                    incidentVO.setProjectName(e.getProjectName());
                    incidentVO.setContractAmount(e.getContractTaxMny());
                    incidentVO.setSupplyId(e.getPartybId());
                    incidentVO.setSupplyName(e.getPartyaName());
                    String supplyQueryType = SupplyQueryTypeUtil.get("RULE_A", e.getSourceType());
                    incidentVO.setSupplyQueryType(supplyQueryType);
                    incidentVO.setCheckOrgId(sessionManager.getUserContext().getOrgId());
                    incidentVO.setCheckOrgName(sessionManager.getUserContext().getOrgName());
                    incidentVO.setDate(new Date());
                    incidentVO.setSource("定时推送");
                    list.add(incidentVO);
                }
            }
        });
        return list;
    }
}
