package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplyVO;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.bean.ProcessEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractIncidentEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractProcessEntity;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.service.ISubcontractIncidentService;
import com.ejianc.business.pro.supplier.service.ISubcontractProcessService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.IncidentVO;
import com.ejianc.business.pro.supplier.vo.appraise.*;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import groovy.util.logging.Slf4j;
import io.micrometer.core.instrument.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author songlx
 * @version 1.0
 * @description: 云南建投评价策略
 * @date 2022/4/24
 */

@Component("rule_a_appraise")
@Slf4j
public class RuleAAppraiseStrategy implements AppraiseStrategy {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private YearAppraiseService yearAppraiseService;
    @Autowired
    IShareSupplierApi shareSupplierApi;
    @Autowired
    IProSupplierApi proSupplierApi;
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private PushProcessLogic pushProcessLogic;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ISubcontractProcessService subcontractProcessService;
    @Autowired
    private ISubcontractIncidentService subcontractIncidentService;

    /**
     * @param appraiseParamVO
     * @description: 推送过程评价
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author songlx
     * @date: 2022/4/24
     */
    @Override
    public AppraiseResultVO pushProcessAppraise(AppraiseParamVO appraiseParamVO) {
        List<IncidentVO> list = new ArrayList<>();
        //逻辑一
        List<IncidentVO> logicOneVos = pushProcessLogic.logicOne(appraiseParamVO);
        //逻辑二
        List<IncidentVO> logicTwoVos = pushProcessLogic.logicTwo(appraiseParamVO);
        //合并两个 list
        if (CollectionUtils.isNotEmpty(logicOneVos)){
            list.addAll(logicOneVos);
        }
        if (CollectionUtils.isNotEmpty(logicTwoVos)){
            list.addAll(logicTwoVos);
        }
        List<IncidentEntity> entitys = BeanMapper.mapList(list, IncidentEntity.class);
        if (CollectionUtils.isNotEmpty(entitys)){
            incidentService.saveOrUpdateBatch(entitys,entitys.size());
        }
        AppraiseResultVO appraiseResultVO=new AppraiseResultVO();
        return appraiseResultVO;
    }


    public List<ContVo> getSubGrade(Long supplyId,String startDate,String endDate){
        // 获取本年度过程、事件评价数据
        QueryWrapper<SubcontractProcessEntity> processWrapper = new QueryWrapper<>();
        processWrapper.eq("supply_id",supplyId);
        processWrapper.in("bill_state",1,3);
        processWrapper.ge("create_time",startDate);
        processWrapper.le("date_format(create_time,'%Y-%m-%d')",endDate);
        List<SubcontractProcessEntity> processlist = subcontractProcessService.list(processWrapper);

        QueryWrapper<SubcontractIncidentEntity> incidentWrapper = new QueryWrapper<>();
        incidentWrapper.eq("supply_id",supplyId);
        incidentWrapper.in("bill_state",1,3);
        incidentWrapper.ge("create_time",startDate);
        incidentWrapper.le("date_format(create_time,'%Y-%m-%d')",endDate);
        List<SubcontractIncidentEntity> incidentList = subcontractIncidentService.list(incidentWrapper);
        List<ContVo> contVos = yearAppraiseService.sumSubProGrade(processlist, incidentList);
        return contVos;
    }


    /**
     * @param appraiseParamVO
     * @description: 推送年度评价
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author songlx
     * @date: 2022/4/24
     */
    @Override
    public AppraiseResultVO pushYearAppraise(AppraiseParamVO appraiseParamVO) {
        // 获取年度评价周期
        String startDate = yearAppraiseService.getStartDate(appraiseParamVO);
        String endDate = DateUtil.getYear() + "-" + appraiseParamVO.getYearPushDate();
        if(StringUtils.isEmpty(startDate)){
            logger.info("当前未到设置的周期。");
            return null;
        }
        if(startDate.equals(endDate)){
            logger.info("今日已经执行过推送。");
            return null;
        }

        // 获取本年度过程、事件评价数据
        QueryWrapper<ProcessEntity> processWrapper = new QueryWrapper<>();
        processWrapper.in("bill_state",1,3);
        processWrapper.ge("create_time",startDate);
        processWrapper.le("date_format(create_time,'%Y-%m-%d')",endDate);
        List<ProcessEntity> processlist = processService.list(processWrapper);

        QueryWrapper<IncidentEntity> incidentWrapper = new QueryWrapper<>();
        incidentWrapper.in("bill_state",1,3);
        incidentWrapper.ge("create_time",startDate);
        incidentWrapper.le("date_format(create_time,'%Y-%m-%d')",endDate);
        List<IncidentEntity> incidentList = incidentService.list(incidentWrapper);
        // 供应商set
        Set<Long> supplySet = new HashSet<>();
        for (ProcessEntity entity:processlist) {
            supplySet.add(entity.getSupplyId());
        }
        for (IncidentEntity entity:incidentList) {
            supplySet.add(entity.getSupplyId());
        }

        // 去重后的供应商ids
        List<Long> supplyIds = new ArrayList<>(supplySet);


        if(CollectionUtils.isEmpty(supplyIds)){
            logger.info("没有生效态的过程评价和事件评价，供应商id集合为空。无需推送！");
            return null;
        }

        // 获取供应商数据
        logger.info("供应商id:"+supplyIds);
        Map<String,List<Long>> map = new HashMap<>();
        map.put("ids",supplyIds);
        CommonResponse<List<SupplierDTO>> shareSupplierList = proSupplierApi.queryPostSupplierByIds(map);
        String s = JSONObject.toJSONString(shareSupplierList);
        logger.info("json:"+s);

        Map<Long, SupplierVO> shareSupplierMap = new HashMap<>();
        if(!shareSupplierList.isSuccess() || null == shareSupplierList.getData()){
            logger.info("查询供应商数据失败。");
            return null;
        }
        List<SupplierVO> vos = BeanMapper.mapList(shareSupplierList.getData(), SupplierVO.class);
        for (SupplierVO vo:vos) {
            shareSupplierMap.put(vo.getId(),vo);
        }
        // 获取供应商对应的合同数据(计算总合同额,项目维度统计扣分,按照供应商分类区分)
        SupplyVO supplyVO = new SupplyVO();
        supplyVO.setSupplierIds(supplyIds);
        supplyVO.setStartDate(startDate);
        supplyVO.setEndDate(endDate);

        CommonResponse<JSONArray> contractList = contractPoolApi.getContractList(supplyVO);
        logger.info("contractList:"+ JSONObject.toJSONString(contractList));
        if(!contractList.isSuccess() || contractList.getData() == null){
            logger.info("查询合同池数据失败！");
            return null;
        }
        List<ContractDTO> contractListS = new ArrayList<>();
        for (Object object:contractList.getData()) {
            String str = JSONObject.toJSONString(object);
            logger.info("str:"+str);
            ContractDTO dto = JSONObject.parseObject(str,ContractDTO.class);
            contractListS.add(dto);
        }
        logger.info("contractList.getData():"+JSONObject.toJSONString(contractList.getData()));
        //统计扣分项目(供应商维度、项目维度)
        Map<Long, SupplySubVo> longSupplySubVoMap = yearAppraiseService.sumSubGrade(processlist, incidentList);
        logger.info("longSupplySubVoMap"+longSupplySubVoMap);
        // 计算合同额数据集
        Map<Long,SupplyBaseVo> supplyBaseMap = yearAppraiseService.getSupplyResult("RULE_A",contractListS);
        logger.info("supplyBaseMap"+supplyBaseMap);
        // 根据规则计算供应商年度评价结果
        List<AppraiseResultVO> appraiseResultVOList = yearAppraiseService.calGradeA(supplyBaseMap, shareSupplierMap, longSupplySubVoMap, supplyIds,startDate);
        // 推送数据
        yearAppraiseService.sendData(appraiseResultVOList);

        return null;
    }

    @Override
    public boolean checkAndPushProcessAppraise(AppraiseParamVO appraiseParamVO) {
        logger.error("策略A检查并推送过程评价逻辑未实现！！！");
        return true;
    }


}
