package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.dto.SubleaderContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.vo.HeadUserVO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplyVO;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.bean.ProcessEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractIncidentEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractProcessEntity;
import com.ejianc.business.pro.supplier.dto.HearUserDTO;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.service.ISubcontractIncidentService;
import com.ejianc.business.pro.supplier.service.ISubcontractProcessService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;
import com.ejianc.business.pro.supplier.vo.appraise.SupplyBaseVo;
import com.ejianc.business.pro.supplier.vo.appraise.SupplySubVo;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.api.IShareSubleadersApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import groovy.util.logging.Slf4j;
import io.micrometer.core.instrument.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author songlx
 * @version 1.0
 * @description: 郑州一建评价策略
 * @date 2022/4/24
 */

@Component("rule_b_appraise")
@Slf4j
public class RuleBAppraiseStrategy implements AppraiseStrategy {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private YearAppraiseService yearAppraiseService;
    @Autowired
    IShareSupplierApi shareSupplierApi;
    @Autowired
    IShareSubleadersApi shareSubleadersApi;
    @Autowired
    IProSupplierApi proSupplierApi;
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    private IProcessService processService;
    @Autowired
    IPushProcessRuleBLogic pushProcessRuleBLogic;
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private ISubcontractProcessService subcontractProcessService;
    @Autowired
    private ISubcontractIncidentService subcontractIncidentService;

    /**
     * @param appraiseParamVO
     * @description: 推送过程评价
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author songlx
     * @date: 2022/4/24
     */
    @Override
    public AppraiseResultVO pushProcessAppraise(AppraiseParamVO appraiseParamVO) {

        //逻辑一
        pushProcessRuleBLogic.logicOne(appraiseParamVO);
        //逻辑二
        pushProcessRuleBLogic.logicTwo(appraiseParamVO);

        AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
        return appraiseResultVO;
    }

    /**
     * @param appraiseParamVO
     * @description: 推送年度评价
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author songlx
     * @date: 2022/4/24
     */
    @Override
    public AppraiseResultVO pushYearAppraise(AppraiseParamVO appraiseParamVO) {
        // 获取年度评价周期
        String startDate = yearAppraiseService.getStartDate(appraiseParamVO);
        String endDate = DateUtil.getYear() + "-" + appraiseParamVO.getYearPushDate();
        if (StringUtils.isEmpty(startDate)) {
            logger.info("当前未到设置的周期。");
            return null;
        }
        if (startDate.equals(endDate)) {
            logger.info("今日已经执行过推送。");
            return null;
        }

        logger.info("推送分包负责人年度评价--start");
        // 获取本年度过程、事件评价数据
        QueryWrapper<ProcessEntity> processWrapper = new QueryWrapper<>();
        processWrapper.in("bill_state", 1, 3);
        processWrapper.ge("create_time", startDate);
        processWrapper.eq("evaluation_obj_state", 2);
        processWrapper.le("date_format(create_time,'%Y-%m-%d')", endDate);
        List<ProcessEntity> processlist1 = processService.list(processWrapper);

        QueryWrapper<IncidentEntity> incidentWrapper = new QueryWrapper<>();
        incidentWrapper.in("bill_state", 1, 3);
        incidentWrapper.eq("evaluation_obj_state", 2);
        incidentWrapper.ge("create_time", startDate);
        incidentWrapper.le("date_format(create_time,'%Y-%m-%d')", endDate);
        List<IncidentEntity> incidentList1 = incidentService.list(incidentWrapper);


        List<Long> pushedHeadUserIdsOrSupplyIds = yearAppraiseService.getPushedHeadUserIdsOrSupplyIds(DateUtil.getYear(), null);

        // 分包负责人set
        Set<Long> headUserIdSet = new HashSet<>();
        //合同ids
        Set<Long> contractIdsForHead = new HashSet<>();
        // 统计分值 总 事件 过程
        Map<Long, HearUserDTO> hearUserDTOMap = new HashMap<>();
        for (ProcessEntity entity : processlist1) {
            headUserIdSet.add(entity.getHeadUserId());
            contractIdsForHead.add(entity.getContractId());
            if (hearUserDTOMap.get(entity.getHeadUserId()) != null) {
                HearUserDTO hearUserDTO = hearUserDTOMap.get(entity.getHeadUserId());
                hearUserDTO.setSumBranch((hearUserDTO.getSumBranch() == null ? BigDecimal.ZERO : hearUserDTO.getSumBranch()).add(entity.getBuckleBranch()));
                hearUserDTO.setSjBranch((hearUserDTO.getSjBranch() == null ? BigDecimal.ZERO : hearUserDTO.getSjBranch()).add(entity.getBuckleBranch()));
                hearUserDTOMap.put(entity.getHeadUserId(), hearUserDTO);
            } else {
                HearUserDTO hearUserDTO = new HearUserDTO();
                hearUserDTO.setSumBranch(entity.getBuckleBranch());
                hearUserDTO.setSjBranch(entity.getBuckleBranch());
                hearUserDTOMap.put(entity.getHeadUserId(), hearUserDTO);
            }
        }
        for (IncidentEntity entity : incidentList1) {
            headUserIdSet.add(entity.getHeadUserId());
            contractIdsForHead.add(entity.getContractId());
            if (hearUserDTOMap.get(entity.getHeadUserId()) != null) {
                HearUserDTO hearUserDTO = hearUserDTOMap.get(entity.getHeadUserId());
                hearUserDTO.setSumBranch((hearUserDTO.getSumBranch() == null ? BigDecimal.ZERO : hearUserDTO.getSumBranch()).add(entity.getBuckleBranch()));
                hearUserDTO.setGcBranch((hearUserDTO.getGcBranch() == null ? BigDecimal.ZERO : hearUserDTO.getGcBranch()).add(entity.getBuckleBranch()));
                hearUserDTOMap.put(entity.getHeadUserId(), hearUserDTO);
            } else {
                HearUserDTO hearUserDTO = new HearUserDTO();
                hearUserDTO.setSumBranch(entity.getBuckleBranch());
                hearUserDTO.setGcBranch(entity.getBuckleBranch());
                hearUserDTOMap.put(entity.getHeadUserId(), hearUserDTO);
            }
        }
        logger.info("需要推送的分包负责人id：{}", headUserIdSet);
        logger.info("已推送的分包负责人id：{}", pushedHeadUserIdsOrSupplyIds);
        //已推送过的移除掉
        headUserIdSet.removeAll(pushedHeadUserIdsOrSupplyIds);
        if (CollectionUtils.isEmpty(headUserIdSet)) {
            logger.info("需要推送的分包负责人id集合为空。无需推送！");
        } else {
            Map<String, List<Long>> idsMap = new HashMap<>();
            idsMap.put("ids", new ArrayList<>(headUserIdSet));
            logger.info("ids:" + headUserIdSet);
            CommonResponse<List<SubleadersVO>> subleaderListCom = shareSubleadersApi.getSubleaderList(idsMap);
            logger.info("subleaderListCom:" + JSONObject.toJSONString(subleaderListCom));
            if (subleaderListCom.isSuccess()) {
                List<SubleadersVO> data = subleaderListCom.getData();
                Set<Long> suplyIds = new HashSet<>();
                for (SubleadersVO item : data
                ) {
                    suplyIds.add(item.getPid());
                }
                Map<String, List<Long>> map = new HashMap<>();
                map.put("ids", new ArrayList<>(suplyIds));
                CommonResponse<List<SupplierDTO>> shareSupplierList = proSupplierApi.queryPostSupplierByIds(map);
                Map<Long, SupplierVO> shareSupplierMap = new HashMap<>();
                if (!shareSupplierList.isSuccess() || null == shareSupplierList.getData()) {
                    logger.info("查询供应商数据失败。");
                    return null;
                }
                // 获取对应分包负责人合同池的数据 start
                HeadUserVO headUserVO = new HeadUserVO();
                headUserVO.setContractIds(new ArrayList<>(contractIdsForHead));
                CommonResponse<JSONArray> contractList = contractPoolApi.getContractListByHeadUser(headUserVO);
                logger.info("contractList:" + JSONObject.toJSONString(contractList));
                if (!contractList.isSuccess() || contractList.getData() == null) {
                    logger.info("查询合同池数据失败！");
                    return null;
                }
                List<SubleaderContractDTO> contractListS = new ArrayList<>();
                for (Object object : contractList.getData()) {
                    String str = JSONObject.toJSONString(object);
                    logger.info("str:" + str);
                    SubleaderContractDTO dto = JSONObject.parseObject(str, SubleaderContractDTO.class);
                    contractListS.add(dto);
                }
                logger.info("contractListS:" + JSONObject.toJSONString(contractListS));
                logger.info("hearUserDTOMap:" + JSONObject.toJSONString(hearUserDTOMap));
                for (SubleaderContractDTO item : contractListS
                ) {
                    if (null != hearUserDTOMap.get(item.getHeadUserId())) {
                        HearUserDTO hearUserDTO = hearUserDTOMap.get(item.getHeadUserId());
                        hearUserDTO.setContCount(hearUserDTO.getContCount() + 1);
                        hearUserDTO.addPro(item.getProjectId());
                        boolean b = hearUserDTO.addContractTaxMny(item.getContractTaxMny());
                        if (b) {
                            hearUserDTO.setMaxOrgId(item.getParentOrgId());
                            hearUserDTO.setMaxOrgName(item.getParentOrgName());
                            hearUserDTO.setMaxOrgCode(item.getParentOrgCode());
                        }
                        hearUserDTOMap.put(item.getHeadUserId(), hearUserDTO);
                    } else {
                        HearUserDTO hearUserDTO = new HearUserDTO();
                        hearUserDTO.setContCount(hearUserDTO.getContCount() + 1);
                        hearUserDTO.addPro(item.getProjectId());
                        boolean b = hearUserDTO.addContractTaxMny(item.getContractTaxMny());
                        if (b) {
                            hearUserDTO.setMaxOrgId(item.getParentOrgId());
                            hearUserDTO.setMaxOrgName(item.getParentOrgName());
                            hearUserDTO.setMaxOrgCode(item.getParentOrgCode());
                        }
                        hearUserDTOMap.put(item.getHeadUserId(), hearUserDTO);
                    }
                }
                logger.info("hearUserDTOMap####:" + JSONObject.toJSONString(hearUserDTOMap));
                List<SupplierVO> vos = BeanMapper.mapList(shareSupplierList.getData(), SupplierVO.class);
                for (SupplierVO item : vos
                ) {
                    shareSupplierMap.put(item.getId(), item);
                }
                List<AppraiseResultVO> appraiseResultVOList = yearAppraiseService.calSubleader(hearUserDTOMap, data, shareSupplierMap, startDate);
                yearAppraiseService.sendData(appraiseResultVOList);
            }
        }

        logger.info("推送分包负责人年度评价--end");

        // 获取本年度过程、事件评价数据
        processWrapper = new QueryWrapper<>();
        processWrapper.in("bill_state", 1, 3);
        processWrapper.ge("create_time", startDate);
        incidentWrapper.apply(" (evaluation_obj_state = 1 or evaluation_obj_state is null)");
        processWrapper.le("date_format(create_time,'%Y-%m-%d')", endDate);
        List<ProcessEntity> processlist = processService.list(processWrapper);

        incidentWrapper = new QueryWrapper<>();
        incidentWrapper.in("bill_state", 1, 3);
        incidentWrapper.apply(" (evaluation_obj_state = 1 or evaluation_obj_state is null)");
        incidentWrapper.ge("create_time", startDate);
        incidentWrapper.le("date_format(create_time,'%Y-%m-%d')", endDate);
        List<IncidentEntity> incidentList = incidentService.list(incidentWrapper);
        // 供应商set
        Set<Long> supplySet = new HashSet<>();
        //合同ids
        Set<Long> contractIds = new HashSet<>();
        for (ProcessEntity entity : processlist) {
            supplySet.add(entity.getSupplyId());
            contractIds.add(entity.getContractId());
        }
        for (IncidentEntity entity : incidentList) {
            supplySet.add(entity.getSupplyId());
            contractIds.add(entity.getContractId());
        }

        //已推送过的移除掉
        supplySet.removeAll(pushedHeadUserIdsOrSupplyIds);

        if (CollectionUtils.isEmpty(supplySet)) {
            logger.info("需要推送的供应商id集合为空。无需推送！");
            return null;
        }

        // 去重后的供应商ids
        List<Long> supplyIds = new ArrayList<>(supplySet);
        logger.info("supplyIds:" + supplyIds);
        logger.info("processlist:" + JSONObject.toJSONString(processlist));
        logger.info("incidentList:" + JSONObject.toJSONString(incidentList));


        // 获取供应商数据
        Map<String, List<Long>> map = new HashMap<>();
        map.put("ids", supplyIds);
        CommonResponse<List<SupplierDTO>> shareSupplierList = proSupplierApi.queryPostSupplierByIds(map);
        String s = JSONObject.toJSONString(shareSupplierList);
        logger.info("json:" + s);

        Map<Long, SupplierVO> shareSupplierMap = new HashMap<>();
        if (!shareSupplierList.isSuccess() || null == shareSupplierList.getData()) {
            logger.info("查询供应商数据失败。");
            return null;
        }
        List<SupplierVO> vos = BeanMapper.mapList(shareSupplierList.getData(), SupplierVO.class);
        for (SupplierVO vo : vos) {
            shareSupplierMap.put(vo.getId(), vo);
        }
        // 获取供应商对应的合同数据(计算总合同额,项目维度统计扣分,按照供应商分类区分)
        SupplyVO supplyVO = new SupplyVO();
        supplyVO.setContractIds(new ArrayList<>(contractIds));
        /*supplyVO.setSupplierIds(supplyIds);
        supplyVO.setStartDate(startDate);
        supplyVO.setEndDate(endDate);*/

        CommonResponse<JSONArray> contractList = contractPoolApi.getContractList(supplyVO);
        logger.info("contractList:" + JSONObject.toJSONString(contractList));
        if (!contractList.isSuccess() || contractList.getData() == null) {
            logger.info("查询合同池数据失败！");
            return null;
        }
        List<ContractDTO> contractListS = new ArrayList<>();
        for (Object object : contractList.getData()) {
            String str = JSONObject.toJSONString(object);
            logger.info("str:" + str);
            ContractDTO dto = JSONObject.parseObject(str, ContractDTO.class);
            contractListS.add(dto);
        }
        //统计扣分项目(供应商维度、项目维度)
        Map<Long, SupplySubVo> longSupplySubVoMap = yearAppraiseService.sumSubGrade(processlist, incidentList);
        // 计算合同额数据集
        Map<Long, SupplyBaseVo> supplyBaseMap = yearAppraiseService.getSupplyResult("RULE_B", contractListS);
        // 根据规则计算供应商年度评价结果
        List<AppraiseResultVO> appraiseResultVOList = yearAppraiseService.calGradeB(supplyBaseMap, shareSupplierMap, longSupplySubVoMap, supplyIds, startDate);

        logger.info("shareSupplierMap:" + JSONObject.toJSONString(shareSupplierMap));
        logger.info("longSupplySubVoMap:" + JSONObject.toJSONString(longSupplySubVoMap));
        logger.info("supplyBaseMap:" + JSONObject.toJSONString(supplyBaseMap));
        logger.info("appraiseResultVOList:" + JSONObject.toJSONString(appraiseResultVOList));
        // 推送数据
        yearAppraiseService.sendData(appraiseResultVOList);

        return null;
    }

    @Override
    public boolean checkAndPushProcessAppraise(AppraiseParamVO appraiseParamVO) {
        try {
            pushProcessRuleBLogic.checkAndPushProcessAppraise(appraiseParamVO);
            return true;
        } catch (Exception e) {
            logger.error("检测并推送过程评价任务执行异常：", e);
            return false;
        }
    }

    public List<Map<String, Object>> getSubGrade2(Long supplyId, String startDate, String endDate, Integer evaluationObjState, String contractType, Long headUserId) {
        // 获取本年度过程、事件评价数据
        QueryWrapper<SubcontractProcessEntity> processWrapper = new QueryWrapper<>();
        processWrapper.eq("supply_id", supplyId);
        processWrapper.in("bill_state", 1, 3);
        if (evaluationObjState!= null && evaluationObjState == 2) {
            processWrapper.eq("evaluation_obj_state", evaluationObjState);
            processWrapper.eq("head_user_id", headUserId); //只查询匹配的分包负责人信息
        } else {
            processWrapper.apply(" (evaluation_obj_state = 1 or evaluation_obj_state is null)");
        }
        processWrapper.ge("create_time", startDate);
        processWrapper.le("date_format(create_time,'%Y-%m-%d')", endDate);
        List<SubcontractProcessEntity> processlist = subcontractProcessService.list(processWrapper);

        QueryWrapper<SubcontractIncidentEntity> incidentWrapper = new QueryWrapper<>();
        incidentWrapper.eq("supply_id", supplyId);
        incidentWrapper.in("bill_state", 1, 3);
        if (evaluationObjState != null && evaluationObjState == 2) {
            incidentWrapper.eq("evaluation_obj_state", evaluationObjState);
            incidentWrapper.eq("head_user_id", headUserId); //只查询匹配的分包负责人信息
        } else {
            incidentWrapper.apply(" (evaluation_obj_state = 1 or evaluation_obj_state is null)");
        }
        incidentWrapper.ge("create_time", startDate);
        incidentWrapper.le("date_format(create_time,'%Y-%m-%d')", endDate);
        List<SubcontractIncidentEntity> incidentList = subcontractIncidentService.list(incidentWrapper);
        List<Map<String, Object>> vos = yearAppraiseService.sumSubProGrade2(processlist, incidentList, supplyId, contractType);
        return vos;
    }

}
